/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.label.ActorImageLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.PersonTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeCastPanel
extends JPanel {
    private final TvShowEpisodeSelectionModel selectionModel;
    private EventList<Person> actorEventList = null;
    private TmmTable tableActors;
    private ActorImageLabel lblActorImage;
    private JLabel lblDirector;
    private JLabel lblWriter;

    public TvShowEpisodeCastPanel(TvShowEpisodeSelectionModel model) {
        this.selectionModel = model;
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.initComponents();
        this.initDataBindings();
        this.lblActorImage.enableLightbox();
        this.lblActorImage.setCacheUrl(true);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowEpisodeSelectionModel.class) {
                return;
            }
            if ("selectedTvShowEpisode".equals(property) || "actors".equals(property)) {
                this.actorEventList.clear();
                this.actorEventList.addAll(this.selectionModel.getSelectedTvShowEpisode().getActors());
                if (!this.actorEventList.isEmpty()) {
                    this.tableActors.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableActors.getSelectionModel().addListSelectionListener(arg0 -> {
            if (!arg0.getValueIsAdjusting()) {
                int selectedRow = this.tableActors.convertRowIndexToModel(this.tableActors.getSelectedRow());
                if (selectedRow >= 0 && selectedRow < this.actorEventList.size()) {
                    Person actor = (Person)this.actorEventList.get(selectedRow);
                    this.lblActorImage.setActor(this.selectionModel.getSelectedTvShowEpisode().getTvShow(), actor);
                } else {
                    this.lblActorImage.clearImage();
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow][150lp,grow]", "[][][200lp,grow][grow]"));
        TmmLabel lblDirectorT = new TmmLabel(TmmResourceBundle.getString("metatag.director"));
        this.add((Component)lblDirectorT, "cell 0 0");
        this.lblDirector = new JLabel("");
        this.add((Component)this.lblDirector, "cell 1 0 2 1,growx,wmin 0");
        TmmLabel lblWriterT = new TmmLabel(TmmResourceBundle.getString("metatag.writer"));
        this.add((Component)lblWriterT, "cell 0 1");
        this.lblWriter = new JLabel("");
        this.add((Component)this.lblWriter, "cell 1 1 2 1,growx,wmin 0");
        TmmLabel lblActorsT = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        this.add((Component)lblActorsT, "cell 0 2,aligny top");
        this.tableActors = new PersonTable(this.actorEventList){

            @Override
            public void onPersonChanged(Person person) {
                super.onPersonChanged(person);
                TvShowEpisodeCastPanel.this.selectionModel.getSelectedTvShowEpisode().saveToDb();
                TvShowEpisodeCastPanel.this.selectionModel.getSelectedTvShowEpisode().writeNFO();
            }
        };
        this.tableActors.setName("tvshows.episode.actorTable");
        TmmUILayoutStore.getInstance().install(this.tableActors);
        JScrollPane scrollPaneActors = new JScrollPane();
        this.tableActors.configureScrollPane(scrollPaneActors);
        this.add((Component)scrollPaneActors, "cell 1 2 1 2,grow");
        this.lblActorImage = new ActorImageLabel();
        this.add((Component)this.lblActorImage, "cell 2 2,grow");
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.directorsAsString");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblDirector, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.writersAsString");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblWriter, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }
}

