/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.wizard.DisclaimerPanel;
import org.tinymediamanager.ui.wizard.EntrancePanel;
import org.tinymediamanager.ui.wizard.MovieScraperPanel;
import org.tinymediamanager.ui.wizard.MovieSourcePanel;
import org.tinymediamanager.ui.wizard.TvShowScraperPanel;
import org.tinymediamanager.ui.wizard.TvShowSourcePanel;
import org.tinymediamanager.ui.wizard.UiSettingsPanelLite;

public class TinyMediaManagerWizard
extends TmmDialog {
    private final List<JPanel> panels;
    private int activePanelIndex = 0;
    private BackAction actBack;
    private NextAction actNext;
    private JButton btnBack;
    private JButton btnNext;
    private JPanel panelContent;

    public TinyMediaManagerWizard() {
        super((JFrame)null, "tinyMediaManager Setup Wizard", "");
        this.setMinimumSize(new Dimension(800, 600));
        this.initComponents();
        this.panels = new ArrayList<JPanel>();
        this.panels.add(new EntrancePanel());
        this.panels.add(new DisclaimerPanel(this));
        this.panels.add(new UiSettingsPanelLite());
        this.panels.add(new MovieSourcePanel());
        this.panels.add(new MovieScraperPanel());
        this.panels.add(new TvShowSourcePanel());
        this.panels.add(new TvShowScraperPanel());
        for (int i = 0; i < this.panels.size(); ++i) {
            JPanel panel = this.panels.get(i);
            this.panelContent.add((Component)panel, "" + i);
        }
        this.btnBack.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Utils.deleteFileSafely(Paths.get(Globals.DATA_FOLDER, "tmm.json"));
                System.exit(0);
            }
        });
    }

    private void initComponents() {
        JPanel panelSizing = new JPanel();
        this.getContentPane().add((Component)panelSizing, "Center");
        panelSizing.setLayout((LayoutManager)new MigLayout("", "[650lp:850lp,grow]", "[450lp:550lp,grow]"));
        this.panelContent = new JPanel();
        this.panelContent.setLayout(new CardLayout());
        panelSizing.add((Component)this.panelContent, "cell 0 0,grow");
        this.actBack = new BackAction();
        this.btnBack = new JButton(this.actBack);
        this.addButton(this.btnBack);
        this.actNext = new NextAction();
        this.btnNext = new JButton(this.actNext);
        this.addDefaultButton(this.btnNext);
    }

    JButton getBtnBack() {
        return this.btnBack;
    }

    JButton getBtnNext() {
        return this.btnNext;
    }

    @Override
    public void pack() {
    }

    private void setNextButtonLabel() {
        this.actNext.setButtonLabel();
    }

    private boolean isLastPanel() {
        return this.panels != null && this.activePanelIndex >= this.panels.size() - 1;
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("Name", TmmResourceBundle.getString("wizard.back"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            --TinyMediaManagerWizard.this.activePanelIndex;
            if (TinyMediaManagerWizard.this.activePanelIndex > 0) {
                TinyMediaManagerWizard.this.btnBack.setEnabled(true);
            } else {
                TinyMediaManagerWizard.this.btnBack.setEnabled(false);
            }
            TinyMediaManagerWizard.this.setNextButtonLabel();
            CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
            cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
            TinyMediaManagerWizard.this.panelContent.revalidate();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            this.setButtonLabel();
        }

        void setButtonLabel() {
            if (TinyMediaManagerWizard.this.isLastPanel()) {
                this.putValue("Name", TmmResourceBundle.getString("wizard.finish"));
            } else {
                this.putValue("Name", TmmResourceBundle.getString("wizard.next"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++TinyMediaManagerWizard.this.activePanelIndex;
            if (TinyMediaManagerWizard.this.activePanelIndex == TinyMediaManagerWizard.this.panels.size()) {
                TmmModuleManager.getInstance().saveSettings();
                MovieModuleManager.getInstance().getSettings().firePropertyChange("wizard", false, true);
                TvShowModuleManager.getInstance().getSettings().firePropertyChange("wizard", false, true);
                TinyMediaManagerWizard.this.setVisible(false);
            } else {
                TinyMediaManagerWizard.this.btnBack.setEnabled(true);
                TinyMediaManagerWizard.this.setNextButtonLabel();
                CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
                cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
                TinyMediaManagerWizard.this.panelContent.revalidate();
            }
        }
    }
}

