/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;
import org.tinymediamanager.ui.tvshows.TvShowScraper;

class TvShowScraperPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<TvShowScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableScraper;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;

    TvShowScraperPanel() {
        MediaScraper defaultMediaScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableMediaScrapers()) {
            TvShowScraper tvShowScraper = new TvShowScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                tvShowScraper.setDefaultScraper(true);
                selectedIndex = counter;
            }
            this.scrapers.add(tvShowScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            int row;
            TvShowScraper changedScraper;
            if (arg0.getColumn() == 0 && (changedScraper = this.scrapers.get(row = arg0.getFirstRow())).getDefaultScraper().booleanValue()) {
                this.settings.setScraper(changedScraper.getScraperId());
                for (TvShowScraper scraper : this.scrapers) {
                    if (scraper == changedScraper) continue;
                    scraper.setDefaultScraper(Boolean.FALSE);
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][400lp,grow]"));
        JLabel lblTvShowScraper = new JLabel(TmmResourceBundle.getString("wizard.tvshow.scraper"));
        this.add((Component)lblTvShowScraper, "cell 0 0");
        JPanel panelTvShowScrapers = new JPanel();
        this.add((Component)panelTvShowScrapers, "cell 0 1,grow");
        panelTvShowScrapers.setLayout((LayoutManager)new MigLayout("", "[][][500lp,grow]", "[150lp:300lp][][]"));
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelTvShowScrapers.add((Component)scrollPaneScraper, "cell 0 0 2 1,grow");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowScraperPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        scrollPaneScraper.setViewportView(this.tableScraper);
        NoBorderScrollPane scrollPaneScraperDetails = new NoBorderScrollPane();
        panelTvShowScrapers.add((Component)scrollPaneScraperDetails, "cell 2 0 1 2,grow");
        scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][]"));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,growx,aligny top");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,growx,aligny top");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelTvShowScrapers.add((Component)lblScraperLanguage, "cell 0 1");
        this.cbScraperLanguage = new JComboBox();
        this.cbScraperLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.valuesSorted()));
        panelTvShowScrapers.add(this.cbScraperLanguage, "cell 1 1");
        JLabel lblCountry = new JLabel(TmmResourceBundle.getString("Settings.certificationCountry"));
        panelTvShowScrapers.add((Component)lblCountry, "cell 0 2");
        this.cbCertificationCountry = new JComboBox();
        this.cbCertificationCountry.setModel(new DefaultComboBoxModel<CountryCode>(CountryCode.values()));
        panelTvShowScrapers.add(this.cbCertificationCountry, "cell 1 2");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty tvShowScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.default")).setColumnClass(Boolean.class);
        BeanProperty tvShowScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_1).setColumnClass(Icon.class).setEditable(false);
        BeanProperty tvShowScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
    }
}

