/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.tasks.TvShowRemoveDatasourceTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;

class TvShowSourcePanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JList<String> listDataSources;

    public TvShowSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        JLabel lblDataSource = new JLabel(TmmResourceBundle.getString("wizard.tvshow.datasources"));
        TmmFontHelper.changeFont(lblDataSource, 1.3333, 1);
        this.add((Component)lblDataSource, "cell 0 0");
        JPanel panelTvShowDataSources = new JPanel();
        this.add((Component)panelTvShowDataSources, "cell 0 1,grow");
        panelTvShowDataSources.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[][grow]"));
        ReadOnlyTextArea tpDatasourceHint = new ReadOnlyTextArea(TmmResourceBundle.getString("wizard.datasource.hint"));
        panelTvShowDataSources.add((Component)tpDatasourceHint, "cell 0 0 2 1,growx");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelTvShowDataSources.add((Component)scrollPaneDataSources, "cell 0 1,grow");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        SquareIconButton btnAdd = new SquareIconButton(IconManager.ADD_INV);
        panelTvShowDataSources.add((Component)btnAdd, "flowy,cell 1 1,aligny top");
        btnAdd.setToolTipText(TmmResourceBundle.getString("Button.add"));
        btnAdd.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.tvshowdatasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
            }
        });
        SquareIconButton btnRemove = new SquareIconButton(IconManager.REMOVE_INV);
        panelTvShowDataSources.add((Component)btnRemove, "cell 1 1");
        btnRemove.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        btnRemove.addActionListener(arg0 -> {
            int row = this.listDataSources.getSelectedIndex();
            if (row != -1) {
                String path = this.settings.getTvShowDataSource().get(row);
                Object[] choices = new String[]{TmmResourceBundle.getString("Button.continue"), TmmResourceBundle.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(this, String.format(TmmResourceBundle.getString("Settings.tvshowdatasource.remove.info"), path), TmmResourceBundle.getString("Settings.datasource.remove"), 0, -1, null, choices, TmmResourceBundle.getString("Button.abort"));
                if (decision == 0) {
                    if (TmmTaskManager.getInstance().isMainTaskRunning()) {
                        JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("Settings.datasource.remove.hint"));
                    }
                    TmmTaskManager.getInstance().addMainTask(new TvShowRemoveDatasourceTask(path));
                }
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDataSources);
        jListBinding.bind();
    }
}

