/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlType;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.ExtDataBlock;
import org.tinymediamanager.library.bluray.playlist.ExtDataEntry;

@XmlType(propOrder={"extDataEntry", "paddingL1", "extDataBlock"})
public class ExtensionData {
    private ExtDataEntry[] extDataEntry;
    private int paddingL1;
    private ExtDataBlock[] extDataBlock;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        dataInputStream.skipBytes(4);
        int n2 = dataInputStream.readInt();
        dataInputStream.skipBytes(3);
        int n3 = dataInputStream.readUnsignedByte();
        ExtDataEntry[] extDataEntryArray = new ExtDataEntry[n3];
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            extDataEntryArray[n] = new ExtDataEntry();
            extDataEntryArray[n].readObject(dataInputStream);
            dataInputStream.skipBytes(4);
            nArray[n] = dataInputStream.readInt();
        }
        this.setExtDataEntry(extDataEntryArray);
        n = (n2 - (12 + n3 * 12)) / 4;
        this.setPaddingL1(n);
        ExtDataBlock[] extDataBlockArray = new ExtDataBlock[n3];
        for (int i = 0; i < n3; ++i) {
            ExtDataBlock.BlockType blockType = extDataEntryArray[i].getID1() == 1 && extDataEntryArray[i].getID2() == 1 ? ExtDataBlock.BlockType.pip_metadata : ExtDataBlock.BlockType.unknown;
            extDataBlockArray[i] = new ExtDataBlock(blockType, nArray[i]);
            extDataBlockArray[i].readObject(dataInputStream);
        }
        this.setExtDataBlock(extDataBlockArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[3];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ExtDataBlock[] extDataBlockArray = this.getExtDataBlock();
        int[] nArray = new int[extDataBlockArray.length];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < extDataBlockArray.length; ++i) {
            extDataBlockArray[i].writeObject(dataOutputStream2);
            dataOutputStream2.flush();
            n2 = n3;
            nArray[i] = n3 = byteArrayOutputStream.size() - n2;
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        int n4 = 12 + 12 * this.getExtDataEntry().length + 4 * this.getPaddingL1();
        int n5 = n4 + byteArrayOutputStream.size() - 4;
        dataOutputStream.writeInt(n5);
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray);
        ExtDataEntry[] extDataEntryArray = this.getExtDataEntry();
        dataOutputStream.writeByte(extDataEntryArray.length);
        int n6 = n4;
        for (n = 0; n < extDataEntryArray.length; ++n) {
            extDataEntryArray[n].writeObject(dataOutputStream);
            dataOutputStream.writeInt(n6);
            dataOutputStream.writeInt(nArray[n]);
            n6 += nArray[n];
        }
        for (n = 0; n < this.getPaddingL1(); ++n) {
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    public ExtDataEntry[] getExtDataEntry() {
        return this.extDataEntry;
    }

    public void setExtDataEntry(ExtDataEntry[] extDataEntryArray) {
        this.extDataEntry = extDataEntryArray;
    }

    public int getPaddingL1() {
        return this.paddingL1;
    }

    public void setPaddingL1(int n) {
        this.paddingL1 = n;
    }

    public ExtDataBlock[] getExtDataBlock() {
        return this.extDataBlock;
    }

    public void setExtDataBlock(ExtDataBlock[] extDataBlockArray) {
        this.extDataBlock = extDataBlockArray;
    }
}

