/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.ace.api;

import com.google.common.annotations.VisibleForTesting;
import com.ubnt.ace.api.ApiServlet;
import com.ubnt.ace.api.C;
import com.ubnt.ace.api.G;
import com.ubnt.ace.api.H;
import com.ubnt.ace.api.O;
import com.ubnt.ace.api.O0OO;
import com.ubnt.ace.api.OOOo;
import com.ubnt.ace.api.P;
import com.ubnt.ace.api.T;
import com.ubnt.data.B;
import com.ubnt.data.Device;
import com.ubnt.data.DeviceFeature;
import com.ubnt.data.DeviceType;
import com.ubnt.data.Model;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.Setting;
import com.ubnt.data.X;
import com.ubnt.service.ooOO;
import com.ubnt.service.system.kA;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ApiUtils {
    private static final Logger super = kA.\u00f4o0000;

    private ApiUtils() {
    }

    public static Map<String, G> mapHandlers(List<G> list) {
        HashMap<String, G> hashMap = new HashMap<String, G>();
        for (G g2 : list) {
            String string = ApiUtils.class(g2);
            hashMap.put(string, g2);
        }
        return hashMap;
    }

    private static String class(G g2) {
        P p2 = g2.getClass().getAnnotation(P.class);
        if (p2 == null) {
            throw new RuntimeException("Missing ApiCommand for: " + g2.getClass().getName());
        }
        return p2.\u00d200000();
    }

    public static List<X> execute(Map<String, G> map, String string, X x2, X x3) {
        G g2 = map.get(string);
        if (g2 != null) {
            return ApiUtils.execute(g2, x2, x3);
        }
        return X.dosuper;
    }

    public static List<X> execute(G g2, X x2, X x3) {
        T[] tArray;
        for (T t2 : tArray = ApiUtils.\u00f400000(g2)) {
            t2.\u00d500000(x2, x3);
        }
        O0OO o0OO2 = g2.getClass().getAnnotation(O0OO.class);
        if (o0OO2 != null) {
            ApiUtils.\u00d200000(o0OO2, x2);
        }
        ApiUtils.\u00f600000(g2, x3);
        return g2.doCmd(x2, x3);
    }

    private static T[] \u00f400000(G g2) {
        O o2 = g2.getClass().getAnnotation(O.class);
        if (o2 == null) {
            throw new RuntimeException("Missing Permissions for: " + g2.getClass().getName());
        }
        return o2.super();
    }

    public static void checkPermission(T t2, X x2) {
        ApiUtils.checkPermission(t2, x2, x2.getString("_siteid"));
    }

    public static void checkPermission(T t2, X x2, String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw H.\u00f800000;
        }
        X x3 = x2.getX("_context", X.superObject).getX("permissions", X.superObject);
        List<String> list = x3.getStringList(string);
        if (!list.contains(t2.name())) {
            throw H.\u00f800000;
        }
    }

    public static void validatePermissions(List<String> list) {
        ApiUtils.validatePermissions(list, false);
    }

    public static void validatePermissions(List<String> list, boolean bl) {
        for (String string : list) {
            try {
                T t2 = T.valueOf(string);
                if (!(bl ? !t2.\u00f500000() : !t2.o00000())) continue;
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new H("api.err.InvalidPermission", "name", string);
            }
        }
    }

    private static void \u00f600000(G g2, X x2) {
        if (g2.getClass().isAnnotationPresent(C.class)) {
            ApiServlet.\u00d8O0000(x2);
        }
    }

    private static int \u00d800000(String string) {
        if ("get".equals(string) || "list".equals(string)) {
            return X.oo0000;
        }
        if ("upd".equals(string) || "set".equals(string)) {
            return X.supersuper;
        }
        if ("group".equals(string)) {
            return X.\u00d5\u00d20000;
        }
        if ("add".equals(string)) {
            return X.o\u00d20000;
        }
        if ("del".equals(string)) {
            return X.floatnew;
        }
        if ("cnt".equals(string)) {
            return X.oo0000 | X.\u00d2\u00d40000;
        }
        return 0;
    }

    private static boolean \u00d400000(String string, int n2, Class<? extends X> clazz) {
        if (!Sanitizable.class.isAssignableFrom(clazz)) {
            return false;
        }
        if ("add".equals(string)) {
            return (X.o\u00d20000 & n2) == X.o\u00d20000;
        }
        if ("upd".equals(string) || "set".equals(string)) {
            return (X.supersuper & n2) == X.supersuper;
        }
        if ("group".equals(string)) {
            return (X.o\u00d20000 & n2) == X.o\u00d20000 || (X.supersuper & n2) == X.supersuper;
        }
        return false;
    }

    public static void validateAndSanitizePayload(Class<? extends X> clazz, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nonnull X x2) {
        try {
            int n2 = (Integer)clazz.getMethod("mask", new Class[0]).invoke(null, new Object[0]);
            if ((ApiUtils.\u00d800000(string) & n2) == 0) {
                throw H.\u00d400000;
            }
            if (ApiUtils.\u00d400000(string, n2, clazz)) {
                X x3 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                super.debug("[sanitize] /{}/{}/{} {}", new Object[]{string, string3, string4 == null ? "" : string4, x2});
                if (string4 != null && clazz == Setting.class) {
                    X x4 = new X();
                    B b2 = B.\u00f4\u00f4\u00f6000(Setting.class.getSimpleName());
                    if (b2.get(string4) == null) {
                        throw H.\u00f400000;
                    }
                    x4.put(string4, (Object)x2);
                    ((Sanitizable)((Object)x3)).sanitize(x4);
                } else if ("group".equals(string) && clazz == Setting.class) {
                    ApiUtils.\u00d600000(x2, x3);
                } else if ("group".equals(string)) {
                    if ("PUT".equals(string2) && (X.supersuper & n2) == 0 || "POST".equals(string2) && (X.o\u00d20000 & n2) == 0) {
                        throw H.\u00d400000;
                    }
                    if (x2.containsField("id") && x2.containsField("data")) {
                        ((Sanitizable)((Object)x3)).sanitize(x2.getX("data", X.superObject));
                    } else if (x2.containsField("objects")) {
                        List<X> list = x2.getList("objects", X.dosuper);
                        for (X x5 : list) {
                            ((Sanitizable)((Object)x3)).sanitize(x5.getX("data", X.superObject));
                        }
                    }
                } else {
                    ((Sanitizable)((Object)x3)).sanitize(x2);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            super.error(AnalyticsAppender.SEND_TO_ANALYTICS, "[Internal] {}.mask() undefined", (Object)clazz.getSimpleName(), (Object)noSuchMethodException);
            throw new H("api.err.InvalidObject", new Object[0]);
        }
        catch (H h2) {
            throw h2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Sanitizable.InvalidPayload) {
                throw H.\u00f400000;
            }
            super.error(AnalyticsAppender.SEND_TO_ANALYTICS, "[Internal] failed to call {}.sanitize()", (Object)clazz.getSimpleName(), (Object)invocationTargetException);
            throw H.\u00f400000;
        }
        catch (Sanitizable.InvalidPayload invalidPayload) {
            super.warn(String.format("%s.sanitize() not passed", clazz.getSimpleName()));
            throw new H("api.err.InvalidPayload", invalidPayload.getPayload());
        }
        catch (Exception exception) {
            super.error(AnalyticsAppender.SEND_TO_ANALYTICS, "[Internal] failed to call {}.sanitize()", (Object)clazz.getSimpleName(), (Object)exception);
            throw H.\u00f400000;
        }
    }

    private static void \u00d600000(X x2, X x3) {
        if (x2.containsField("id") && x2.containsField("data")) {
            throw H.\u00f400000;
        }
        if (x2.containsField("objects")) {
            List<X> list = x2.getList("objects");
            for (X x4 : list) {
                X x5 = x4.getX("data", X.superObject);
                String string = x5.getString("key");
                B b2 = B.\u00f4\u00f4\u00f6000(Setting.class.getSimpleName());
                if (string == null || b2.get(string) == null) {
                    throw H.\u00f400000;
                }
                X x6 = new X().append(string, x5);
                ((Sanitizable)((Object)x3)).sanitize(x6);
            }
        }
    }

    private static DeviceType[] super(O0OO o0OO2) {
        if (o0OO2 != null) {
            return o0OO2.o00000();
        }
        return new DeviceType[0];
    }

    private static Model[] int(O0OO o0OO2) {
        if (o0OO2 != null) {
            return o0OO2.\u00d300000();
        }
        return new Model[0];
    }

    private static DeviceFeature[] \u00d300000(O0OO o0OO2) {
        if (o0OO2 != null) {
            return o0OO2.\u00d200000();
        }
        return new DeviceFeature[0];
    }

    @VisibleForTesting
    static void \u00d200000(O0OO o0OO2, X x2) {
        String string = x2.getString("mac");
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new H("api.err.UnknownDevice", "mac", string);
        }
        Device device = ooOO.\u00f6\u00d30000().\u00d8\u00f40O00(string);
        if (device == null) {
            throw new H("api.err.UnknownDevice", "mac", string);
        }
        for (DeviceType enum_ : ApiUtils.super(o0OO2)) {
            if (!device.getDeviceType().equals((Object)enum_)) continue;
            return;
        }
        for (Enum enum_ : ApiUtils.int(o0OO2)) {
            if (device.getModel() != enum_) continue;
            return;
        }
        for (Enum enum_ : ApiUtils.\u00d300000(o0OO2)) {
            if (!device.hasFeature((DeviceFeature)enum_)) continue;
            return;
        }
        throw H.OO0000;
    }

    public static String getValidatedNetworkApplicationClient(String string) {
        return com.ubnt.ace.P.\u00d500000(OOOo.class, string).map(OOOo::toString).orElse(null);
    }
}

