/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClientCount {
    private int total;
    private int active;
    @JsonProperty(value="total_wireless")
    private int totalWireless;
    @JsonProperty(value="active_wireless")
    private int activeWireless;
    private ClientGroup groups;

    public ClientCount(int n2, int n3, int n4, int n5, List<ClientCountBreakdown> list, List<ClientCountBreakdown> list2, List<ClientCountBreakdown> list3, List<ClientCountBreakdown> list4) {
        this.total = n2;
        this.active = n3;
        this.totalWireless = n4;
        this.activeWireless = n5;
        this.groups = new ClientGroup(list, list2, list3, list4);
    }

    public int getTotal() {
        return this.total;
    }

    public int getActive() {
        return this.active;
    }

    public int getTotalWireless() {
        return this.totalWireless;
    }

    public int getActiveWireless() {
        return this.activeWireless;
    }

    public ClientGroup getGroups() {
        return this.groups;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientCount clientCount = (ClientCount)object;
        return this.total == clientCount.total && this.active == clientCount.active && this.totalWireless == clientCount.totalWireless && this.activeWireless == clientCount.activeWireless && Objects.equals(this.groups, clientCount.groups);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.active, this.totalWireless, this.activeWireless, this.groups);
    }

    public static ClientCount empty() {
        return new ClientCount(0, 0, 0, 0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static class ClientGroup {
        private List<ClientCountBreakdown> all;
        private List<ClientCountBreakdown> guest;
        private List<ClientCountBreakdown> wired;
        private List<ClientCountBreakdown> wireless;

        public ClientGroup(List<ClientCountBreakdown> list, List<ClientCountBreakdown> list2, List<ClientCountBreakdown> list3, List<ClientCountBreakdown> list4) {
            this.all = list;
            this.guest = list2;
            this.wired = list3;
            this.wireless = list4;
        }

        public List<ClientCountBreakdown> getAll() {
            return this.all;
        }

        public List<ClientCountBreakdown> getGuest() {
            return this.guest;
        }

        public List<ClientCountBreakdown> getWired() {
            return this.wired;
        }

        public List<ClientCountBreakdown> getWireless() {
            return this.wireless;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ClientGroup clientGroup = (ClientGroup)object;
            return Objects.equals(this.all, clientGroup.all) && Objects.equals(this.guest, clientGroup.guest) && Objects.equals(this.wired, clientGroup.wired) && Objects.equals(this.wireless, clientGroup.wireless);
        }

        public int hashCode() {
            return Objects.hash(this.all, this.guest, this.wired, this.wireless);
        }
    }

    public static class ClientCountBreakdown {
        private int total;
        private long satisfactionSamples;
        private BigInteger satisfactionTotal = BigInteger.ZERO;
        @JsonProperty(value="os_class")
        private int osClass;
        private BigInteger bytesTotal = BigInteger.ZERO;
        private BigInteger durationTotal = BigInteger.ZERO;
        @JsonProperty(value="rx_bytes")
        private BigInteger bytesReceivedTotal = BigInteger.ZERO;
        @JsonProperty(value="tx_bytes")
        private BigInteger bytesTransmittedTotal = BigInteger.ZERO;

        public ClientCountBreakdown(int n2) {
            this.osClass = n2;
        }

        public void addClient(long l2, long l3, long l4, long l5, long l6, long l7) {
            ++this.total;
            if (l2 != -1L) {
                this.satisfactionTotal = this.satisfactionTotal.add(BigInteger.valueOf(l2).multiply(BigInteger.valueOf(l3)));
                this.satisfactionSamples += l3;
            }
            this.bytesTotal = this.bytesTotal.add(BigInteger.valueOf(l4));
            this.durationTotal = this.durationTotal.add(BigInteger.valueOf(l5));
            this.bytesReceivedTotal = this.bytesReceivedTotal.add(BigInteger.valueOf(l6));
            this.bytesTransmittedTotal = this.bytesTransmittedTotal.add(BigInteger.valueOf(l7));
        }

        public int getOsClass() {
            return this.osClass;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSatisfaction() {
            return this.satisfactionSamples == 0L ? 0 : this.satisfactionTotal.divide(BigInteger.valueOf(this.satisfactionSamples)).intValue();
        }

        public long getActivity() {
            return this.durationTotal.compareTo(BigInteger.ZERO) > 0 ? this.bytesTotal.divide(this.durationTotal).longValue() : 0L;
        }

        public BigInteger getBytesReceivedTotal() {
            return this.bytesReceivedTotal;
        }

        public BigInteger getBytesTransmittedTotal() {
            return this.bytesTransmittedTotal;
        }

        public BigInteger getBytesTotal() {
            return this.bytesTotal;
        }

        public BigInteger getSatisfactionTotal() {
            return this.satisfactionTotal;
        }

        public long getSatisfactionSamples() {
            return this.satisfactionSamples;
        }
    }
}

