/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.client.dto.action;

import com.ubnt.net.integration.api.client.dto.action.IntegrationClientActionRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(name="Guest access authorization request", description="Authorizes network access to a guest client. Client must be a guest.\nThis action cancels existing active authorization (if exists), creates a new one with new limits\nand resets guest traffic counters.")
public final class IntegrationClientAuthorizeGuestAccessRequest
implements IntegrationClientActionRequest {
    @Schema(description="(Optional) how long (in minutes) the guest will be authorized to access the network.\nIf not specified, the default limit is used from the site settings")
    @Nullable
    @Min(value=1L)
    @Max(value=1000000L)
    private final @Min(value=1L) @Max(value=1000000L) Long timeLimitMinutes;
    @Schema(description="(Optional) data usage limit in megabytes")
    @Nullable
    @Min(value=1L)
    @Max(value=0x100000L)
    private final @Min(value=1L) @Max(value=0x100000L) Long dataUsageLimitMBytes;
    @Schema(description="(Optional) download rate limit in kilobits per second")
    @Nullable
    @Min(value=2L)
    @Max(value=100000L)
    private final @Min(value=2L) @Max(value=100000L) Long rxRateLimitKbps;
    @Schema(description="(Optional) upload rate limit in kilobits per second")
    @Nullable
    @Min(value=2L)
    @Max(value=100000L)
    private final @Min(value=2L) @Max(value=100000L) Long txRateLimitKbps;

    @ConstructorProperties(value={"timeLimitMinutes", "dataUsageLimitMBytes", "rxRateLimitKbps", "txRateLimitKbps"})
    @Generated
    IntegrationClientAuthorizeGuestAccessRequest(@Nullable Long l2, @Nullable Long l3, @Nullable Long l4, @Nullable Long l5) {
        this.timeLimitMinutes = l2;
        this.dataUsageLimitMBytes = l3;
        this.rxRateLimitKbps = l4;
        this.txRateLimitKbps = l5;
    }

    @Generated
    public static _o builder() {
        return new _o();
    }

    @Nullable
    @Generated
    public Long getTimeLimitMinutes() {
        return this.timeLimitMinutes;
    }

    @Nullable
    @Generated
    public Long getDataUsageLimitMBytes() {
        return this.dataUsageLimitMBytes;
    }

    @Nullable
    @Generated
    public Long getRxRateLimitKbps() {
        return this.rxRateLimitKbps;
    }

    @Nullable
    @Generated
    public Long getTxRateLimitKbps() {
        return this.txRateLimitKbps;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationClientAuthorizeGuestAccessRequest)) {
            return false;
        }
        IntegrationClientAuthorizeGuestAccessRequest integrationClientAuthorizeGuestAccessRequest = (IntegrationClientAuthorizeGuestAccessRequest)object;
        Long l2 = this.getTimeLimitMinutes();
        Long l3 = integrationClientAuthorizeGuestAccessRequest.getTimeLimitMinutes();
        if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
            return false;
        }
        Long l4 = this.getDataUsageLimitMBytes();
        Long l5 = integrationClientAuthorizeGuestAccessRequest.getDataUsageLimitMBytes();
        if (l4 == null ? l5 != null : !((Object)l4).equals(l5)) {
            return false;
        }
        Long l6 = this.getRxRateLimitKbps();
        Long l7 = integrationClientAuthorizeGuestAccessRequest.getRxRateLimitKbps();
        if (l6 == null ? l7 != null : !((Object)l6).equals(l7)) {
            return false;
        }
        Long l8 = this.getTxRateLimitKbps();
        Long l9 = integrationClientAuthorizeGuestAccessRequest.getTxRateLimitKbps();
        return !(l8 == null ? l9 != null : !((Object)l8).equals(l9));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Long l2 = this.getTimeLimitMinutes();
        n2 = n2 * 59 + (l2 == null ? 43 : ((Object)l2).hashCode());
        Long l3 = this.getDataUsageLimitMBytes();
        n2 = n2 * 59 + (l3 == null ? 43 : ((Object)l3).hashCode());
        Long l4 = this.getRxRateLimitKbps();
        n2 = n2 * 59 + (l4 == null ? 43 : ((Object)l4).hashCode());
        Long l5 = this.getTxRateLimitKbps();
        n2 = n2 * 59 + (l5 == null ? 43 : ((Object)l5).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationClientAuthorizeGuestAccessRequest(timeLimitMinutes=" + this.getTimeLimitMinutes() + ", dataUsageLimitMBytes=" + this.getDataUsageLimitMBytes() + ", rxRateLimitKbps=" + this.getRxRateLimitKbps() + ", txRateLimitKbps=" + this.getTxRateLimitKbps() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Generated
    public static class _o {
        @Generated
        private Long o00000;
        @Generated
        private Long \u00d300000;
        @Generated
        private Long \u00d400000;
        @Generated
        private Long new;

        @Generated
        _o() {
        }

        @Generated
        public _o \u00d200000(@Nullable Long l2) {
            this.o00000 = l2;
            return this;
        }

        @Generated
        public _o \u00d300000(@Nullable Long l2) {
            this.\u00d300000 = l2;
            return this;
        }

        @Generated
        public _o class(@Nullable Long l2) {
            this.\u00d400000 = l2;
            return this;
        }

        @Generated
        public _o super(@Nullable Long l2) {
            this.new = l2;
            return this;
        }

        @Generated
        public IntegrationClientAuthorizeGuestAccessRequest \u00d400000() {
            return new IntegrationClientAuthorizeGuestAccessRequest(this.o00000, this.\u00d300000, this.\u00d400000, this.new);
        }

        @Generated
        public String toString() {
            return "IntegrationClientAuthorizeGuestAccessRequest.IntegrationClientAuthorizeGuestAccessRequestBuilder(timeLimitMinutes=" + this.o00000 + ", dataUsageLimitMBytes=" + this.\u00d300000 + ", rxRateLimitKbps=" + this.\u00d400000 + ", txRateLimitKbps=" + this.new + ")";
        }
    }
}

