/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.exception;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.ubnt.ace.U;
import com.ubnt.net.integration.exception.H;
import com.ubnt.net.integration.exception.IntegrationErrorMessage;
import com.ubnt.net.integration.exception.K;
import com.ubnt.net.integration.exception.Object;
import com.ubnt.service.system.kA;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestControllerAdvice
@Hidden
public class for
extends ResponseEntityExceptionHandler {
    private static final Logger o00000 = kA.\u00d400000;
    private final Clock \u00d200000;

    public static String \u00d200000(String string, java.lang.Object object) {
        return String.format("'%s' is not a valid '%s' value", object, string);
    }

    protected ResponseEntity<java.lang.Object> handleExceptionInternal(Exception exception, java.lang.Object object, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        if (webRequest instanceof ServletWebRequest) {
            ServletWebRequest servletWebRequest = (ServletWebRequest)webRequest;
            return this.\u00f400000(httpStatusCode, servletWebRequest, httpHeaders, exception.getMessage());
        }
        return super.handleExceptionInternal(exception, object, httpHeaders, httpStatusCode, webRequest);
    }

    protected ResponseEntity<java.lang.Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        if (webRequest instanceof ServletWebRequest) {
            String string;
            ServletWebRequest servletWebRequest = (ServletWebRequest)webRequest;
            java.lang.Object object = httpMessageNotReadableException.getCause();
            if (object instanceof InvalidTypeIdException) {
                InvalidTypeIdException invalidTypeIdException = (InvalidTypeIdException)object;
                object = Optional.of(invalidTypeIdException.getBaseType().getRawClass()).map(U.\u00d500000(Class::getAnnotation, Object.class)).map(Object::o00000).orElse("Unknown type ID '%s'");
                string = String.format((String)object, invalidTypeIdException.getTypeId());
            } else {
                object = httpMessageNotReadableException.getCause();
                if (object instanceof JsonParseException) {
                    JsonParseException jsonParseException = (JsonParseException)((java.lang.Object)object);
                    string = jsonParseException.getOriginalMessage();
                } else {
                    object = httpMessageNotReadableException.getCause();
                    if (object instanceof UnrecognizedPropertyException) {
                        UnrecognizedPropertyException unrecognizedPropertyException = (UnrecognizedPropertyException)object;
                        string = String.format("Unknown request body property %s", this.int(unrecognizedPropertyException.getPath()));
                    } else {
                        object = httpMessageNotReadableException.getCause();
                        if (object instanceof MismatchedInputException) {
                            MismatchedInputException mismatchedInputException = (MismatchedInputException)object;
                            string = String.format("Type mismatch for request body property %s", this.int(mismatchedInputException.getPath()));
                        } else {
                            string = "Failed to read request body";
                        }
                    }
                }
            }
            return this.\u00f400000(httpStatusCode, servletWebRequest, httpHeaders, string);
        }
        return super.handleHttpMessageNotReadable(httpMessageNotReadableException, httpHeaders, httpStatusCode, webRequest);
    }

    protected ResponseEntity<java.lang.Object> handleTypeMismatch(TypeMismatchException typeMismatchException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        if (webRequest instanceof ServletWebRequest) {
            ServletWebRequest servletWebRequest = (ServletWebRequest)webRequest;
            if (typeMismatchException instanceof MethodArgumentTypeMismatchException) {
                MethodArgumentTypeMismatchException methodArgumentTypeMismatchException = (MethodArgumentTypeMismatchException)typeMismatchException;
                return this.\u00f400000((HttpStatusCode)HttpStatus.BAD_REQUEST, servletWebRequest, httpHeaders, for.\u00d200000(methodArgumentTypeMismatchException.getName(), typeMismatchException.getValue()));
            }
        }
        return super.handleTypeMismatch(typeMismatchException, httpHeaders, httpStatusCode, webRequest);
    }

    protected ResponseEntity<java.lang.Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, HttpHeaders httpHeaders, HttpStatusCode httpStatusCode, WebRequest webRequest) {
        if (webRequest instanceof ServletWebRequest) {
            ServletWebRequest servletWebRequest = (ServletWebRequest)webRequest;
            return this.\u00f400000((HttpStatusCode)HttpStatus.BAD_REQUEST, servletWebRequest, httpHeaders, "Invalid request body: " + methodArgumentNotValidException.getFieldErrors().stream().map(fieldError -> fieldError.getField() + " " + fieldError.getDefaultMessage()).collect(Collectors.joining(", ")));
        }
        return super.handleMethodArgumentNotValid(methodArgumentNotValidException, httpHeaders, httpStatusCode, webRequest);
    }

    @ExceptionHandler(value={H.class})
    public ResponseEntity<IntegrationErrorMessage> \u00d600000(H h2, HttpServletRequest httpServletRequest) {
        UUID uUID = (UUID)httpServletRequest.getAttribute("request-id");
        h2.\u00d200000().map(arg_0 -> ((Logger)this.\u00d800000()).atLevel(arg_0)).ifPresent(loggingEventBuilder -> loggingEventBuilder.log("Error while processing integration API request {} to {}", new java.lang.Object[]{uUID, httpServletRequest.getRequestURI(), h2}));
        String string = Optional.ofNullable(h2.getMessage()).orElse(h2.super().getReasonPhrase());
        IntegrationErrorMessage integrationErrorMessage = IntegrationErrorMessage.of(h2.super(), string, this.\u00d200000.instant(), httpServletRequest.getRequestURI(), uUID);
        return new ResponseEntity((java.lang.Object)integrationErrorMessage, (HttpStatusCode)h2.super());
    }

    @ExceptionHandler
    public ResponseEntity<IntegrationErrorMessage> super(Exception exception, HttpServletRequest httpServletRequest) {
        return this.\u00d600000(new K(exception), httpServletRequest);
    }

    @VisibleForTesting
    Logger \u00d800000() {
        return o00000;
    }

    private String int(List<JsonMappingException.Reference> list) {
        return "$" + list.stream().map(reference -> Optional.ofNullable(reference.getFieldName()).map(string -> "." + string).orElse("[" + reference.getIndex() + "]")).collect(Collectors.joining());
    }

    private ResponseEntity<java.lang.Object> \u00f400000(HttpStatusCode httpStatusCode, ServletWebRequest servletWebRequest, HttpHeaders httpHeaders, String string) {
        HttpServletRequest httpServletRequest = servletWebRequest.getRequest();
        UUID uUID = (UUID)httpServletRequest.getAttribute("request-id");
        HttpStatus httpStatus = HttpStatus.valueOf((int)httpStatusCode.value());
        IntegrationErrorMessage integrationErrorMessage = IntegrationErrorMessage.of(httpStatus, string, this.\u00d200000.instant(), httpServletRequest.getRequestURI(), uUID);
        return new ResponseEntity((java.lang.Object)integrationErrorMessage, (MultiValueMap)httpHeaders, httpStatusCode);
    }

    @ConstructorProperties(value={"clock"})
    @Generated
    public for(Clock clock) {
        this.\u00d200000 = clock;
    }
}

