/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.stacking;

import com.ubnt.data.Site;
import com.ubnt.model.api.stacking.StackingGroupDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.stacking.C;
import com.ubnt.service.stacking.StackingGroupDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Stacking")
public class StackingGroupController {
    private final C o00000;

    public StackingGroupController(C c2) {
        this.o00000 = c2;
    }

    @GetMapping(value={"/api/site/{siteName}/stacking"})
    @Operation(summary="List stacking groups")
    public List<StackingGroupDto> listStackingGroups(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d200000(site.getId()).stream().map(StackingGroupDto::fromDocument).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/stacking/{stackingGroupId}"})
    @Operation(summary="Get stacking group")
    public StackingGroupDto getStackingGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="stackingGroupId") String string) {
        return StackingGroupDto.fromDocument(this.o00000.String(string));
    }

    @PostMapping(value={"/api/site/{siteName}/stacking"}, consumes={"application/json"})
    @Operation(summary="Create a new stack group")
    @ResponseStatus(value=HttpStatus.CREATED)
    public StackingGroupDto createStackingGroup(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull StackingGroupDto stackingGroupDto) {
        return StackingGroupDto.fromDocument(this.o00000.o00000(stackingGroupDto.toDocument(site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/stacking/{stackingGroupId}"}, consumes={"application/json"})
    @Operation(summary="Update stacking group")
    public StackingGroupDto updateStackingGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="stackingGroupId") String string, @RequestBody @Valid @NotNull StackingGroupDto stackingGroupDto) {
        StackingGroupDocument stackingGroupDocument = this.o00000.\u00d800000(stackingGroupDto.toDocument(site.getId()));
        return StackingGroupDto.fromDocument(stackingGroupDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/stacking/{stackingGroupId}"})
    @Operation(summary="Delete stacking group")
    public void deleteStackingGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="stackingGroupId") String string) {
        this.o00000.\u00d600000(string);
    }
}

