/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficroute;

import com.ubnt.data.Site;
import com.ubnt.model.api.trafficroute.TrafficRouteDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.trafficroute.G;
import com.ubnt.service.trafficroute.TrafficRouteDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Traffic Routes")
public class TrafficRouteController {
    private final G super;

    public TrafficRouteController(G g2) {
        this.super = g2;
    }

    @GetMapping(value={"/api/site/{siteName}/trafficroutes"})
    @Operation(summary="List Traffic Routes")
    public List<TrafficRouteDto> listTrafficRoutes(@PathVariable(value="siteName") Site site) {
        return this.super.super(site.getId()).stream().map(TrafficRouteDto::fromDocument).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/site/{siteName}/trafficroutes"}, consumes={"application/json"})
    @Operation(summary="Create a new Traffic Routes")
    @ResponseStatus(value=HttpStatus.CREATED)
    public TrafficRouteDto createTrafficRoute(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull TrafficRouteDto trafficRouteDto) {
        TrafficRouteDocument trafficRouteDocument = this.super.\u00d400000(trafficRouteDto.toDocument(site.getId()));
        return TrafficRouteDto.fromDocument(trafficRouteDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/trafficroutes/{routeId}"}, consumes={"application/json"})
    @Operation(summary="Update Traffic Route")
    public TrafficRouteDto updateTrafficRoute(@PathVariable(value="siteName") Site site, @PathVariable(value="routeId") String string, @RequestBody @Valid @NotNull TrafficRouteDto trafficRouteDto) {
        TrafficRouteDto trafficRouteDto2 = TrafficRouteDto.withId(trafficRouteDto, string);
        TrafficRouteDocument trafficRouteDocument = this.super.class(trafficRouteDto2.toDocument(site.getId()));
        return TrafficRouteDto.fromDocument(trafficRouteDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/trafficroutes/{routeId}/enable"})
    @Operation(summary="Enable Traffic Route")
    public ResponseEntity<Void> enableTrafficRoute(@PathVariable(value="siteName") Site site, @PathVariable(value="routeId") String string) {
        return this.super(site, string, true);
    }

    @PutMapping(value={"/api/site/{siteName}/trafficroutes/{routeId}/disable"})
    @Operation(summary="Disable Traffic Route")
    public ResponseEntity<Void> disableTrafficRoute(@PathVariable(value="siteName") Site site, @PathVariable(value="routeId") String string) {
        return this.super(site, string, false);
    }

    private ResponseEntity<Void> super(@PathVariable(value="siteName") Site site, @PathVariable(value="routeId") String string, boolean bl) {
        return this.super.\u00d300000(site.getId(), string).map(trafficRouteDocument -> {
            if (bl == trafficRouteDocument.isEnabled()) {
                return trafficRouteDocument;
            }
            TrafficRouteDocument trafficRouteDocument2 = TrafficRouteDocument.from(trafficRouteDocument, bl, trafficRouteDocument.getTargetDevices());
            return this.super.class(trafficRouteDocument2);
        }).map(trafficRouteDocument -> ResponseEntity.ok().build()).orElse(ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/api/site/{siteName}/trafficroutes/{routeId}"})
    @Operation(summary="Delete Traffic Route")
    public void deleteTrafficRoute(@PathVariable(value="siteName") Site site, @PathVariable(value="routeId") String string) {
        this.super.\u00d600000(site.getId(), string);
    }
}

