/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.system.command.backup;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.ubnt.data.Account;
import com.ubnt.data.Device;
import com.ubnt.data.DeviceType;
import com.ubnt.data.DhcpOption;
import com.ubnt.data.DpiApp;
import com.ubnt.data.DpiGroup;
import com.ubnt.data.DynamicDNS;
import com.ubnt.data.Event;
import com.ubnt.data.FirewallGroup;
import com.ubnt.data.FirewallRule;
import com.ubnt.data.FloorPlanFile;
import com.ubnt.data.GuestAuthorization;
import com.ubnt.data.HeatMap;
import com.ubnt.data.HeatMapPoint;
import com.ubnt.data.Hotspot2Conf;
import com.ubnt.data.HotspotOp;
import com.ubnt.data.HotspotPackage;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.Payment;
import com.ubnt.data.PortConf;
import com.ubnt.data.PortForward;
import com.ubnt.data.PortalFile;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.Rogue;
import com.ubnt.data.RogueKnown;
import com.ubnt.data.Routing;
import com.ubnt.data.ScheduleTask;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.data.Tag;
import com.ubnt.data.User;
import com.ubnt.data.UserGroup;
import com.ubnt.data.VirtualDevice;
import com.ubnt.data.Voucher;
import com.ubnt.data.Wall;
import com.ubnt.data.WlanConf;
import com.ubnt.data.WlanGroup;
import com.ubnt.data.X;
import com.ubnt.repository.B;
import com.ubnt.repository.E;
import com.ubnt.repository.OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.repository.Objectsuper;
import com.ubnt.service.alert.setting.AlertSettingDocument;
import com.ubnt.service.apgroup.ApGroupDocument;
import com.ubnt.service.devmgr.supervoid;
import com.ubnt.service.doh.model.DohServersDocument;
import com.ubnt.service.firewall.policy.FirewallPolicyDocument;
import com.ubnt.service.firewall.qos.QosRuleDocument;
import com.ubnt.service.firewall.simpleappblock.SimpleAppBlockDocument;
import com.ubnt.service.firewallzone.FirewallZoneDocument;
import com.ubnt.service.magicsitetositevpn.U;
import com.ubnt.service.portconf.migrate.A;
import com.ubnt.service.site.D;
import com.ubnt.service.stacking.StackingGroupDocument;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.system.O0oo;
import com.ubnt.service.system.Oo0Oo;
import com.ubnt.service.system.backup.restore.C;
import com.ubnt.service.system.command.backup.SiteImportedEvent;
import com.ubnt.service.system.kA;
import com.ubnt.service.system.sitefeaturemigration.SiteFeatureMigrationDocument;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import com.ubnt.service.trafficroute.TrafficRouteDocument;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import com.ubnt.service.vpn.WireguardUserDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.util.TypeInformation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImportExportSiteService {
    private static final Logger \u00f600000 = kA.\u00f4\u00d20000;
    private static final List<Class> \u00d800000 = List.of(Account.class, AclRuleDocument.class, AlertSettingDocument.class, ApGroupDocument.class, Device.class, DhcpOption.class, DohServersDocument.class, DpiApp.class, DpiGroup.class, DynamicDNS.class, Event.class, FirewallGroup.class, FirewallRule.class, FirewallPolicyDocument.class, FirewallZoneDocument.class, FloorPlanFile.class, GuestAuthorization.class, HeatMap.class, HeatMapPoint.class, Hotspot2Conf.class, HotspotOp.class, HotspotPackage.class, com.ubnt.data.Map.class, NetworkConf.class, Payment.class, PortConf.class, PortForward.class, PortalFile.class, RadiusProfile.class, QosRuleDocument.class, Rogue.class, RogueKnown.class, Routing.class, ScheduleTask.class, SimpleAppBlockDocument.class, SiteFeatureMigrationDocument.class, Setting.class, StackingGroupDocument.class, Tag.class, TrafficRouteDocument.class, TrafficRuleDocument.class, User.class, UserGroup.class, Voucher.class, VirtualDevice.class, Wall.class, WireguardUserDocument.class, WlanConf.class, WlanGroup.class);
    private final C class;
    private final Oo0Oo \u00f800000;
    private final D \u00d400000;
    private final O0oo super;
    private final com.ubnt.service.apgroup.C \u00d200000;
    private final Objectsuper \u00d600000;
    private final supervoid \u00d300000;
    private final com.ubnt.service.system.event.E int;
    private final U \u00f400000;

    public ImportExportSiteService(C c2, Oo0Oo oo0Oo2, D d2, O0oo o0oo2, A a2, com.ubnt.service.apgroup.C c3, Objectsuper objectsuper, supervoid supervoid2, com.ubnt.service.system.event.E e2, U u2) {
        this.class = c2;
        this.\u00f800000 = oo0Oo2;
        this.\u00d400000 = d2;
        this.super = o0oo2;
        this.\u00d200000 = c3;
        this.\u00d600000 = objectsuper;
        this.\u00d300000 = supervoid2;
        this.int = e2;
        this.\u00f400000 = u2;
    }

    public Oo0Oo._Oo importSite(String string, String string2) {
        Map<Class, List<BSONObject>> map = this.\u00d400000(string);
        List<Site> list = this.class.\u00d200000(map);
        if (list.size() != 1) {
            \u00f600000.error(AnalyticsAppender.SEND_TO_ANALYTICS, "import site failed: should contain exactly one site object in backup");
            return null;
        }
        Site site = list.get(0);
        if (string2 == null && (string2 = site.getDescription()) == null) {
            string2 = "Imported Site";
        }
        Site site2 = this.\u00f800000.dosuper(new Site().setDescription(string2));
        String string3 = site2.getId();
        Map<Class, Map<String, String>> map2 = this.classsuper(map, site.getId(), site2.getId());
        this.\u00f600000(map, map2);
        for (Class clazz : \u00d800000) {
            List<BSONObject> list2 = map.get(clazz);
            if (list2 == null || list2.isEmpty()) continue;
            \u00f600000.info("import {} to site {}", (Object)clazz.getSimpleName(), (Object)string2);
            list2.forEach(bSONObject -> this.\u00d6O0000((BSONObject)bSONObject, clazz));
        }
        this.\u00d300000.\u00f6\u00f40O00(string3);
        this.\u00d300000.\u00f5\u00d3OO00(string3, true);
        this.\u00d400000.OO0000();
        this.\u00d200000.\u00d200000(string3);
        this.\u00f400000.oO0000(string3);
        this.int.new(SiteImportedEvent.of(site2.duplicate(Site.class)));
        return new Oo0Oo._Oo(site2, map2);
    }

    public File exportSite(File file, Site site) {
        File file2;
        String string = site.getId();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
        try {
            BasicBSONEncoder basicBSONEncoder = new BasicBSONEncoder();
            ((OutputStream)gZIPOutputStream).write(basicBSONEncoder.encode(this.OO0000("site")));
            ((OutputStream)gZIPOutputStream).write(basicBSONEncoder.encode((BSONObject)site));
            for (Class clazz : \u00d800000) {
                if (OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.\u00d200000(clazz)) {
                    this.void(string, clazz, (BSONEncoder)basicBSONEncoder, gZIPOutputStream);
                    continue;
                }
                this.public(string, clazz, (BSONEncoder)basicBSONEncoder, gZIPOutputStream);
            }
            file2 = file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)gZIPOutputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                \u00f600000.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Failed to exportSite", (Throwable)exception);
                return null;
            }
        }
        ((OutputStream)gZIPOutputStream).close();
        return file2;
    }

    private Map<Class, List<BSONObject>> \u00d400000(String string) {
        return this.class.\u00f400000(string).entrySet().stream().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void \u00f600000(Map<Class, List<BSONObject>> map, Map<Class, Map<String, String>> map2) {
        Map<String, String> map3 = this.\u00d2o0000(map2);
        map.values().stream().flatMap(Collection::stream).forEach(bSONObject -> this.Oo0000((BSONObject)bSONObject, map3));
    }

    private Map<Class, Map<String, String>> classsuper(Map<Class, List<BSONObject>> map, String string, String string2) {
        Map<Class, Map> map2 = map.entrySet().stream().filter(entry -> entry.getKey() != Site.class).map(entry -> Pair.of((Object)((Class)entry.getKey()), ((List)entry.getValue()).stream().map(bSONObject -> bSONObject.get("_id").toString()).collect(Collectors.toUnmodifiableMap(Function.identity(), string -> new ObjectId().toString())))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        map2.put(Site.class, Map.of(string, string2));
        return Map.copyOf(map2);
    }

    private Map<String, String> \u00d2o0000(Map<Class, Map<String, String>> map2) {
        return map2.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, com.ubnt.ace.U.\u00f5O0000()));
    }

    private void Oo0000(BSONObject bSONObject, Map<String, String> map) {
        bSONObject.keySet().forEach(string -> this.o00000(bSONObject, (String)string, map));
    }

    private void o00000(BSONObject bSONObject, String string, Map<String, String> map) {
        Optional.ofNullable(bSONObject.get(string)).ifPresent(object -> {
            if (object instanceof BSONObject) {
                this.Oo0000((BSONObject)object, map);
            } else if (object instanceof ObjectId) {
                this.\u00f4o0000(map, object).ifPresent(string2 -> bSONObject.put(string, (Object)new ObjectId(string2)));
            } else if (object instanceof String) {
                this.\u00f4o0000(map, object).ifPresent(string2 -> bSONObject.put(string, string2));
            }
        });
    }

    private Optional<String> \u00f4o0000(Map<String, String> map, Object object) {
        return Optional.ofNullable(map.get(object.toString()));
    }

    private void \u00d6O0000(BSONObject bSONObject, Class clazz) {
        if (Device.class == clazz) {
            this.\u00d5O0000(bSONObject, clazz);
        } else if (NetworkConf.class == clazz) {
            this.oO0000(bSONObject);
        } else {
            this.\u00d4o0000(clazz, bSONObject);
        }
    }

    private void \u00d5O0000(BSONObject bSONObject, Class clazz) {
        if (!DeviceType.\u00d300000.toString().equals(bSONObject.get("type"))) {
            this.\u00d4o0000(clazz, bSONObject);
        }
    }

    private void oO0000(BSONObject bSONObject) {
        NetworkConf networkConf = new NetworkConf();
        this.\u00d5o0000(networkConf, bSONObject);
        this.\u00f4O0000(networkConf);
        this.super.thisreturn(networkConf);
    }

    private void \u00f4O0000(NetworkConf networkConf) {
        for (String string : networkConf.keySet()) {
            if (!string.startsWith("dhcpd_user_option_")) continue;
            networkConf.removeField(string);
        }
    }

    @VisibleForTesting
    void public(String string, Class clazz, BSONEncoder bSONEncoder, OutputStream outputStream) throws IOException {
        List list = this.super.ifsuper(clazz, com.ubnt.data.C.E.Object(string));
        if (!list.isEmpty()) {
            outputStream.write(bSONEncoder.encode(this.OO0000(X.clazz2dbname(clazz))));
            for (X x2 : list) {
                outputStream.write(bSONEncoder.encode((BSONObject)x2));
            }
        }
    }

    @VisibleForTesting
    void void(String string, Class clazz, BSONEncoder bSONEncoder, OutputStream outputStream) throws IOException {
        B b2;
        List list;
        E e2;
        Optional<E> optional = this.\u00d600000.\u00d400000(clazz);
        MongoConverter mongoConverter = this.\u00d600000.new();
        if (optional.isPresent() && (e2 = optional.get()).o00000() && !(list = (b2 = (B)e2.\u00d200000()).findAllBySiteId(string)).isEmpty()) {
            outputStream.write(bSONEncoder.encode(this.OO0000(e2.String())));
            for (Object t2 : list) {
                this.\u00f500000(bSONEncoder, outputStream, mongoConverter, t2);
            }
        }
    }

    BSONObject OO0000(String string) {
        BasicBSONObject basicBSONObject = new BasicBSONObject();
        basicBSONObject.put("__cmd", (Object)"select");
        basicBSONObject.put("collection", (Object)string);
        return basicBSONObject;
    }

    <T extends X> void \u00d5o0000(T t2, Object object) {
        if (object == null || !(object instanceof BSONObject)) {
            return;
        }
        BSONObject bSONObject = (BSONObject)object;
        for (String string : bSONObject.keySet()) {
            Object object2 = bSONObject.get(string);
            if (object2 == null) continue;
            t2.put(string, object2);
        }
    }

    private void \u00d4o0000(Class clazz, BSONObject bSONObject) {
        if (OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.\u00d200000(clazz)) {
            this.\u00d600000(clazz, bSONObject);
        } else {
            this.float(clazz, bSONObject);
        }
    }

    private void \u00f500000(BSONEncoder bSONEncoder, OutputStream outputStream, MongoConverter mongoConverter, Object object) throws IOException {
        Object object2 = mongoConverter.convertToMongoType(object, TypeInformation.OBJECT);
        if (object2 instanceof Document) {
            Document document = (Document)object2;
            BasicDBObject basicDBObject = new BasicDBObject((Map)document);
            outputStream.write(bSONEncoder.encode((BSONObject)basicDBObject));
        } else if (object2 != null) {
            \u00f600000.error("Unexpected converted document type - {}", object2.getClass());
        } else {
            \u00f600000.error("Could not convert document with type - {}", object.getClass());
        }
    }

    private void float(Class clazz, BSONObject bSONObject) {
        X x2;
        try {
            x2 = (X)clazz.newInstance();
        }
        catch (Exception exception) {
            \u00f600000.error(AnalyticsAppender.SEND_TO_ANALYTICS, "import site object failed", (Throwable)exception);
            return;
        }
        this.\u00d5o0000(x2, bSONObject);
        this.super.thisreturn(x2);
    }

    private void \u00d600000(Class clazz, BSONObject bSONObject) {
        BasicDBObject basicDBObject = new BasicDBObject(bSONObject.toMap());
        com.ubnt.repository.C c2 = (com.ubnt.repository.C)this.\u00d600000.new().read(clazz, (Object)basicDBObject);
        this.\u00d600000.\u00d400000(clazz).ifPresent(e2 -> e2.\u00d200000().insert(c2));
    }
}

