/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotDeviceErrorCode;
import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.core.AwsIotRuntimeException;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceCommand;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AwsIotDeviceCommandManager {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceCommandManager.class.getName());
    private static final String TOPIC_PREFIX = "$aws/things/?/shadow";
    private static final String COMMAND_ID_FIELD = "clientToken";
    private static final String ERROR_CODE_FIELD = "code";
    private static final String ERROR_MESSAGE_FIELD = "message";
    private static final Map<Command, String> COMMAND_PATHS = new HashMap<Command, String>();
    private static final Map<CommandAck, String> COMMAND_ACK_PATHS;
    private static final Pattern commandPattern;
    private static final Pattern deltaPattern;
    private final ConcurrentMap<String, AwsIotDeviceCommand> pendingCommands = new ConcurrentHashMap<String, AwsIotDeviceCommand>();
    private final AbstractAwsIotDevice device;
    private final ObjectMapper objectMapper;

    public AwsIotDeviceCommandManager(AbstractAwsIotDevice device) {
        this.device = device;
        this.objectMapper = new ObjectMapper();
    }

    public String getTopic(Command command, CommandAck ack) {
        String topic = TOPIC_PREFIX.replace("?", this.device.getThingName());
        if (COMMAND_PATHS.containsKey((Object)command)) {
            topic = topic + COMMAND_PATHS.get((Object)command);
        }
        if (COMMAND_ACK_PATHS.containsKey((Object)ack)) {
            topic = topic + COMMAND_ACK_PATHS.get((Object)ack);
        }
        return topic;
    }

    public String runCommandSync(Command command, AWSIotMessage request) throws AWSIotException {
        try {
            return this.runCommand(command, request, 0L, false);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public String runCommandSync(Command command, AWSIotMessage request, long commandTimeout) throws AWSIotException, AWSIotTimeoutException {
        return this.runCommand(command, request, commandTimeout, false);
    }

    public String runCommand(Command command, AWSIotMessage request, long commandTimeout) throws AWSIotException {
        try {
            return this.runCommand(command, request, commandTimeout, true);
        }
        catch (AWSIotTimeoutException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    public String runCommand(Command command, AWSIotMessage request, long commandTimeout, boolean isAsync) throws AWSIotException, AWSIotTimeoutException {
        String commandId = this.newCommandId();
        this.appendCommandId(request, commandId);
        request.setTopic(this.getTopic(command, null));
        AwsIotDeviceCommand deviceCommand = new AwsIotDeviceCommand(this, command, commandId, request, commandTimeout, isAsync);
        this.pendingCommands.put(commandId, deviceCommand);
        LOGGER.fine("Number of pending commands: " + this.pendingCommands.size());
        try {
            deviceCommand.put(this.device);
        }
        catch (AWSIotException e) {
            this.pendingCommands.remove(commandId);
            throw e;
        }
        return deviceCommand.get(this.device);
    }

    public void onCommandAck(AWSIotMessage response) {
        if (response == null || response.getTopic() == null) {
            return;
        }
        AwsIotDeviceCommand command = this.getPendingCommand(response);
        if (command == null) {
            LOGGER.warning("Unknown command received from topic " + response.getTopic());
            return;
        }
        boolean success = response.getTopic().endsWith(COMMAND_ACK_PATHS.get((Object)CommandAck.ACCEPTED));
        if (!success && Command.DELETE.equals((Object)command.getCommand()) && AWSIotDeviceErrorCode.NOT_FOUND.equals((Object)command.getErrorCode())) {
            success = true;
        }
        if (success) {
            command.setResponse(response);
            command.onSuccess();
        } else {
            command.onFailure();
        }
    }

    public void onCommandTimeout(AwsIotDeviceCommand command) {
        this.pendingCommands.remove(command.getCommandId());
    }

    public void onSubscriptionAck(String topic, boolean success) {
        boolean ready = false;
        Command command = this.getCommandFromTopic(topic);
        if (command == null) {
            return;
        }
        String accepted = this.getTopic(command, CommandAck.ACCEPTED);
        String rejected = this.getTopic(command, CommandAck.REJECTED);
        if ((accepted.equals(topic) || rejected.equals(topic)) && success && this.device.isTopicReady(accepted) && this.device.isTopicReady(rejected)) {
            ready = true;
        }
        Iterator it = this.pendingCommands.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            AwsIotDeviceCommand deviceCommand = (AwsIotDeviceCommand)entry.getValue();
            boolean failCommand = false;
            if (command.equals((Object)deviceCommand.getCommand())) {
                if (ready) {
                    if (!deviceCommand.onReady(this.device)) {
                        failCommand = true;
                    }
                } else if (!success) {
                    failCommand = true;
                }
            }
            if (!failCommand) continue;
            it.remove();
            deviceCommand.onFailure();
        }
    }

    public void onDeactivate() {
        Iterator it = this.pendingCommands.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            final AwsIotDeviceCommand deviceCommand = (AwsIotDeviceCommand)entry.getValue();
            LOGGER.warning("Request was cancelled: " + deviceCommand.getCommand().name() + "/" + deviceCommand.getCommandId());
            this.device.getClient().scheduleTask(new Runnable(){

                @Override
                public void run() {
                    deviceCommand.onFailure();
                }
            });
        }
    }

    public boolean isDeltaTopic(String topic) {
        if (topic == null) {
            return false;
        }
        Matcher matcher = deltaPattern.matcher(topic);
        return matcher.matches();
    }

    private Command getCommandFromTopic(String topic) {
        if (topic == null) {
            return null;
        }
        Matcher matcher = commandPattern.matcher(topic);
        if (matcher.find()) {
            String name = matcher.group(1);
            return Command.valueOf(name.toUpperCase());
        }
        return null;
    }

    private void appendCommandId(AWSIotMessage message, String commandId) throws AWSIotException {
        String payload = message.getStringPayload();
        if (payload == null) {
            payload = "{}";
        }
        try {
            JsonNode jsonNode = this.objectMapper.readTree(payload);
            if (!jsonNode.isObject()) {
                throw new AWSIotException("Invalid Json string in payload");
            }
            ((ObjectNode)jsonNode).put(COMMAND_ID_FIELD, commandId);
            message.setStringPayload(jsonNode.toString());
        }
        catch (IOException e) {
            throw new AWSIotException(e);
        }
    }

    private AwsIotDeviceCommand getPendingCommand(AWSIotMessage message) {
        String payload = message.getStringPayload();
        if (payload == null) {
            return null;
        }
        try {
            JsonNode jsonNode = this.objectMapper.readTree(payload);
            if (!jsonNode.isObject()) {
                return null;
            }
            JsonNode node = jsonNode.get(COMMAND_ID_FIELD);
            if (node == null) {
                return null;
            }
            String commandId = node.textValue();
            AwsIotDeviceCommand command = (AwsIotDeviceCommand)this.pendingCommands.remove(commandId);
            if (command == null) {
                return null;
            }
            node = jsonNode.get(ERROR_CODE_FIELD);
            if (node != null) {
                command.setErrorCode(AWSIotDeviceErrorCode.valueOf(node.longValue()));
            }
            if ((node = jsonNode.get(ERROR_MESSAGE_FIELD)) != null) {
                command.setErrorMessage(node.textValue());
            }
            return command;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String newCommandId() {
        return UUID.randomUUID().toString();
    }

    public ConcurrentMap<String, AwsIotDeviceCommand> getPendingCommands() {
        return this.pendingCommands;
    }

    public AbstractAwsIotDevice getDevice() {
        return this.device;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    static {
        COMMAND_PATHS.put(Command.GET, "/get");
        COMMAND_PATHS.put(Command.UPDATE, "/update");
        COMMAND_PATHS.put(Command.DELETE, "/delete");
        COMMAND_PATHS.put(Command.DELTA, "/update/delta");
        COMMAND_ACK_PATHS = new HashMap<CommandAck, String>();
        COMMAND_ACK_PATHS.put(CommandAck.ACCEPTED, "/accepted");
        COMMAND_ACK_PATHS.put(CommandAck.REJECTED, "/rejected");
        commandPattern = Pattern.compile("^\\$aws/things/[^/]+/shadow/(get|update|delete)/(?:accepted|rejected)$");
        deltaPattern = Pattern.compile("^\\$aws/things/[^/]+/shadow/update/delta$");
    }

    public static enum CommandAck {
        ACCEPTED,
        REJECTED;

    }

    public static enum Command {
        GET,
        UPDATE,
        DELETE,
        DELTA;

    }
}

