// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// FindingVulnerabilityType The vulnerability type of the finding.
type FindingVulnerabilityType string

// List of FindingVulnerabilityType.
const (
	FINDINGVULNERABILITYTYPE_MISCONFIGURATION FindingVulnerabilityType = "misconfiguration"
	FINDINGVULNERABILITYTYPE_ATTACK_PATH      FindingVulnerabilityType = "attack_path"
	FINDINGVULNERABILITYTYPE_IDENTITY_RISK    FindingVulnerabilityType = "identity_risk"
	FINDINGVULNERABILITYTYPE_API_SECURITY     FindingVulnerabilityType = "api_security"
)

var allowedFindingVulnerabilityTypeEnumValues = []FindingVulnerabilityType{
	FINDINGVULNERABILITYTYPE_MISCONFIGURATION,
	FINDINGVULNERABILITYTYPE_ATTACK_PATH,
	FINDINGVULNERABILITYTYPE_IDENTITY_RISK,
	FINDINGVULNERABILITYTYPE_API_SECURITY,
}

// GetAllowedValues reeturns the list of possible values.
func (v *FindingVulnerabilityType) GetAllowedValues() []FindingVulnerabilityType {
	return allowedFindingVulnerabilityTypeEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *FindingVulnerabilityType) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = FindingVulnerabilityType(value)
	return nil
}

// NewFindingVulnerabilityTypeFromValue returns a pointer to a valid FindingVulnerabilityType
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewFindingVulnerabilityTypeFromValue(v string) (*FindingVulnerabilityType, error) {
	ev := FindingVulnerabilityType(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for FindingVulnerabilityType: valid values are %v", v, allowedFindingVulnerabilityTypeEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v FindingVulnerabilityType) IsValid() bool {
	for _, existing := range allowedFindingVulnerabilityTypeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to FindingVulnerabilityType value.
func (v FindingVulnerabilityType) Ptr() *FindingVulnerabilityType {
	return &v
}
