// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityEcosystem The related vulnerability asset ecosystem.
type VulnerabilityEcosystem string

// List of VulnerabilityEcosystem.
const (
	VULNERABILITYECOSYSTEM_PYPI      VulnerabilityEcosystem = "PyPI"
	VULNERABILITYECOSYSTEM_MAVEN     VulnerabilityEcosystem = "Maven"
	VULNERABILITYECOSYSTEM_NUGET     VulnerabilityEcosystem = "NuGet"
	VULNERABILITYECOSYSTEM_NPM       VulnerabilityEcosystem = "Npm"
	VULNERABILITYECOSYSTEM_RUBY_GEMS VulnerabilityEcosystem = "RubyGems"
	VULNERABILITYECOSYSTEM_GO        VulnerabilityEcosystem = "Go"
	VULNERABILITYECOSYSTEM_PACKAGIST VulnerabilityEcosystem = "Packagist"
	VULNERABILITYECOSYSTEM_D_DEB     VulnerabilityEcosystem = "Ddeb"
	VULNERABILITYECOSYSTEM_RPM       VulnerabilityEcosystem = "Rpm"
	VULNERABILITYECOSYSTEM_APK       VulnerabilityEcosystem = "Apk"
	VULNERABILITYECOSYSTEM_WINDOWS   VulnerabilityEcosystem = "Windows"
)

var allowedVulnerabilityEcosystemEnumValues = []VulnerabilityEcosystem{
	VULNERABILITYECOSYSTEM_PYPI,
	VULNERABILITYECOSYSTEM_MAVEN,
	VULNERABILITYECOSYSTEM_NUGET,
	VULNERABILITYECOSYSTEM_NPM,
	VULNERABILITYECOSYSTEM_RUBY_GEMS,
	VULNERABILITYECOSYSTEM_GO,
	VULNERABILITYECOSYSTEM_PACKAGIST,
	VULNERABILITYECOSYSTEM_D_DEB,
	VULNERABILITYECOSYSTEM_RPM,
	VULNERABILITYECOSYSTEM_APK,
	VULNERABILITYECOSYSTEM_WINDOWS,
}

// GetAllowedValues reeturns the list of possible values.
func (v *VulnerabilityEcosystem) GetAllowedValues() []VulnerabilityEcosystem {
	return allowedVulnerabilityEcosystemEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *VulnerabilityEcosystem) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = VulnerabilityEcosystem(value)
	return nil
}

// NewVulnerabilityEcosystemFromValue returns a pointer to a valid VulnerabilityEcosystem
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewVulnerabilityEcosystemFromValue(v string) (*VulnerabilityEcosystem, error) {
	ev := VulnerabilityEcosystem(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for VulnerabilityEcosystem: valid values are %v", v, allowedVulnerabilityEcosystemEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v VulnerabilityEcosystem) IsValid() bool {
	for _, existing := range allowedVulnerabilityEcosystemEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to VulnerabilityEcosystem value.
func (v VulnerabilityEcosystem) Ptr() *VulnerabilityEcosystem {
	return &v
}
