// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the log groups that were analyzed during a single CloudWatch
// Logs Insights query. This can be useful for queries that use log group name
// prefixes or the filterIndex command, because the log groups are dynamically
// selected in these cases.
//
// For more information about field indexes, see [Create field indexes to improve query performance and reduce costs].
//
// [Create field indexes to improve query performance and reduce costs]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html
func (c *Client) ListLogGroupsForQuery(ctx context.Context, params *ListLogGroupsForQueryInput, optFns ...func(*Options)) (*ListLogGroupsForQueryOutput, error) {
	if params == nil {
		params = &ListLogGroupsForQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLogGroupsForQuery", params, optFns, c.addOperationListLogGroupsForQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLogGroupsForQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLogGroupsForQueryInput struct {

	// The ID of the query to use. This query ID is from the response to your [StartQuery]
	// operation.
	//
	// [StartQuery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
	//
	// This member is required.
	QueryId *string

	// Limits the number of returned log groups to the specified number.
	MaxResults *int32

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLogGroupsForQueryOutput struct {

	// An array of the names and ARNs of the log groups that were processed in the
	// query.
	LogGroupIdentifiers []string

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLogGroupsForQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListLogGroupsForQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListLogGroupsForQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLogGroupsForQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListLogGroupsForQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLogGroupsForQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListLogGroupsForQueryPaginatorOptions is the paginator options for
// ListLogGroupsForQuery
type ListLogGroupsForQueryPaginatorOptions struct {
	// Limits the number of returned log groups to the specified number.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLogGroupsForQueryPaginator is a paginator for ListLogGroupsForQuery
type ListLogGroupsForQueryPaginator struct {
	options   ListLogGroupsForQueryPaginatorOptions
	client    ListLogGroupsForQueryAPIClient
	params    *ListLogGroupsForQueryInput
	nextToken *string
	firstPage bool
}

// NewListLogGroupsForQueryPaginator returns a new ListLogGroupsForQueryPaginator
func NewListLogGroupsForQueryPaginator(client ListLogGroupsForQueryAPIClient, params *ListLogGroupsForQueryInput, optFns ...func(*ListLogGroupsForQueryPaginatorOptions)) *ListLogGroupsForQueryPaginator {
	if params == nil {
		params = &ListLogGroupsForQueryInput{}
	}

	options := ListLogGroupsForQueryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLogGroupsForQueryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLogGroupsForQueryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLogGroupsForQuery page.
func (p *ListLogGroupsForQueryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLogGroupsForQueryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLogGroupsForQuery(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLogGroupsForQueryAPIClient is a client that implements the
// ListLogGroupsForQuery operation.
type ListLogGroupsForQueryAPIClient interface {
	ListLogGroupsForQuery(context.Context, *ListLogGroupsForQueryInput, ...func(*Options)) (*ListLogGroupsForQueryOutput, error)
}

var _ ListLogGroupsForQueryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLogGroupsForQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLogGroupsForQuery",
	}
}
