// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"go.opentelemetry.io/collector/confmap"
)

// ResourceAttributeConfig provides common config for a particular resource attribute.
type ResourceAttributeConfig struct {
	Enabled bool `mapstructure:"enabled"`

	enabledSetByUser bool
}

func (rac *ResourceAttributeConfig) Unmarshal(parser *confmap.Conf) error {
	if parser == nil {
		return nil
	}
	err := parser.Unmarshal(rac)
	if err != nil {
		return err
	}
	rac.enabledSetByUser = parser.IsSet("enabled")
	return nil
}

// ResourceAttributesConfig provides config for novadetector resource attributes.
type ResourceAttributesConfig struct {
	CloudAccountID        ResourceAttributeConfig `mapstructure:"cloud.account.id"`
	CloudAvailabilityZone ResourceAttributeConfig `mapstructure:"cloud.availability_zone"`
	CloudPlatform         ResourceAttributeConfig `mapstructure:"cloud.platform"`
	CloudProvider         ResourceAttributeConfig `mapstructure:"cloud.provider"`
	HostID                ResourceAttributeConfig `mapstructure:"host.id"`
	HostName              ResourceAttributeConfig `mapstructure:"host.name"`
	HostType              ResourceAttributeConfig `mapstructure:"host.type"`
}

func DefaultResourceAttributesConfig() ResourceAttributesConfig {
	return ResourceAttributesConfig{
		CloudAccountID: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudAvailabilityZone: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudPlatform: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudProvider: ResourceAttributeConfig{
			Enabled: true,
		},
		HostID: ResourceAttributeConfig{
			Enabled: true,
		},
		HostName: ResourceAttributeConfig{
			Enabled: true,
		},
		HostType: ResourceAttributeConfig{
			Enabled: true,
		},
	}
}
