/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;

public final class SManager extends SecurityManager {

    private static SManager instance;

    public static void init() {
        SManager sm = new SManager();
        instance = sm;
        System.setSecurityManager(sm);
    }

    private static class Privileged {
        static Container getContainer(Class[] stack) {
            for (int i=0;i<stack.length;i++) {
                if (stack[i].equals(Privileged.class)) {
                    return null;
                }
            }
            return Container.my();
        }
    }

    private static synchronized SecurityManager get() {
        Container container = Privileged.getContainer(instance.getClassContext());
        if (container==null) return null;
        return container.securityManager;
    }

    public void checkPermission(Permission perm) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPermission(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPermission(perm, context);
    }

    public void checkCreateClassLoader() {
        SecurityManager sm = get();
        if (sm!=null) sm.checkCreateClassLoader();
    }

    public void checkAccess(Thread t) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkAccess(t);
    }

    public void checkAccess(ThreadGroup g) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkAccess(g);
    }

    public void checkExit(int status) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkExit(status);
    }

    public void checkExec(String cmd) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkExec(cmd);
    }

    public void checkLink(String lib) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkLink(lib);
    }

    public void checkRead(FileDescriptor fd) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkRead(fd);
    }

    public void checkRead(String file) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkRead(file);
    }

    public void checkRead(String file, Object context) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkRead(file, context);
    }

    public void checkWrite(FileDescriptor fd) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkWrite(fd);
    }

    public void checkWrite(String file) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkWrite(file);
    }

    public void checkDelete(String file) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkDelete(file);
    }

    public void checkConnect(String host, int port) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkConnect(host, port);
    }

    public void checkConnect(String host, int port, Object context) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkConnect(host, port, context);
    }

    public void checkListen(int port) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkListen(port);
    }

    public void checkAccept(String host, int port) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkAccept(host, port);
    }

    public void checkMulticast(InetAddress maddr) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkMulticast(maddr);
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkMulticast(maddr, ttl);
    }

    public void checkPropertiesAccess() {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPropertiesAccess();
    }

    public void checkPropertyAccess(String key) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPropertyAccess(key);
    }

    public void checkPrintJobAccess() {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPrintJobAccess();
    }

    public void checkPackageAccess(String pkg) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPackageAccess(pkg);
    }

    public void checkPackageDefinition(String pkg) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkPackageDefinition(pkg);
    }

    public void checkSetFactory() {
        SecurityManager sm = get();
        if (sm!=null) sm.checkSetFactory();
    }

    public void checkSecurityAccess(String target) {
        SecurityManager sm = get();
        if (sm!=null) sm.checkSecurityAccess(target);
    }

    public ThreadGroup getThreadGroup() {
        SecurityManager sm = get();
        if (sm!=null) return sm.getThreadGroup();
        return super.getThreadGroup();
    }
}

