/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader.response;

import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.downloader.response.ResponseStatus;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResponseImpl<T>
implements Response<T> {
    private Future<T> data;
    private Throwable error;

    private ResponseImpl(Future<T> future, Throwable throwable) {
        this.data = future;
        this.error = throwable;
    }

    public static <T> ResponseImpl<T> from(final T t) {
        Future future = new Future<T>(){

            @Override
            public T get(long l, TimeUnit timeUnit) {
                return this.get();
            }

            @Override
            public T get() {
                return t;
            }

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
        return ResponseImpl.fromFuture(future);
    }

    public static <T> ResponseImpl<T> fromFuture(Future<T> future) {
        return new ResponseImpl<T>(future, null);
    }

    public static <T> ResponseImpl<T> error(Throwable throwable) {
        return new ResponseImpl<T>(null, throwable);
    }

    @Override
    public T data() {
        if (this.data != null) {
            try {
                return this.data.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                this.error = exception;
            }
        }
        return null;
    }

    @Override
    public T data(long l, TimeUnit timeUnit) throws TimeoutException {
        if (this.data != null) {
            try {
                return this.data.get(l, timeUnit);
            }
            catch (InterruptedException | ExecutionException exception) {
                this.error = exception;
            }
        }
        return null;
    }

    @Override
    public Throwable error() {
        if (this.data != null) {
            try {
                this.data.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                this.error = exception;
                return exception;
            }
        }
        return this.error;
    }

    @Override
    public ResponseStatus status() {
        if (this.error != null) {
            return ResponseStatus.error;
        }
        if (this.data != null) {
            if (this.data.isCancelled()) {
                return ResponseStatus.canceled;
            }
            try {
                this.data.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException cancellationException) {
                return ResponseStatus.canceled;
            }
            catch (TimeoutException timeoutException) {
                return ResponseStatus.downloading;
            }
            catch (InterruptedException | ExecutionException exception) {
                this.error = exception;
                return ResponseStatus.error;
            }
            return ResponseStatus.completed;
        }
        return ResponseStatus.error;
    }

    @Override
    public boolean ok() {
        if (this.error != null) {
            return false;
        }
        try {
            this.data.get();
            return true;
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception exception) {
            this.error = exception;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (this.error != null) {
            return false;
        }
        return this.data.cancel(true);
    }
}

