/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    private static final char[] ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static String removeIllegalChars(String string) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            string = string.replace(c, '_');
        }
        return string;
    }

    public static void createOutDir(File file) throws IOException {
        boolean bl;
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("Could not create output directory: " + file);
        }
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int parseLengthSeconds(String string) {
        try {
            int n = 0;
            int n2 = 0;
            if (string.length() > 2) {
                int n3;
                if (string.length() > 5) {
                    n3 = string.indexOf(58);
                    n += Integer.parseInt(string.substring(0, n3)) * 3600;
                    n2 = n3 + 1;
                }
                n3 = string.indexOf(58, n2);
                n += Integer.parseInt(string.substring(n2, n3)) * 60;
                n2 = n3 + 1;
            }
            return n += Integer.parseInt(string.substring(n2));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            return -1;
        }
    }

    public static long parseViewCount(String string) {
        if (string == null || string.isEmpty()) {
            return 0L;
        }
        String string2 = string.replaceAll("[^0-9]", "");
        if (!string2.isEmpty()) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static String parseRuns(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("runs");
        if (jSONArray == null) {
            return null;
        }
        if (jSONArray.size() == 1) {
            return jSONArray.getJSONObject(0).getString("text");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jSONArray.size(); ++i) {
            stringBuilder.append(jSONArray.getJSONObject(i).getString("text"));
        }
        return stringBuilder.toString();
    }

    public static List<String> parseThumbnails(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("thumbnails");
        if (jSONArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(jSONArray.size());
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.containsKey("url")) continue;
            arrayList.add(jSONObject2.getString("url"));
        }
        return arrayList;
    }
}

