/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.search.AbstractSearchResultList;
import com.github.kiulian.downloader.model.search.SearchResultItemType;
import java.util.LinkedList;

public class SearchResultPlaylistDetails
extends AbstractSearchResultList {
    private final String playlistId;
    private final int videoCount;

    public SearchResultPlaylistDetails(JSONObject jSONObject) {
        super(jSONObject);
        this.playlistId = jSONObject.getString("playlistId");
        JSONArray jSONArray = jSONObject.getJSONArray("thumbnails");
        this.thumbnails = new LinkedList();
        for (int i = 0; i < jSONArray.size(); ++i) {
            this.thumbnails.addAll(Utils.parseThumbnails(jSONArray.getJSONObject(i)));
        }
        this.videoCount = jSONObject.containsKey("videoCount") ? Integer.parseInt(jSONObject.getString("videoCount")) : -1;
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.PLAYLIST;
    }

    @Override
    public SearchResultPlaylistDetails asPlaylist() {
        return this;
    }

    public String playlistId() {
        return this.playlistId;
    }

    public int videoCount() {
        return this.videoCount;
    }
}

