/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class Profile {
    public static final byte TIMER_START = 0;
    public static final byte TIMER_STOP = 1;
    public static final byte MESSAGE = 2;
    private static DatagramSocket socket = null;
    private static DatagramPacket packet;
    private static byte[] stopBuf;
    private static int token;
    public static final byte TID_ANIMATION = -1;
    public static final byte TID_SETUP = -2;

    private Profile() {
    }

    public static void initProfiler(int n, String string) {
        Debug.println("***  Profiling data being sent to host " + string + " port " + n);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            socket = new DatagramSocket();
            packet = new DatagramPacket(stopBuf, stopBuf.length, inetAddress, n);
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            socket = null;
        }
    }

    public static void initTokenStart(int n) {
        if (n < token) {
            Debug.assertFail("Illegal token start value " + n + " < " + token);
        }
        token = n;
    }

    public static byte[] makeProfileTimer(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
        byte[] byArray2 = new byte[byArray.length + 6];
        System.arraycopy(byArray, 0, byArray2, 6, byArray.length);
        byArray = null;
        return byArray2;
    }

    public static byte[] makeMessage(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        byArray = null;
        return byArray2;
    }

    public static synchronized void doneProfiling() {
        if (socket != null) {
            socket.close();
        }
        socket = null;
    }

    public static synchronized int startTimer(byte[] byArray, byte by) {
        ++token;
        DatagramSocket datagramSocket = socket;
        if (datagramSocket != null) {
            byArray[0] = 0;
            byArray[1] = (byte)(token >> 24 & 0xFF);
            byArray[2] = (byte)(token >> 16 & 0xFF);
            byArray[3] = (byte)(token >> 8 & 0xFF);
            byArray[4] = (byte)(token & 0xFF);
            byArray[5] = by;
            try {
                packet.setData(byArray);
                datagramSocket.send(packet);
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
            }
        }
        return token;
    }

    public static synchronized void stopTimer(int n) {
        DatagramSocket datagramSocket = socket;
        if (datagramSocket != null) {
            Profile.stopBuf[0] = 1;
            Profile.stopBuf[1] = (byte)(n >> 24 & 0xFF);
            Profile.stopBuf[2] = (byte)(n >> 16 & 0xFF);
            Profile.stopBuf[3] = (byte)(n >> 8 & 0xFF);
            Profile.stopBuf[4] = (byte)(n & 0xFF);
            try {
                packet.setData(stopBuf);
                datagramSocket.send(packet);
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
            }
        }
    }

    public static synchronized void sendMessage(byte[] byArray) {
        DatagramSocket datagramSocket = socket;
        if (datagramSocket != null) {
            byArray[0] = 2;
            try {
                packet.setData(byArray);
                datagramSocket.send(packet);
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
            }
        }
    }

    static {
        stopBuf = new byte[5];
        token = 0;
    }
}

