/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.bdjo;

import com.hdcookbook.grin.util.BitStreamIO;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import org.tinymediamanager.library.bluray.bdjo.AppCacheEntry;
import org.tinymediamanager.library.bluray.bdjo.AppCacheInfo;
import org.tinymediamanager.library.bluray.bdjo.AppInfo;
import org.tinymediamanager.library.bluray.bdjo.AppName;
import org.tinymediamanager.library.bluray.bdjo.AppProfile;
import org.tinymediamanager.library.bluray.bdjo.ApplicationDescriptor;
import org.tinymediamanager.library.bluray.bdjo.ApplicationManagementTable;
import org.tinymediamanager.library.bluray.bdjo.BDJO;
import org.tinymediamanager.library.bluray.bdjo.HaviDeviceConfig;
import org.tinymediamanager.library.bluray.bdjo.HexStringByteAdapter;
import org.tinymediamanager.library.bluray.bdjo.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.bdjo.HexStringShortAdapter;
import org.tinymediamanager.library.bluray.bdjo.TableOfAccessiblePlayLists;
import org.tinymediamanager.library.bluray.bdjo.TerminalInfo;

public final class BDJOWriter {
    private static final String FOUR_SPACES = "    ";

    private BDJOWriter() {
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void writeValue(int n, Object object, PrintWriter printWriter) {
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            if (clazz == Character.TYPE) {
                printWriter.print('\'');
                printWriter.print(object);
                printWriter.print('\'');
            } else {
                printWriter.print(object);
            }
        } else if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            printWriter.print(enum_.name());
            printWriter.print(":<<");
            printWriter.print(clazz.getName());
            printWriter.print(">>");
        } else if (object instanceof Number) {
            printWriter.print(object.toString());
        } else if (object instanceof String) {
            printWriter.print('\"');
            printWriter.print(BDJOWriter.escape((String)object));
            printWriter.print('\"');
        } else if (object instanceof Character) {
            printWriter.print('\'');
            printWriter.print(((Character)object).charValue());
            printWriter.print('\'');
        } else if (object instanceof Boolean) {
            printWriter.print((Boolean)object);
        } else {
            BDJOWriter.writeObjectLiteral(n + 1, object, printWriter);
        }
    }

    private static void writeObjectLiteral(int n, Object object, PrintWriter printWriter) {
        try {
            Class<?> clazz = object.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            boolean bl = clazz.isArray();
            if (bl) {
                int n2;
                printWriter.println('[');
                int n3 = Array.getLength(object);
                Class<?> clazz2 = clazz.getComponentType();
                for (n2 = 0; n2 < n3; ++n2) {
                    Object object2 = Array.get(object, n2);
                    for (int i = 0; i < n; ++i) {
                        printWriter.print(FOUR_SPACES);
                    }
                    if (object2 == null) {
                        printWriter.print("null");
                    } else {
                        BDJOWriter.writeValue(n, object2, printWriter);
                    }
                    printWriter.println(", ");
                }
                for (n2 = 0; n2 < n - 1; ++n2) {
                    printWriter.print(FOUR_SPACES);
                }
                printWriter.print(']');
            } else {
                printWriter.println('{');
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                    Class<?> clazz3 = propertyDescriptor.getPropertyType();
                    Method method = propertyDescriptor.getReadMethod();
                    Object object3 = method.invoke(object, (Object[])null);
                    String string = propertyDescriptor.getName();
                    if (string.equals("class") || object3 == null) continue;
                    for (int i = 0; i < n; ++i) {
                        printWriter.print(FOUR_SPACES);
                    }
                    printWriter.print(string);
                    printWriter.print(" : ");
                    XmlJavaTypeAdapter xmlJavaTypeAdapter = method.getAnnotation(XmlJavaTypeAdapter.class);
                    if (xmlJavaTypeAdapter != null) {
                        Class clazz4 = xmlJavaTypeAdapter.value();
                        int n4 = 0;
                        if (clazz4 == HexStringByteAdapter.class) {
                            n4 = 0xFF & ((Byte)object3).intValue();
                            printWriter.print("0x" + Integer.toHexString(n4));
                        } else if (clazz4 == HexStringShortAdapter.class) {
                            n4 = 0xFFFF & ((Short)object3).intValue();
                            printWriter.print("0x" + Integer.toHexString(n4));
                        } else if (clazz4 == HexStringIntegerAdapter.class) {
                            n4 = (Integer)object3;
                            printWriter.print("0x" + Integer.toHexString(n4));
                        } else {
                            BDJOWriter.writeValue(n, object3, printWriter);
                        }
                    } else {
                        BDJOWriter.writeValue(n, object3, printWriter);
                    }
                    printWriter.println(",");
                }
                for (int i = 0; i < n - 1; ++i) {
                    printWriter.print(FOUR_SPACES);
                }
                printWriter.print('}');
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void writeFX(BDJO bDJO, Writer writer) throws IOException {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        String string = BDJO.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        printWriter.println("// Generated on " + new Date());
        printWriter.println();
        printWriter.print("import ");
        printWriter.print(string2);
        printWriter.println(".*;");
        printWriter.println();
        printWriter.print("BDJO ");
        BDJOWriter.writeObjectLiteral(1, bDJO, printWriter);
        printWriter.flush();
    }

    public static void writeXML(BDJO bDJO, Writer writer) throws JAXBException {
        String string = BDJO.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        marshaller.marshal((Object)bDJO, writer);
    }

    public static String writeXML(BDJO bDJO) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        BDJOWriter.writeXML(bDJO, stringWriter);
        return stringWriter.toString();
    }

    private static byte[] getISO646Bytes(String string) {
        try {
            return string.getBytes("ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static int getUTF8Length(String string) {
        return BDJOWriter.getUTF8Bytes(string).length;
    }

    private static byte[] writeTerminalInfoBuf(TerminalInfo terminalInfo) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BitStreamIO bitStreamIO = new BitStreamIO();
        dataOutputStream.writeInt(10);
        String string = terminalInfo.getDefaultFontFile();
        if (string == null) {
            string = "*****";
        }
        dataOutputStream.write(BDJOWriter.getISO646Bytes(string));
        HaviDeviceConfig haviDeviceConfig = terminalInfo.getInitialHaviConfig();
        int n = haviDeviceConfig.getId();
        bitStreamIO.writeBits(dataOutputStream, 4, haviDeviceConfig.getId());
        bitStreamIO.writeBits(dataOutputStream, 1, terminalInfo.isMenuCallMask() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 1, terminalInfo.isTitleSearchMask() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 1, terminalInfo.isMouseSupported() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 1, terminalInfo.isMouseInterest() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 2, terminalInfo.getInitialOutputMode());
        bitStreamIO.writeBits(dataOutputStream, 4, terminalInfo.getInitialFrameRate());
        bitStreamIO.writeBitsLong(dataOutputStream, 26, 0L);
        bitStreamIO.assertByteAligned(1);
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] writeAppCacheInfoBuf(AppCacheInfo appCacheInfo) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        AppCacheEntry[] appCacheEntryArray = appCacheInfo.getEntries();
        if (appCacheEntryArray == null) {
            appCacheEntryArray = new AppCacheEntry[]{};
        }
        int n = 2 + appCacheEntryArray.length * 12;
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(appCacheEntryArray.length);
        dataOutputStream.writeByte(0);
        for (AppCacheEntry appCacheEntry : appCacheEntryArray) {
            String string;
            dataOutputStream.writeByte(appCacheEntry.getType());
            String string2 = appCacheEntry.getName();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = appCacheEntry.getLanguage()) == null) {
                string = "eng";
            }
            dataOutputStream.write(BDJOWriter.getISO646Bytes(string2));
            dataOutputStream.write(BDJOWriter.getISO646Bytes(string));
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] writeTableOfAccessiblePlayListsBuf(TableOfAccessiblePlayLists tableOfAccessiblePlayLists) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BitStreamIO bitStreamIO = new BitStreamIO();
        String[] stringArray = tableOfAccessiblePlayLists.getPlayListFileNames();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 4 + stringArray.length * 6;
        dataOutputStream.writeInt(n);
        bitStreamIO.writeBits(dataOutputStream, 11, stringArray.length);
        bitStreamIO.writeBits(dataOutputStream, 1, tableOfAccessiblePlayLists.isAccessToAllFlag() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 1, tableOfAccessiblePlayLists.isAutostartFirstPlayListFlag() ? 1 : 0);
        bitStreamIO.writeBits(dataOutputStream, 3, 0);
        bitStreamIO.assertByteAligned(1);
        dataOutputStream.writeShort(0);
        for (String string : stringArray) {
            if (string == null) {
                string = "";
            }
            dataOutputStream.write(BDJOWriter.getISO646Bytes(string));
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] writeApplicationDescriptorBuf(ApplicationDescriptor applicationDescriptor) throws IOException {
        void var9_11;
        int n;
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BitStreamIO bitStreamIO = new BitStreamIO();
        AppProfile[] appProfileArray = applicationDescriptor.getProfiles();
        if (appProfileArray == null) {
            appProfileArray = new AppProfile[]{};
        }
        int n2 = 6 + appProfileArray.length * 6 + 1 + 1 + 2;
        AppName[] appNameArray = applicationDescriptor.getNames();
        if (appNameArray == null) {
            appNameArray = new AppName[]{};
        }
        int n3 = 0;
        for (AppName appName : appNameArray) {
            n3 += 3;
            ++n3;
            string = appName.getName();
            if (string == null) {
                string = "";
            }
            n = BDJOWriter.getUTF8Length(string);
            n3 += n;
        }
        n2 += n3;
        if ((n3 & 1) != 0) {
            ++n2;
        }
        ++n2;
        String string2 = applicationDescriptor.getIconLocator();
        if (string2 == null) {
            String string3 = "";
        }
        int n4 = var9_11.length();
        n2 += n4;
        if ((n4 & 1) == 0) {
            ++n2;
        }
        n2 += 2;
        ++n2;
        String string4 = applicationDescriptor.getBaseDirectory();
        if (string4 == null) {
            string4 = "";
        }
        int n5 = string4.length();
        n2 += n5;
        if ((n5 & 1) == 0) {
            ++n2;
        }
        ++n2;
        string = applicationDescriptor.getClasspathExtension();
        if (string == null) {
            string = "";
        }
        n = string.length();
        n2 += n;
        if ((n & 1) == 0) {
            ++n2;
        }
        ++n2;
        String string5 = applicationDescriptor.getInitialClassName();
        if (string5 == null) {
            string5 = "";
        }
        int n6 = BDJOWriter.getUTF8Length(string5);
        n2 += n6;
        if ((n6 & 1) == 0) {
            ++n2;
        }
        ++n2;
        String[] stringArray = applicationDescriptor.getParameters();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n7 = 0;
        for (String string6 : stringArray) {
            int n8 = BDJOWriter.getUTF8Length(string6);
            ++n7;
            n7 += n8;
        }
        n2 += n7;
        if ((n7 & 1) == 0) {
            ++n2;
        }
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(0);
        bitStreamIO.writeBits(dataOutputStream, 4, appProfileArray.length);
        bitStreamIO.writeBits(dataOutputStream, 12, 0);
        bitStreamIO.assertByteAligned(1);
        for (AppProfile appProfile : appProfileArray) {
            dataOutputStream.writeShort(appProfile.getProfile());
            dataOutputStream.writeByte(appProfile.getMajorVersion());
            dataOutputStream.writeByte(appProfile.getMinorVersion());
            dataOutputStream.writeByte(appProfile.getMicroVersion());
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(applicationDescriptor.getPriority());
        if (applicationDescriptor.getBinding() == null) {
            throw new IOException("Missing binding for application description whose initial class name is " + string5);
        }
        if (applicationDescriptor.getVisibility() == null) {
            throw new IOException("Missing visibility for application description whose initial class name is " + string5);
        }
        bitStreamIO.writeBits(dataOutputStream, 2, applicationDescriptor.getBinding().ordinal());
        bitStreamIO.writeBits(dataOutputStream, 2, applicationDescriptor.getVisibility().ordinal());
        bitStreamIO.writeBits(dataOutputStream, 4, 0);
        bitStreamIO.assertByteAligned(1);
        dataOutputStream.writeShort(n3);
        for (AppName appName : appNameArray) {
            String string7 = appName.getLanguage();
            if (string7 == null) {
                string7 = "eng";
            }
            dataOutputStream.write(BDJOWriter.getISO646Bytes(string7));
            String string8 = appName.getName();
            if (string8 == null) {
                string8 = "";
            }
            byte[] byArray = BDJOWriter.getUTF8Bytes(string8);
            dataOutputStream.writeByte(byArray.length);
            dataOutputStream.write(byArray);
            byArray = null;
        }
        if ((n3 & 1) != 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(n4);
        dataOutputStream.write(BDJOWriter.getISO646Bytes((String)var9_11));
        if ((n4 & 1) == 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeShort(applicationDescriptor.getIconFlags().shortValue());
        dataOutputStream.writeByte(n5);
        dataOutputStream.write(BDJOWriter.getISO646Bytes(string4));
        if ((n5 & 1) == 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(n);
        dataOutputStream.write(BDJOWriter.getISO646Bytes(string));
        if ((n & 1) == 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(n6);
        dataOutputStream.write(BDJOWriter.getUTF8Bytes(string5));
        if ((n6 & 1) == 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(n7);
        for (String string9 : stringArray) {
            void var22_34;
            if (string9 == null) {
                String string10 = "";
            }
            byte[] byArray = BDJOWriter.getUTF8Bytes((String)var22_34);
            dataOutputStream.writeByte(byArray.length);
            dataOutputStream.write(byArray);
            byArray = null;
        }
        if ((n7 & 1) == 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] writeApplicationManagementTableBuf(ApplicationManagementTable applicationManagementTable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        AppInfo[] appInfoArray = applicationManagementTable.getApplications();
        if (appInfoArray == null) {
            appInfoArray = new AppInfo[]{};
        }
        int n = 2;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(appInfoArray.length);
        for (AppInfo appInfo : appInfoArray) {
            ApplicationDescriptor object = appInfo.getApplicationDescriptor();
            n += 8;
            arrayList.add(BDJOWriter.writeApplicationDescriptorBuf(object));
        }
        for (byte[] byArray : arrayList) {
            n += byArray.length;
        }
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(appInfoArray.length);
        dataOutputStream.writeByte(0);
        int n2 = 0;
        for (AppInfo appInfo : appInfoArray) {
            dataOutputStream.writeByte(appInfo.getControlCode().byteValue());
            dataOutputStream.writeByte(appInfo.getType() << 4);
            dataOutputStream.writeInt(appInfo.getOrganizationId());
            dataOutputStream.writeShort(appInfo.getApplicationId().shortValue());
            dataOutputStream.write((byte[])arrayList.get(n2));
            ++n2;
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeBDJO(BDJO bDJO, OutputStream outputStream) throws IOException {
        TerminalInfo terminalInfo = bDJO.getTerminalInfo();
        if (terminalInfo == null) {
            terminalInfo = new TerminalInfo();
        }
        byte[] byArray = BDJOWriter.writeTerminalInfoBuf(terminalInfo);
        AppCacheInfo appCacheInfo = bDJO.getAppCacheInfo();
        if (appCacheInfo == null) {
            appCacheInfo = new AppCacheInfo();
        }
        byte[] byArray2 = BDJOWriter.writeAppCacheInfoBuf(appCacheInfo);
        TableOfAccessiblePlayLists tableOfAccessiblePlayLists = bDJO.getTableOfAccessiblePlayLists();
        if (tableOfAccessiblePlayLists == null) {
            tableOfAccessiblePlayLists = new TableOfAccessiblePlayLists();
        }
        byte[] byArray3 = BDJOWriter.writeTableOfAccessiblePlayListsBuf(tableOfAccessiblePlayLists);
        ApplicationManagementTable applicationManagementTable = bDJO.getApplicationManagementTable();
        if (applicationManagementTable == null) {
            applicationManagementTable = new ApplicationManagementTable();
        }
        byte[] byArray4 = BDJOWriter.writeApplicationManagementTableBuf(applicationManagementTable);
        String string = bDJO.getFileAccessInfo();
        if (string == null) {
            string = "";
        }
        byte[] byArray5 = BDJOWriter.getISO646Bytes(string);
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOutputStream.write(BDJOWriter.getISO646Bytes("BDJO"));
        dataOutputStream.write(BDJOWriter.getISO646Bytes(bDJO.getVersion().getValue()));
        dataOutputStream.writeInt(48);
        int n = 48 + byArray.length;
        dataOutputStream.writeInt(n);
        int n2 = n + byArray2.length;
        dataOutputStream.writeInt(n2);
        int n3 = n2 + byArray3.length;
        dataOutputStream.writeInt(n3);
        int n4 = n3 + byArray4.length;
        dataOutputStream.writeInt(n4);
        int n5 = n4 + 4;
        dataOutputStream.writeInt(n5);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeLong(0L);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray3);
        dataOutputStream.write(byArray4);
        dataOutputStream.writeInt(bDJO.getKeyInterestTable());
        dataOutputStream.writeShort(byArray5.length);
        dataOutputStream.write(byArray5);
        if ((byArray5.length & 1) != 0) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        BDJO bDJO = new BDJO();
        bDJO.setTerminalInfo(new TerminalInfo());
        ApplicationManagementTable applicationManagementTable = new ApplicationManagementTable();
        applicationManagementTable.setApplications(new AppInfo[0]);
        bDJO.setApplicationManagementTable(applicationManagementTable);
        BDJOWriter.writeFX(bDJO, new PrintWriter(System.out));
    }
}

