/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.AddrMap;
import org.tinymediamanager.library.bluray.clipinf.CLPIWriter;
import org.tinymediamanager.library.bluray.clipinf.ClipAttr;
import org.tinymediamanager.library.bluray.clipinf.ClipInfo;
import org.tinymediamanager.library.bluray.clipinf.StringIOHelper;
import org.tinymediamanager.library.bluray.clipinf.SubtitleAttr;

@XmlRootElement
@XmlType(propOrder={"typeIndicator", "versionNumber", "clipInfo", "clipAttr", "subtitleAttr", "addrMap"})
public class CLPIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPIObject.class);
    public static final String TYPE = "HDMV";
    private String typeIndicator;
    private String versionNumber;
    private ClipInfo clipInfo = new ClipInfo();
    private ClipAttr clipAttr = new ClipAttr();
    private SubtitleAttr subtitleAttr = new SubtitleAttr();
    private AddrMap addrMap = new AddrMap();

    public String getTypeIndicator() {
        return this.typeIndicator;
    }

    public void setTypeIndicator(String string) {
        this.typeIndicator = string;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String string) {
        this.versionNumber = string;
    }

    @XmlElement(name="ClipInfo")
    public ClipInfo getClipInfo() {
        return this.clipInfo;
    }

    public void setClipInfo(ClipInfo clipInfo) {
        this.clipInfo = clipInfo;
    }

    @XmlElement(name="ClipAttr")
    public ClipAttr getClipAttr() {
        return this.clipAttr;
    }

    public void setClipAttr(ClipAttr clipAttr) {
        this.clipAttr = clipAttr;
    }

    @XmlElement(name="SubtitleAttr")
    public SubtitleAttr getSubtitleAttr() {
        return this.subtitleAttr;
    }

    public void setSubtitleAttr(SubtitleAttr subtitleAttr) {
        this.subtitleAttr = subtitleAttr;
    }

    @XmlElement(name="AddrMap")
    public AddrMap getAddrMap() {
        return this.addrMap;
    }

    public void setAddrMap(AddrMap addrMap) {
        this.addrMap = addrMap;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.typeIndicator = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("typeIndicator={}", (Object)this.typeIndicator);
        this.versionNumber = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("versionNumber={}", (Object)this.versionNumber);
        int n = dataInputStream.readInt();
        LOGGER.trace("sequenceInfoStartAddress={}", (Object)n);
        int n2 = dataInputStream.readInt();
        LOGGER.trace("programInfoStartAddress={}", (Object)n2);
        int n3 = dataInputStream.readInt();
        LOGGER.trace("cpiStartAddress={}", (Object)n3);
        int n4 = dataInputStream.readInt();
        LOGGER.trace("clipMarkStartAddr={}", (Object)n4);
        int n5 = dataInputStream.readInt();
        LOGGER.trace("extDataStartAddr={}", (Object)n5);
        dataInputStream.skipBytes(12);
        this.clipInfo.readObject(dataInputStream);
        this.clipAttr.readObject(dataInputStream);
        this.subtitleAttr.readObject(dataInputStream);
        this.addrMap.readObject(dataInputStream);
    }

    public String toXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new CLPIWriter().writeXml(this, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
        ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream5 = new DataOutputStream(byteArrayOutputStream4);
        this.clipInfo.writeObject(dataOutputStream2);
        dataOutputStream2.flush();
        dataOutputStream2.close();
        this.clipAttr.writeObject(dataOutputStream3);
        dataOutputStream3.flush();
        dataOutputStream3.close();
        this.subtitleAttr.writeObject(dataOutputStream4);
        dataOutputStream4.flush();
        dataOutputStream4.close();
        this.addrMap.writeObject(dataOutputStream5);
        dataOutputStream5.flush();
        dataOutputStream5.close();
        int n2 = 40 + byteArrayOutputStream.size();
        int n3 = n2 + byteArrayOutputStream2.size();
        int n4 = n3 + byteArrayOutputStream3.size();
        int n5 = n4 + byteArrayOutputStream4.size();
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getTypeIndicator()));
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getVersionNumber()));
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeInt(n5);
        for (n = 0; n < 16; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.write(byteArrayOutputStream2.toByteArray());
        dataOutputStream.write(byteArrayOutputStream3.toByteArray());
        dataOutputStream.write(byteArrayOutputStream4.toByteArray());
        for (n = 0; n < 4; ++n) {
            dataOutputStream.write(0);
        }
    }
}

