/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.UOMaskTable;

public class AppInfoPlayList {
    PlaybackType playbackType;
    int playbackCount;
    UOMaskTable uoMaskTable = new UOMaskTable();
    boolean playListRandomAccessFlag;
    boolean audioMixAppFlag;
    boolean losslessFlag;

    public void setPlaybackType(PlaybackType playbackType) {
        this.playbackType = playbackType;
    }

    public PlaybackType getPlaybackType() {
        return this.playbackType;
    }

    public void setPlaybackCount(int n) {
        if ((this.getPlaybackType() == PlaybackType.RANDOM || this.getPlaybackType() == PlaybackType.SHUFFLE) && n < 1) {
            throw new IllegalArgumentException("Playback should be >= 1");
        }
        this.playbackCount = n;
    }

    public int getPlaybackCount() {
        return this.playbackCount;
    }

    public void setUOMaskTable(UOMaskTable uOMaskTable) {
        this.uoMaskTable = uOMaskTable;
    }

    public UOMaskTable getUOMaskTable() {
        return this.uoMaskTable;
    }

    public void setPlayListRandomAccessFlag(boolean bl) {
        this.playListRandomAccessFlag = bl;
    }

    public boolean getPlayListRandomAccessFlag() {
        return this.playListRandomAccessFlag;
    }

    public void setAudioMixAppFlag(boolean bl) {
        this.audioMixAppFlag = bl;
    }

    public boolean getAudioMixAppFlag() {
        return this.audioMixAppFlag;
    }

    public void setLosslessFlag(boolean bl) {
        this.losslessFlag = bl;
    }

    public boolean getLosslessFlag() {
        return this.losslessFlag;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        dataInputStream.skipBytes(5);
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedShort();
        PlaybackType[] playbackTypeArray = PlaybackType.values();
        for (n = 0; n < playbackTypeArray.length; ++n) {
            if (playbackTypeArray[n].ordinal() != n2) continue;
            this.setPlaybackType(playbackTypeArray[n]);
            break;
        }
        this.setPlaybackCount(n3);
        this.uoMaskTable.readObject(dataInputStream);
        n = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        this.setPlayListRandomAccessFlag((n & 0x80) != 0);
        this.setAudioMixAppFlag((n & 0x40) != 0);
        this.setLosslessFlag((n & 0x20) != 0);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeByte(0);
        dataOutputStream2.writeByte(this.getPlaybackType().ordinal());
        dataOutputStream2.writeShort(this.getPlaybackCount());
        this.uoMaskTable.writeObject(dataOutputStream2);
        int n = 0;
        if (this.getPlayListRandomAccessFlag()) {
            n = (byte)(n | 0x80);
        }
        if (this.getAudioMixAppFlag()) {
            n = (byte)(n | 0x40);
        }
        if (this.getLosslessFlag()) {
            n = (byte)(n | 0x20);
        }
        dataOutputStream2.writeByte(n);
        dataOutputStream2.writeByte(0);
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static enum PlaybackType {
        RESERVED,
        SEQUENTIAL,
        RANDOM,
        SHUFFLE;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

