/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import java.util.HashMap;

public class StreamCodingType {
    private static HashMap<Integer, StreamCodingType> types = new HashMap();
    private int value;
    private String description;

    static StreamCodingType getType(Integer n) {
        return types.get(n);
    }

    static void register(StreamCodingType streamCodingType) {
        Integer n = streamCodingType.getValue();
        if (types.containsKey(n)) {
            throw new IllegalArgumentException("StreamCodingType " + n + " already registered.");
        }
        types.put(n, streamCodingType);
    }

    public StreamCodingType(int n, String string) {
        this.setValue(n);
        this.setDescription(string);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isAudioStream() {
        int n = this.getValue() & 0xF0;
        return n == 128 || n == 160 || this.value == 3 || this.value == 4;
    }

    public boolean isVideoStream() {
        return this.getValue() == 1 || this.getValue() == 2 || this.getValue() == 6 || this.getValue() == 27 || this.getValue() == 234 || this.getValue() == 36;
    }

    public boolean isPGStream() {
        return this.getValue() == 144;
    }

    public boolean isIGStream() {
        return this.getValue() == 145;
    }

    public boolean isTextSubTitleStream() {
        return this.getValue() == 146;
    }

    static {
        StreamCodingType.register(new StreamCodingType(1, "MPEG-1 Video Stream for Primary / Secondary video"));
        StreamCodingType.register(new StreamCodingType(2, "MPEG-2 Video Stream for Primary / Secondary video"));
        StreamCodingType.register(new StreamCodingType(6, "HEVC h265???"));
        StreamCodingType.register(new StreamCodingType(234, "SMPTE VC-1 Video Stream for Primary / Secondary video"));
        StreamCodingType.register(new StreamCodingType(27, "MPEG-4 AVC Video Stream for Primary / Secondary video"));
        StreamCodingType.register(new StreamCodingType(36, "HEVC Video Stream for Primary / Secondary video"));
        StreamCodingType.register(new StreamCodingType(3, "MPEG-1 audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(4, "MPEG-2 audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(128, "HDMV LPCM audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(129, "Dolby Digital (AC-3) audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(130, "DTS audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(131, "Dolby Lossless audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(132, "Dolby Digital Plus audio stream for Primary audio"));
        StreamCodingType.register(new StreamCodingType(133, "DTS-HD audio stream except XLL for Primary audio"));
        StreamCodingType.register(new StreamCodingType(134, "DTS-HD audio stream XLL for Primary audio"));
        StreamCodingType.register(new StreamCodingType(161, "Dolby digital Plus audio stream for secondary audio"));
        StreamCodingType.register(new StreamCodingType(162, "DTS-HD audio stream for secondary audio"));
        StreamCodingType.register(new StreamCodingType(144, "Presentation Graphics Stream"));
        StreamCodingType.register(new StreamCodingType(145, "Interactive Graphics Stream"));
        StreamCodingType.register(new StreamCodingType(146, "Text Subtitle stream"));
    }
}

