/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.ParsableBox;

public class SkipBox
implements ParsableBox {
    private String type;
    private long size;
    private long sourcePosition = -1L;

    public SkipBox(String type, byte[] usertype, String parentType) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public long getContentSize() {
        return this.size - 8L;
    }

    public long getSourcePosition() {
        return this.sourcePosition;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        throw new RuntimeException("Cannot retrieve a skipped box - type " + this.type);
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.size = contentSize + 8L;
        if (!(dataSource instanceof FileChannel)) {
            throw new RuntimeException("Cannot skip box " + this.type + " if data source is not seekable");
        }
        FileChannel seekable = (FileChannel)dataSource;
        this.sourcePosition = seekable.position();
        long newPosition = this.sourcePosition + contentSize;
        seekable.position(newPosition);
    }
}

