/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class ApplicationModel {

    public static interface PropertyName {
        public static final String VOLUME = "volume";
        public static final String MUTED = "muted";
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("volume", "muted", "name", "version"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Application.Property.Value";
        public static final String MUTED = "muted";
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final String VOLUME = "volume";
        public final Boolean muted;
        public final String name;
        public final Version version;
        public final Integer volume;

        public PropertyValue(Boolean bl, String string, Version version, Integer n) {
            this.muted = bl;
            this.name = string;
            this.version = version;
            this.volume = n;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.muted = PropertyValue.parseBoolean(jsonNode, MUTED);
            this.name = PropertyValue.parseString(jsonNode, NAME);
            this.version = jsonNode.has(VERSION) ? new Version(jsonNode.get(VERSION)) : null;
            this.volume = PropertyValue.parseInt(jsonNode, VOLUME);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(MUTED, this.muted);
            objectNode.put(NAME, this.name);
            objectNode.put(VERSION, this.version == null ? null : this.version.toJsonNode());
            objectNode.put(VOLUME, this.volume);
            return objectNode;
        }

        static List<PropertyValue> getApplicationModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static class Version
        extends AbstractModel {
            public static final String MAJOR = "major";
            public static final String MINOR = "minor";
            public static final String REVISION = "revision";
            public static final String TAG = "tag";
            public static final String TAGVERSION = "tagversion";
            public final Integer major;
            public final Integer minor;
            public final Revision revision;
            public final String tag;
            public final String tagversion;

            public Version(Integer n, Integer n2, Revision revision, String string, String string2) {
                this.major = n;
                this.minor = n2;
                this.revision = revision;
                this.tag = string;
                this.tagversion = string2;
            }

            public Version(JsonNode jsonNode) {
                this.major = jsonNode.get(MAJOR).asInt();
                this.minor = jsonNode.get(MINOR).asInt();
                this.revision = jsonNode.has(REVISION) ? new Revision(jsonNode.get(REVISION)) : null;
                this.tag = Version.parseString(jsonNode, TAG);
                this.tagversion = Version.parseString(jsonNode, TAGVERSION);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(MAJOR, this.major);
                objectNode.put(MINOR, this.minor);
                objectNode.put(REVISION, this.revision == null ? null : this.revision.toJsonNode());
                objectNode.put(TAG, this.tag);
                objectNode.put(TAGVERSION, this.tagversion);
                return objectNode;
            }

            static List<Version> getApplicationModelVersionList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Version> arrayList = new ArrayList<Version>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Version(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Version>(0);
            }

            public static class Revision
            extends AbstractModel {
                public final Integer integerArg;
                public final String stringArg;

                public Revision(Integer n) {
                    this.integerArg = n;
                    this.stringArg = null;
                }

                public Revision(String string) {
                    this.stringArg = string;
                    this.integerArg = null;
                }

                public Revision(JsonNode jsonNode) {
                    if (jsonNode.isInt()) {
                        this.integerArg = jsonNode.asInt();
                        this.stringArg = null;
                    } else if (jsonNode.isTextual()) {
                        this.stringArg = jsonNode.asText();
                        this.integerArg = null;
                    } else {
                        throw new RuntimeException("Weird type for \"revision\", I'm confused!");
                    }
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.integerArg != null) {
                        return new IntNode(this.integerArg.intValue());
                    }
                    if (this.stringArg != null) {
                        return new TextNode(this.stringArg);
                    }
                    return null;
                }

                static List<Revision> getApplicationModelRevisionList(JsonNode jsonNode, String string) {
                    if (jsonNode.has(string)) {
                        ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                        ArrayList<Revision> arrayList = new ArrayList<Revision>(arrayNode.size());
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            arrayList.add(new Revision(arrayNode.get(i)));
                        }
                        return arrayList;
                    }
                    return new ArrayList<Revision>(0);
                }
            }

            public static interface Tag {
                public static final String PREALPHA = "prealpha";
                public static final String ALPHA = "alpha";
                public static final String BETA = "beta";
                public static final String RELEASECANDIDATE = "releasecandidate";
                public static final String STABLE = "stable";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("prealpha", "alpha", "beta", "releasecandidate", "stable"));
            }
        }
    }
}

