/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.entities.MediaEntity;

public abstract class PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostProcessExecutor.class);
    protected final PostProcess postProcess;

    protected PostProcessExecutor(PostProcess postProcess) {
        this.postProcess = postProcess;
    }

    public abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCommand(String[] cmdline, MediaEntity mediaEntity) throws IOException, InterruptedException {
        ProcessBuilder pb;
        ArrayList<String> commandList = new ArrayList<String>();
        String p = "";
        if (this.postProcess.getPath() != null) {
            p = this.postProcess.getPath().toLowerCase(Locale.ROOT);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            commandList.add("powershell");
            if (p.endsWith("exe") || p.endsWith("com")) {
                commandList.add("&");
                commandList.add("'" + this.postProcess.getPath() + "'");
                for (String cmd : cmdline) {
                    commandList.add("\\\"" + cmd + "\\\"");
                }
            } else if (p.endsWith("ps1")) {
                commandList.add("-ExecutionPolicy");
                commandList.add("ByPass");
                commandList.add("-File");
                commandList.add(this.postProcess.getPath());
                commandList.addAll(Arrays.asList(cmdline));
            } else if ((p.endsWith("bat") || p.endsWith("cmd")) && !mediaEntity.getDataSource().startsWith("\\\\")) {
                commandList.add("&");
                commandList.add("'" + this.postProcess.getPath() + "'");
                for (String cmd : cmdline) {
                    commandList.add("\\\"" + cmd + "\\\"");
                }
            } else {
                commandList.add("-Command");
                commandList.add(String.join((CharSequence)" ", cmdline));
            }
            pb = new ProcessBuilder(commandList);
        } else {
            pb = new ProcessBuilder("/bin/sh", "-c", this.postProcess.getPath() + " " + String.join((CharSequence)" ", cmdline));
        }
        pb.redirectErrorStream(true);
        pb.directory(mediaEntity.getPathNIO().toFile());
        LOGGER.debug("Running command: {}", pb.command());
        Process process = pb.start();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            new Thread(() -> {
                try {
                    IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)outputStream);
                }
                catch (IOException e) {
                    LOGGER.debug("could not get output from the process", (Throwable)e);
                }
            }).start();
            int processValue = process.waitFor();
            String response = outputStream.toString(StandardCharsets.UTF_8);
            if (processValue != 0) {
                LOGGER.warn("error at Script: '{}'", (Object)response);
                throw new IOException("error running Script - code '" + processValue + "'");
            }
            if (StringUtils.isNotBlank((CharSequence)response)) {
                LOGGER.info(response);
            }
            LOGGER.info("PostProcessing: END");
        }
        finally {
            process.destroy();
            IOUtils.close((Closeable)process.getErrorStream());
        }
    }
}

