/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedDateRenderer
implements NamedRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedDateRenderer.class);
    private static final String DEFAULT_PATTERN = "dd.MM.yyyy HH:mm:ss Z";

    private Date convert(Object o, DateFormat dateFormat) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Number) {
            long longValue = ((Number)o).longValue();
            return new Date(longValue);
        }
        if (o instanceof String) {
            try {
                try {
                    return dateFormat.parse((String)o);
                }
                catch (ParseException e) {
                    LOGGER.warn("cannot convert date format", (Throwable)e);
                }
            }
            catch (com.floreysoft.jmte.message.ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return "date";
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Date.class, String.class, Integer.class, Long.class};
    }

    public String render(Object o, String pattern, Locale locale, Map<String, Object> model) {
        String patternToUse = pattern != null ? pattern : DEFAULT_PATTERN;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(patternToUse);
            Date value = this.convert(o, dateFormat);
            if (value != null) {
                return dateFormat.format(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }
}

