/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.util.Locale;
import java.util.Map;

public class NamedFilesizeRenderer
implements NamedRenderer {
    public String render(Object o, String s, Locale locale, Map<String, Object> map) {
        if (o == null) {
            return "";
        }
        Object format = "%.2f";
        if (!(o instanceof Number)) {
            return o.toString();
        }
        float value = ((Number)o).longValue();
        String unit = s;
        if (unit == null) {
            unit = "G";
        }
        switch (unit) {
            case "K": 
            case "k": 
            case "kB": 
            case "KB": {
                value /= 1000.0f;
                break;
            }
            case "kiB": 
            case "KiB": {
                value /= 1024.0f;
                break;
            }
            case "M": 
            case "MB": {
                value /= 1000000.0f;
                break;
            }
            case "MiB": {
                value /= 1048576.0f;
                break;
            }
            case "GiB": {
                value /= 1.0737418E9f;
                break;
            }
            case "G": 
            case "GB": {
                value /= 1.0E9f;
                break;
            }
            default: {
                value /= 1.0E9f;
                unit = "G";
            }
        }
        format = (String)format + " " + unit;
        try {
            return String.format((String)format, Float.valueOf(value));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getName() {
        return "filesize";
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Integer.class, Float.class, Double.class};
    }
}

