/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.extended.ChainedNamedRenderer;
import com.floreysoft.jmte.message.DefaultErrorHandler;
import com.floreysoft.jmte.message.ErrorMessage;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.message.ResourceBundleMessage;
import com.floreysoft.jmte.template.OutputAppender;
import com.floreysoft.jmte.token.Token;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaEntityFilenameHistory;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedArrayUniqueRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedFramerateRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedSplitRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.PathRenderer;
import org.tinymediamanager.core.jmte.RegexpProcessor;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.TmmOutputAppender;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.movie.jmte.MovieNamedFirstCharacterRenderer;
import org.tinymediamanager.core.movie.jmte.MovieNamedIndexOfMovieSetRenderer;
import org.tinymediamanager.core.movie.jmte.MovieNamedIndexOfMovieSetWithDummyRenderer;
import org.tinymediamanager.core.threading.ThreadUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenamer.class);
    private static final List<String> KNOWN_IMAGE_FILE_EXTENSIONS = Arrays.asList("jpg", "jpeg", "png", "bmp", "tbn", "gif", "webp");
    private static final Pattern TITLE_PATTERN = Pattern.compile("\\$\\{.*?title.*?\\}", 2);
    private static final Pattern YEAR_ID_PATTERN = Pattern.compile("\\$\\{.*?(year|imdb|tmdb).*?\\}", 2);
    private static final Pattern ORIGINAL_FILENAME_PATTERN = Pattern.compile("\\$\\{.*?originalFilename.*?\\}", 2);
    private static final Pattern TRAILER_STACKING_PATTERN = Pattern.compile(".*?(\\d)$");
    private static final Map<String, String> TOKEN_MAP = MovieRenamer.createTokenMap();

    private MovieRenamer() {
        throw new IllegalAccessError();
    }

    private static Map<String, String> createTokenMap() {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("title", "movie.title");
        tokenMap.put("originalTitle", "movie.originalTitle");
        tokenMap.put("originalFilename", "movie.originalFilename");
        tokenMap.put("originalBasename", "movie.originalBasename");
        tokenMap.put("sorttitle", "movie.sortTitle");
        tokenMap.put("year", "movie.year");
        tokenMap.put("releaseDate", "movie.releaseDate;date(yyyy-MM-dd)");
        tokenMap.put("titleSortable", "movie.titleSortable");
        tokenMap.put("rating", "movie.rating.rating");
        tokenMap.put("imdb", "movie.imdbId");
        tokenMap.put("tmdb", "movie.tmdbId");
        tokenMap.put("certification", "movie.certification");
        tokenMap.put("language", "movie.spokenLanguages");
        tokenMap.put("genres", "movie.genres");
        tokenMap.put("genresAsString", "movie.genresAsString");
        tokenMap.put("tags", "movie.tags");
        tokenMap.put("tagsAsString", "movie.tagsAsString");
        tokenMap.put("actors", "movie.actors");
        tokenMap.put("producers", "movie.producers");
        tokenMap.put("directors", "movie.directors");
        tokenMap.put("writers", "movie.writers");
        tokenMap.put("productionCompany", "movie.productionCompany");
        tokenMap.put("productionCompanyAsArray", "movie.productionCompanyAsArray");
        tokenMap.put("videoCodec", "movie.mediaInfoVideoCodec");
        tokenMap.put("videoFormat", "movie.mediaInfoVideoFormat");
        tokenMap.put("aspectRatio", "movie.mediaInfoAspectRatioAsString");
        tokenMap.put("aspectRatio2", "movie.mediaInfoAspectRatio2AsString");
        tokenMap.put("videoResolution", "movie.mediaInfoVideoResolution");
        tokenMap.put("videoBitDepth", "movie.mediaInfoVideoBitDepth");
        tokenMap.put("videoBitRate", "movie.mediaInfoVideoBitrate;bitrate");
        tokenMap.put("framerate", "movie.mediaInfoFrameRate;framerate");
        tokenMap.put("audioCodec", "movie.mediaInfoAudioCodec");
        tokenMap.put("audioCodecList", "movie.mediaInfoAudioCodecList");
        tokenMap.put("audioCodecsAsString", "movie.mediaInfoAudioCodecList;array");
        tokenMap.put("audioChannels", "movie.mediaInfoAudioChannels");
        tokenMap.put("audioChannelList", "movie.mediaInfoAudioChannelList");
        tokenMap.put("audioChannelsAsString", "movie.mediaInfoAudioChannelList;array");
        tokenMap.put("audioChannelsDot", "movie.mediaInfoAudioChannelsDot");
        tokenMap.put("audioChannelDotList", "movie.mediaInfoAudioChannelDotList");
        tokenMap.put("audioChannelsDotAsString", "movie.mediaInfoAudioChannelDotList;array");
        tokenMap.put("audioLanguage", "movie.mediaInfoAudioLanguage");
        tokenMap.put("audioLanguageList", "movie.mediaInfoAudioLanguageList");
        tokenMap.put("audioLanguagesAsString", "movie.mediaInfoAudioLanguageList;array");
        tokenMap.put("subtitleLanguageList", "movie.mediaInfoSubtitleLanguageList");
        tokenMap.put("subtitleLanguagesAsString", "movie.mediaInfoSubtitleLanguageList;array");
        tokenMap.put("3Dformat", "movie.video3DFormat");
        tokenMap.put("3Dformat2", "movie.video3DFormat2");
        tokenMap.put("hdr", "movie.videoHDR");
        tokenMap.put("hdrformat", "movie.videoHDRFormat");
        tokenMap.put("filesize", "movie.videoFilesize;filesize");
        tokenMap.put("mediaSource", "movie.mediaSource");
        tokenMap.put("edition", "movie.edition");
        tokenMap.put("parent", "movie.parent");
        tokenMap.put("note", "movie.note");
        tokenMap.put("decadeLong", "movie.decadeLong");
        tokenMap.put("decadeShort", "movie.decadeShort");
        tokenMap.put("movieSetIndex", "movie;indexOfMovieSet");
        tokenMap.put("movieSetIndex2", "movie;indexOfMovieSetWithDummy");
        tokenMap.put("crc32", "movie.CRC32");
        return tokenMap;
    }

    public static Map<String, String> getTokenMap() {
        return Collections.unmodifiableMap(TOKEN_MAP);
    }

    public static Map<String, String> getTokenMapReversed() {
        return Collections.unmodifiableMap(TOKEN_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }

    private static void removeEmptySubfolders(Movie movie) {
        if (movie.isMultiMovieDir()) {
            return;
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(movie.getPathNIO());
        }
        catch (IOException e) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)e.getMessage());
        }
    }

    private static void cleanupUnwantedFiles(Movie movie) {
        if (movie.isMultiMovieDir()) {
            return;
        }
        if (MovieModuleManager.getInstance().getSettings().renamerCleanupUnwanted) {
            Utils.deleteUnwantedFilesAndFoldersFor(movie);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void renameMovie(Movie movie) {
        void var14_39;
        void var12_25;
        MediaFile del;
        void var10_13;
        if (MovieModuleManager.getInstance().getSettings().getRenamerPathname().isEmpty() && MovieModuleManager.getInstance().getSettings().getRenamerFilename().isEmpty()) {
            LOGGER.info("NOT renaming Movie '{}' - renaming patterns are empty!", (Object)movie.getTitle());
            return;
        }
        boolean posterRenamed = false;
        boolean fanartRenamed = false;
        if (StringUtils.isEmpty((CharSequence)movie.getDataSource())) {
            LOGGER.error("no Datasource set");
            return;
        }
        if (movie.getTitle().isEmpty()) {
            LOGGER.error("won't rename movie '{}' / '{}' not even title is set?", (Object)movie.getPathNIO(), (Object)movie.getTitle());
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<Object> cleanup = new ArrayList<Object>();
        MediaEntityFilenameHistory fileNameHistory = new MediaEntityFilenameHistory();
        LOGGER.info("Renaming movie: {}", (Object)movie.getTitle());
        LOGGER.debug("movie year: {}", (Object)movie.getYear());
        LOGGER.debug("movie path: {}", (Object)movie.getPathNIO());
        LOGGER.debug("movie isDisc?: {}", (Object)movie.isDisc());
        LOGGER.debug("movie isMulti?: {}", (Object)movie.isMultiMovieDir());
        if (movie.getMovieSet() != null) {
            LOGGER.debug("movieset: {}", (Object)movie.getMovieSet().getTitle());
        }
        LOGGER.debug("path expression: {}", (Object)MovieModuleManager.getInstance().getSettings().getRenamerPathname());
        LOGGER.debug("file expression: {}", (Object)MovieModuleManager.getInstance().getSettings().getRenamerFilename());
        String newPathname = MovieRenamer.createDestinationForFoldername(MovieModuleManager.getInstance().getSettings().getRenamerPathname(), movie);
        String oldPathname = movie.getPathNIO().toString();
        if (!newPathname.isEmpty()) {
            try {
                newPathname = Paths.get(movie.getDataSource(), newPathname).toString();
                if (!MovieRenamer.renameMovieFolder(movie, newPathname)) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.warn("new movie folder name is illegal - '{}'", (Object)e.getMessage());
                newPathname = movie.getPathNIO().toString();
            }
        } else {
            LOGGER.info("Folder rename settings were empty - NOT renaming folder");
            newPathname = movie.getPathNIO().toString();
        }
        movie.reEvaluateStacking();
        MovieNfoNaming[] e = MovieNfoNaming.values();
        int n = e.length;
        boolean bl = false;
        while (var10_13 < n) {
            Object s = e[var10_13];
            String string = movie.getNfoFilename((MovieNfoNaming)((Object)s));
            if (!StringUtils.isBlank((CharSequence)string)) {
                del = new MediaFile(movie.getPathNIO().resolve(string), MediaFileType.NFO);
                cleanup.add(del);
            }
            ++var10_13;
        }
        ArrayList<Enum> fileNamings = new ArrayList<Enum>();
        fileNamings.addAll(Arrays.asList(MoviePosterNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieFanartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieBannerNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieClearartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieClearlogoNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieThumbNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieDiscartNaming.values()));
        fileNamings.addAll(Arrays.asList(MovieKeyartNaming.values()));
        for (IFileNaming iFileNaming : fileNamings) {
            for (String string : KNOWN_IMAGE_FILE_EXTENSIONS) {
                del = new MediaFile(movie.getPathNIO().resolve(MovieArtworkHelper.getArtworkFilename(movie, iFileNaming, string)));
                cleanup.add(del);
            }
        }
        for (MediaFile mediaFile : movie.getMediaFiles()) {
            cleanup.add(new MediaFile(mediaFile));
        }
        cleanup.removeAll(Collections.singleton(null));
        String newVideoBasename = "";
        String string = Utils.cleanStackingMarkers(movie.getMainVideoFile().getBasename());
        if (!MovieRenamer.isFilePatternValid()) {
            newVideoBasename = movie.getVideoBasenameWithoutStacking();
            LOGGER.warn("Filepattern is not valid - NOT renaming files!");
        } else {
            MediaFile ftr = MovieRenamer.generateFilename(movie, movie.getMediaFiles(MediaFileType.VIDEO).get(0), newVideoBasename, string).get(0);
            newVideoBasename = FilenameUtils.getBaseName((String)ftr.getFilenameWithoutStacking());
        }
        LOGGER.debug("Our new basename for renaming: {}", (Object)newVideoBasename);
        for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            MediaFile newMF = MovieRenamer.generateFilename(movie, mediaFile, newVideoBasename).get(0);
            boolean bl2 = MovieRenamer.moveFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
            if (!bl2) {
                LOGGER.error("could not movie video file of movie '{}' - abort renaming", (Object)movie.getTitle());
                if (movie.isMultiMovieDir()) {
                    movie.setPath(oldPathname);
                }
                return;
            }
            fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, mediaFile.getFileAsPath(), newMF.getFileAsPath()));
            mediaFile.setFile(newMF.getFileAsPath());
            needed.add(mediaFile);
        }
        ArrayList<Object> mfs = new ArrayList<MediaFile>();
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.FANART));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.POSTER));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.BANNER));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.CLEARART));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.THUMB));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.LOGO));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.CLEARLOGO));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.DISC));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.KEYART));
        mfs.removeAll(Collections.singleton(null));
        for (Object mf : mfs) {
            LOGGER.trace("Rename 1:N {} - {}", (Object)((MediaFile)mf).getType(), (Object)((MediaFile)mf).getFileAsPath());
            List<MediaFile> list = MovieRenamer.generateFilename(movie, (MediaFile)mf, newVideoBasename);
            for (MediaFile newMF : list) {
                posterRenamed = true;
                fanartRenamed = true;
                boolean ok = MovieRenamer.copyFile(((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                needed.add(newMF);
                fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, ((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath()));
                if (!ImageCache.isImageCached(((MediaFile)mf).getFileAsPath())) continue;
                Path oldCache = ImageCache.getAbsolutePath((MediaFile)mf);
                Path newCache = ImageCache.getAbsolutePath(newMF);
                LOGGER.trace("updating imageCache {} -> {}", (Object)oldCache, (Object)newCache);
                try {
                    Files.copy(oldCache, newCache, new CopyOption[0]);
                }
                catch (IOException e2) {
                    LOGGER.warn("Error moving cached file - '{}'", (Object)e2.getMessage());
                }
            }
        }
        MediaFile mediaFile = MediaFile.EMPTY_MEDIAFILE;
        for (MediaFile mediaFile2 : movie.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile2.getFiledate() < var12_25.getFiledate() || !MovieConnectors.isValidNFO(mediaFile2.getFileAsPath())) continue;
            MediaFile mediaFile3 = new MediaFile(mediaFile2);
        }
        if (var12_25 != MediaFile.EMPTY_MEDIAFILE) {
            List<MediaFile> newNFOs = MovieRenamer.generateFilename(movie, (MediaFile)var12_25, newVideoBasename);
            if (!newNFOs.isEmpty()) {
                Iterator<MediaFile> iterator = newNFOs.iterator();
                while (iterator.hasNext()) {
                    MediaFile newNFO = iterator.next();
                    boolean ok = MovieRenamer.copyFile(var12_25.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    needed.add(newNFO);
                    fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, var12_25.getFileAsPath(), newNFO.getFileAsPath()));
                }
            } else {
                cleanup.add(var12_25);
            }
        } else {
            LOGGER.trace("No valid NFO found for this movie");
        }
        for (MediaFile mediaFile4 : movie.getMediaFiles(MediaFileType.NFO)) {
            if (MovieConnectors.isValidNFO(mediaFile4.getFileAsPath())) {
                cleanup.add(mediaFile4);
                continue;
            }
            if (MovieModuleManager.getInstance().getSettings().isRenamerNfoCleanup()) {
                cleanup.add(mediaFile4);
                continue;
            }
            needed.add(mediaFile4);
            fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, mediaFile4.getFileAsPath(), mediaFile4.getFileAsPath()));
        }
        mfs = new ArrayList<MediaFile>(movie.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.DISC, MediaFileType.KEYART, MediaFileType.SUBTITLE));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile5 : mfs) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile5.getType(), (Object)mediaFile5.getFileAsPath());
            List<MediaFile> newMFs = MovieRenamer.generateFilename(movie, mediaFile5, newVideoBasename, string);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = MovieRenamer.copyFile(mediaFile5.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, mediaFile5.getFileAsPath(), newMF.getFileAsPath()));
                    needed.add(newMF);
                    continue;
                }
                fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, mediaFile5.getFileAsPath(), mediaFile5.getFileAsPath()));
                needed.add(mediaFile5);
            }
        }
        for (MediaFile mediaFile6 : movie.getMediaFiles(MediaFileType.SUBTITLE)) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile6.getType(), (Object)mediaFile6.getFileAsPath());
            MediaFile newMF = MovieRenamer.generateFilename(movie, mediaFile6, newVideoBasename, string).get(0);
            boolean ok = MovieRenamer.moveFile(mediaFile6.getFileAsPath(), newMF.getFileAsPath());
            if (ok) {
                if (mediaFile6.getFilename().endsWith(".sub")) {
                    try {
                        Path oldidx = mediaFile6.getFileAsPath().resolveSibling(mediaFile6.getFilename().replaceFirst("sub$", "idx"));
                        Path newidx = newMF.getFileAsPath().resolveSibling(newMF.getFilename().toString().replaceFirst("sub$", "idx"));
                        Utils.moveFileSafe(oldidx, newidx);
                        fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, oldidx, newidx));
                    }
                    catch (Exception oldidx) {
                        // empty catch block
                    }
                }
                needed.add(newMF);
                fileNameHistory.addFilenameHistory(MovieRenamer.createFilenameHistory(newPathname, mediaFile6.getFileAsPath(), newMF.getFileAsPath()));
                continue;
            }
            LOGGER.error("could not rename subtitle file '{}'", (Object)mediaFile6.getFileAsPath());
            needed.add(mediaFile6);
        }
        for (MediaFile mediaFile7 : movie.getMediaFiles()) {
            if (!mediaFile7.isGraphic() || needed.contains(mediaFile7)) continue;
            ImageCache.invalidateCachedImage(mediaFile7);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        movie.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        movie.addToMediaFiles(needed);
        movie.setPath(newPathname);
        movie.gatherMediaFileInformation(false);
        if (MovieModuleManager.getInstance().getSettings().getMovieConnector() == MovieConnectors.MP && (posterRenamed || fanartRenamed)) {
            movie.writeNFO();
        }
        LOGGER.info("Cleanup...");
        if (movie.isMultiMovieDir()) {
            List<Path> list = Utils.listFiles(movie.getPathNIO());
        } else {
            List<Path> list = Utils.listFilesRecursive(movie.getPathNIO());
        }
        var14_39.addAll(Utils.listFiles(Paths.get(oldPathname, new String[0])));
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (needed.contains(cl)) continue;
            if (cl.getFileAsPath().equals(Paths.get(movie.getDataSource(), new String[0])) || cl.getFileAsPath().equals(movie.getPathNIO()) || cl.getFileAsPath().equals(Paths.get(oldPathname, new String[0]))) {
                LOGGER.warn("Wohoo! We tried to remove complete datasource / movie folder. Nooo way...! {}: {}", (Object)cl.getType(), (Object)cl.getFileAsPath());
                continue;
            }
            movie.removeFromMediaFiles(cl);
            if (var14_39.contains(cl.getFileAsPath())) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), movie.getDataSource());
                if (cl.isGraphic()) {
                    ImageCache.invalidateCachedImage(cl);
                }
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e3) {
                LOGGER.warn("could not search for empty dir: {}", (Object)e3.getMessage());
            }
        }
        MovieRenamer.cleanupUnwantedFiles(movie);
        MovieRenamer.removeEmptySubfolders(movie);
        fileNameHistory.setOldPath(oldPathname);
        fileNameHistory.setNewPath(newPathname);
        movie.setRenameHistory(fileNameHistory);
        movie.saveToDb();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void undoRename(Movie movie) {
        boolean ok;
        MediaFile oldMF;
        MediaEntityFilenameHistory.FilenameHistory filenameHistory;
        if (movie.getRenameHistory() == null) {
            LOGGER.debug("could not undo rename - no history available");
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        Path oldMoviePath = Paths.get(movie.getRenameHistory().getOldPath(), new String[0]);
        Path newMoviePath = Paths.get(movie.getRenameHistory().getNewPath(), new String[0]);
        for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
            filenameHistory = MovieRenamer.findFilenameHistoryForMediaFile(movie, mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename - VIDEO file history not found");
                return;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            oldMF = new MediaFile(mediaFile);
            oldMF.replacePathForRenamedFolder(newMoviePath, oldMoviePath);
            oldMF.setFile(oldMoviePath.resolve(filenameHistory.oldFilename()));
            if (movie.isDisc() && Files.isDirectory(mediaFile.getFile(), new LinkOption[0])) {
                ok = MovieRenamer.moveDirectory(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
                if (!ok) {
                    LOGGER.error("could not move video file of movie '{}' - abort renaming", (Object)movie.getTitle());
                    return;
                }
                mediaFile.setFile(oldMF.getFileAsPath());
            } else {
                ok = MovieRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath());
                if (!ok) {
                    LOGGER.error("could not move video file of movie '{}' - abort renaming", (Object)movie.getTitle());
                    return;
                }
                mediaFile.setFile(oldMF.getFileAsPath());
            }
            needed.add(mediaFile);
        }
        for (MediaFile mediaFile : movie.getMediaFilesExceptType(MediaFileType.VIDEO)) {
            filenameHistory = MovieRenamer.findFilenameHistoryForMediaFile(movie, mediaFile);
            if (filenameHistory == null) {
                LOGGER.debug("could not undo rename for '{}' - history not found", (Object)mediaFile.getFilename());
                continue;
            }
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            oldMF = new MediaFile(mediaFile);
            oldMF.replacePathForRenamedFolder(newMoviePath, oldMoviePath);
            oldMF.setFile(oldMoviePath.resolve(filenameHistory.oldFilename()));
            if (movie.isDisc() && !Files.exists(mediaFile.getFileAsPath(), new LinkOption[0])) {
                Path newPath = movie.getMainVideoFile().getFileAsPath().resolve(mediaFile.getFilename());
                mediaFile.setFile(newPath);
            }
            if (ok = MovieRenamer.moveFile(mediaFile.getFileAsPath(), oldMF.getFileAsPath())) {
                mediaFile.setFile(oldMF.getFileAsPath());
                needed.add(mediaFile);
                continue;
            }
            Utils.deleteFileWithBackup(mediaFile.getFileAsPath(), movie.getDataSource());
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        movie.removeAllMediaFiles();
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : needed) {
                ImageCache.cacheImageSilently(gfx, false);
            }
        }
        ThreadUtils.sleep(250L);
        movie.addToMediaFiles(needed);
        movie.setPath(movie.getRenameHistory().getOldPath());
        movie.gatherMediaFileInformation(false);
        movie.setRenameHistory(null);
        movie.saveToDb();
        try {
            Utils.deleteEmptyDirectoryRecursive(newMoviePath);
            return;
        }
        catch (IOException iOException) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)iOException.getMessage());
        }
    }

    private static MediaEntityFilenameHistory.FilenameHistory createFilenameHistory(String newMoviePath, Path oldFilePath, Path newFilePath) {
        String oldFilename = Paths.get(newMoviePath, new String[0]).relativize(oldFilePath).toString();
        String newFilename = Paths.get(newMoviePath, new String[0]).relativize(newFilePath).toString();
        return new MediaEntityFilenameHistory.FilenameHistory(oldFilename, newFilename);
    }

    private static MediaEntityFilenameHistory.FilenameHistory findFilenameHistoryForMediaFile(Movie movie, MediaFile mediaFile) {
        if (movie.getRenameHistory() == null) {
            return null;
        }
        Path moviePath = movie.getPathNIO();
        for (MediaEntityFilenameHistory.FilenameHistory filenameHistory : movie.getRenameHistory().getFilenameHistory()) {
            if (!filenameHistory.newFilename().equals(moviePath.relativize(mediaFile.getFileAsPath()).toString())) continue;
            return filenameHistory;
        }
        return null;
    }

    private static boolean renameMovieFolder(Movie movie, String newPathname) {
        Path srcDir = movie.getPathNIO();
        Path destDir = Paths.get(newPathname, new String[0]);
        if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
            boolean newDestIsMultiMovieDir = false;
            if (!MovieRenamer.isFolderPatternUnique(MovieModuleManager.getInstance().getSettings().getRenamerPathname())) {
                newDestIsMultiMovieDir = true;
            } else {
                try {
                    if (Files.exists(destDir, new LinkOption[0]) && !Utils.isFolderEmpty(destDir) && MovieModuleManager.getInstance().getSettings().isAllowMultipleMoviesInSameDir()) {
                        newDestIsMultiMovieDir = true;
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.INFO, (Object)srcDir, "message.renamer.mergetommd", new String[]{movie.getTitle()}));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("could not check if dir '{}' exists/is empty - '{}'", (Object)destDir, (Object)e.getMessage());
                }
            }
            LOGGER.debug("movie willBeMulti?: {}", (Object)newDestIsMultiMovieDir);
            if (!movie.isMultiMovieDir() && !newDestIsMultiMovieDir) {
                boolean ok;
                try {
                    ok = Utils.moveDirectorySafe(srcDir, destDir);
                    if (ok) {
                        movie.setMultiMovieDir(false);
                        movie.updateMediaFilePath(srcDir, destDir);
                        movie.setPath(newPathname);
                        movie.saveToDb();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error moving folder: ", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                    return false;
                }
                if (!ok) {
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{movie.getTitle()}));
                    LOGGER.error("Could not move to destination '{}' - NOT renaming folder", (Object)destDir);
                    return false;
                }
            } else if (movie.isMultiMovieDir() && !newDestIsMultiMovieDir) {
                LOGGER.trace("Upgrading movie into it's own dir :) - {}", (Object)newPathname);
                if (!Files.exists(destDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(destDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not create destination '{}' - NOT renaming folder ('upgrade' movie) - {}", (Object)destDir, (Object)e.getMessage());
                        return false;
                    }
                } else {
                    LOGGER.error("Directory already exists! '{}' - NOT renaming folder ('upgrade' movie)", (Object)destDir);
                    return false;
                }
                movie.setMultiMovieDir(false);
            } else {
                LOGGER.trace("New movie path is a MMD :( - {}", (Object)newPathname);
                if (!Files.exists(destDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(destDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not create destination '{}' - NOT renaming folder ('MMD' movie) - {}", (Object)destDir, (Object)e.getMessage());
                        return false;
                    }
                }
                movie.setMultiMovieDir(true);
            }
        }
        return true;
    }

    public static List<MediaFile> generateFilename(Movie movie, MediaFile mf, String newVideoFileName) {
        return MovieRenamer.generateFilename(movie, mf, newVideoFileName, "");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static List<MediaFile> generateFilename(Movie movie, MediaFile mf, String newVideoFileName, String oldVideoFileName) {
        newFiles = new ArrayList<MediaFile>();
        newDestIsMultiMovieDir = movie.isMultiMovieDir();
        newPathname = "";
        pattern = MovieModuleManager.getInstance().getSettings().getRenamerPathname();
        if (!pattern.isEmpty()) {
            newDestIsMultiMovieDir = MovieRenamer.isFolderPatternUnique(pattern) == false;
            newPathname = MovieRenamer.createDestinationForFoldername(pattern, movie);
        } else {
            newPathname = Utils.relPath(Paths.get(movie.getDataSource(), new String[0]), movie.getPathNIO());
        }
        newMovieDir = movie.getPathNIO();
        try {
            newMovieDir = Paths.get(movie.getDataSource(), new String[]{newPathname});
        }
        catch (Exception e) {
            MovieRenamer.LOGGER.warn("new movie folder name is illegal - '{}'", (Object)e.getMessage());
        }
        newFilename = newVideoFileName;
        if (newFilename == null || newFilename.isEmpty()) {
            newFilename = MovieRenamer.createDestinationForFilename(MovieModuleManager.getInstance().getSettings().getRenamerFilename(), movie);
        }
        if (newFilename.endsWith(mf.getExtension())) {
            newFilename = FilenameUtils.getBaseName((String)newFilename);
        }
        if (newFilename.isEmpty()) {
            newFiles.add(mf);
            return newFiles;
        }
        defaultMF = new MediaFile(mf);
        defaultMF.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
        relativePathOfMediafile = movie.getPathNIO().relativize(mf.getFileAsPath());
        if (!MovieRenamer.isFilePatternValid() && !movie.isDisc()) {
            newFiles.add(defaultMF);
            return newFiles;
        }
        switch (3.$SwitchMap$org$tinymediamanager$core$MediaFileType[mf.getType().ordinal()]) {
            case 1: {
                vid = new MediaFile(mf);
                if (movie.isDisc() || mf.isDiscFile()) {
                    vid.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                } else {
                    newFilename = (String)newFilename + MovieRenamer.getStackingString(mf);
                    newFilename = (String)newFilename + "." + mf.getExtension();
                    vid.setFile(newMovieDir.resolve((String)newFilename));
                }
                newFiles.add(vid);
                break;
            }
            case 2: {
                if (relativePathOfMediafile.getNameCount() > 1 && MediaFileHelper.TRAILER_FOLDERS.contains(relativePathOfMediafile.subpath(0, 1).toString().toLowerCase(Locale.ROOT))) {
                    newFiles.add(defaultMF);
                    break;
                }
                trailernames = new ArrayList<MovieTrailerNaming>();
                if (newDestIsMultiMovieDir) {
                    trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
                } else if (movie.isDisc()) {
                    trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
                } else {
                    trailernames.addAll(MovieModuleManager.getInstance().getSettings().getTrailerFilenames());
                    if (trailernames.isEmpty()) {
                        trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
                    }
                }
                stackingMarker = "";
                matcher = MovieRenamer.TRAILER_STACKING_PATTERN.matcher(mf.getBasename());
                if (matcher.matches()) {
                    stackingMarker = matcher.group(1);
                }
                newFilename = (String)newFilename + ".avi";
                if (movie.isDisc() && MovieModuleManager.getInstance().getSettings().isTrailerDiscFolderInside()) {
                    main = movie.getMainFile();
                    if (MediaFileHelper.isDiscFolder(main.getFilename())) {
                        mainFile = main.getFileAsPath();
                        rel = movie.getPathNIO().relativize(mainFile);
                        outputFolder = newMovieDir.resolve(rel);
                    } else {
                        outputFolder = newMovieDir;
                    }
                    newFilename = movie.findDiscMainFile();
                } else {
                    outputFolder = newMovieDir;
                }
                for (MovieTrailerNaming name : trailernames) {
                    newTrailerName = movie.getTrailerFilename(name, (String)newFilename);
                    if (newTrailerName.isEmpty()) continue;
                    trail = new MediaFile(mf);
                    if (StringUtils.isNotBlank((CharSequence)stackingMarker)) {
                        trail.setFile(outputFolder.resolve(newTrailerName + "." + stackingMarker + "." + mf.getExtension()));
                    } else {
                        trail.setFile(outputFolder.resolve(newTrailerName + "." + mf.getExtension()));
                    }
                    newFiles.add(trail);
                }
                break;
            }
            case 3: 
            case 4: {
                extra = new MediaFile(mf);
                if (MediaFileHelper.isExtraInDedicatedFolder(mf, movie)) {
                    newFiles.add(defaultMF);
                    break;
                }
                extraTitle = mf.getBasename().replace(oldVideoFileName, "");
                extra.setFile(newMovieDir.resolve((String)newFilename + extraTitle + "." + mf.getExtension()));
                newFiles.add(extra);
                break;
            }
            case 5: {
                sample = new MediaFile(mf);
                newFilename = (String)newFilename + "-sample." + mf.getExtension();
                sample.setFile(newMovieDir.resolve((String)newFilename));
                newFiles.add(sample);
                break;
            }
            case 6: {
                mi = new MediaFile(mf);
                if (movie.isDisc()) {
                    mi.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                    newFiles.add(mi);
                    break;
                }
                newFilename = (String)newFilename + MovieRenamer.getStackingString(mf);
                newFilename = (String)newFilename + "-mediainfo." + mf.getExtension();
                mi.setFile(newMovieDir.resolve((String)newFilename));
                newFiles.add(mi);
                break;
            }
            case 7: 
            case 8: {
                doubleExt = new MediaFile(mf);
                if (movie.isDisc()) {
                    doubleExt.setFile(newMovieDir.resolve(doubleExt.getFilename()));
                } else {
                    newFilename = (String)newFilename + MovieRenamer.getStackingString(mf);
                    videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                    newFilename = (String)newFilename + "." + videoExt + "." + FilenameUtils.getExtension((String)mf.getFilename());
                    doubleExt.setFile(newMovieDir.resolve((String)newFilename));
                }
                newFiles.add(doubleExt);
                break;
            }
            case 9: {
                subtitles = mf.getSubtitles();
                subtitleFilename = newFilename = (String)newFilename + MovieRenamer.getStackingString(mf);
                if (subtitles != null && !subtitles.isEmpty() && (sub = mf.getSubtitles().get(0)) != null) {
                    if (!sub.getLanguage().isEmpty()) {
                        lang = LanguageStyle.getLanguageCodeForStyle(sub.getLanguage(), MovieModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = sub.getLanguage();
                        }
                        subtitleFilename = (String)subtitleFilename + "." + lang;
                    }
                    if (sub.isForced()) {
                        subtitleFilename = (String)subtitleFilename + ".forced";
                    }
                    if (sub.isSdh()) {
                        subtitleFilename = (String)subtitleFilename + ".sdh";
                    }
                    if (StringUtils.isNotBlank((CharSequence)sub.getTitle())) {
                        subtitleFilename = (String)subtitleFilename + "." + sub.getTitle().strip();
                    }
                }
                if (StringUtils.isBlank((CharSequence)subtitleFilename)) {
                    subtitleFilename = newFilename;
                }
                if (!StringUtils.isNotBlank((CharSequence)subtitleFilename)) break;
                subtitle = new MediaFile(mf);
                subtitle.setFile(newMovieDir.resolve((String)subtitleFilename + "." + mf.getExtension()));
                newFiles.add(subtitle);
                break;
            }
            case 10: {
                if (MovieModuleManager.getInstance().getSettings().getNfoFilenames().isEmpty()) break;
                if (MovieConnectors.isValidNFO(mf.getFileAsPath())) {
                    nfonames /* !! */  = new ArrayList<MovieNfoNaming>();
                    if (newDestIsMultiMovieDir) {
                        nfonames /* !! */ .add(MovieNfoNaming.FILENAME_NFO);
                    } else if (movie.isDisc()) {
                        nfonames /* !! */ .add(MovieNfoNaming.FILENAME_NFO);
                    } else {
                        nfonames /* !! */  = MovieModuleManager.getInstance().getSettings().getNfoFilenames();
                    }
                    for (MovieNfoNaming name : nfonames /* !! */ ) {
                        newNfoName = movie.getNfoFilename(name, (String)newFilename + ".avi");
                        if (newNfoName.isEmpty()) continue;
                        nfo = new MediaFile(mf);
                        nfo.setFile(newMovieDir.resolve(newNfoName));
                        newFiles.add(nfo);
                    }
                    break;
                }
                if (MovieModuleManager.getInstance().getSettings().isRenamerNfoCleanup()) break;
                newFiles.add(new MediaFile(mf));
                break;
            }
            case 11: {
                for (MoviePosterNaming name : MovieArtworkHelper.getPosterNamesForMovie(movie)) {
                    newPosterName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newPosterName)) continue;
                    pos = new MediaFile(mf);
                    pos.setFile(newMovieDir.resolve(newPosterName));
                    newFiles.add(pos);
                }
                break;
            }
            case 12: {
                for (MovieFanartNaming name : MovieArtworkHelper.getFanartNamesForMovie(movie)) {
                    newFanartName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newFanartName)) continue;
                    fan = new MediaFile(mf);
                    fan.setFile(newMovieDir.resolve(newFanartName));
                    newFiles.add(fan);
                }
                break;
            }
            case 13: {
                for (MovieBannerNaming name : MovieArtworkHelper.getBannerNamesForMovie(movie)) {
                    newBannerName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newBannerName)) continue;
                    banner = new MediaFile(mf);
                    banner.setFile(newMovieDir.resolve(newBannerName));
                    newFiles.add(banner);
                }
                break;
            }
            case 14: {
                for (MovieClearartNaming name : MovieArtworkHelper.getClearartNamesForMovie(movie)) {
                    newClearartName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newClearartName)) continue;
                    clearart = new MediaFile(mf);
                    clearart.setFile(newMovieDir.resolve(newClearartName));
                    newFiles.add(clearart);
                }
                break;
            }
            case 15: {
                for (MovieDiscartNaming name : MovieArtworkHelper.getDiscartNamesForMovie(movie)) {
                    newDiscartName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newDiscartName)) continue;
                    discart = new MediaFile(mf);
                    discart.setFile(newMovieDir.resolve(newDiscartName));
                    newFiles.add(discart);
                }
                break;
            }
            case 16: 
            case 17: {
                for (MovieClearlogoNaming name : MovieArtworkHelper.getClearlogoNamesForMovie(movie)) {
                    newClearlogoName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newClearlogoName)) continue;
                    clearlogo = new MediaFile(mf);
                    clearlogo.setFile(newMovieDir.resolve(newClearlogoName));
                    newFiles.add(clearlogo);
                }
                break;
            }
            case 18: {
                for (MovieThumbNaming name : MovieArtworkHelper.getThumbNamesForMovie(movie)) {
                    newThumbName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newThumbName)) continue;
                    thumb = new MediaFile(mf);
                    thumb.setFile(newMovieDir.resolve(newThumbName));
                    newFiles.add(thumb);
                }
                break;
            }
            case 19: {
                for (MovieKeyartNaming name : MovieArtworkHelper.getKeyartNamesForMovie(movie)) {
                    newKeyartName = name.getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf));
                    if (!StringUtils.isNotBlank((CharSequence)newKeyartName)) continue;
                    key = new MediaFile(mf);
                    key.setFile(newMovieDir.resolve(newKeyartName));
                    newFiles.add(key);
                }
                break;
            }
            case 20: {
                index = MovieArtworkHelper.getIndexOfArtwork(mf.getFilename());
                if (index <= 0 || (extraFanartNamings = MovieArtworkHelper.getExtraFanartNamesForMovie(movie)).isEmpty() || !StringUtils.isNotBlank((CharSequence)(newExtraFanartFilename = (fileNaming = extraFanartNamings.get(0)).getFilename((String)newFilename, MovieRenamer.getArtworkExtension(mf))))) break;
                basename = FilenameUtils.getBaseName((String)newExtraFanartFilename);
                newExtraFanartFilename = basename + index + "." + MovieRenamer.getArtworkExtension(mf);
                if (fileNaming != MovieExtraFanartNaming.FOLDER_EXTRAFANART) ** GOTO lbl279
                folder = newMovieDir.resolve("extrafanart");
                try {
                    if (!Files.exists(folder, new LinkOption[0])) {
                        Files.createDirectory(folder, new FileAttribute[0]);
                    }
                    ** GOTO lbl280
                }
                catch (IOException e) {
                    MovieRenamer.LOGGER.error("could not create extrafanarts folder: {}", (Object)e.getMessage());
                }
                ** GOTO lbl280
lbl279:
                // 1 sources

                folder = newMovieDir;
lbl280:
                // 4 sources

                extrafanart = new MediaFile(mf);
                extrafanart.setFile(folder.resolve((String)newExtraFanartFilename));
                newFiles.add(extrafanart);
                break;
            }
            case 21: {
                newFiles.add(defaultMF);
                break;
            }
            default: {
                newFiles.add(defaultMF);
            }
        }
        return newFiles;
    }

    private static String getArtworkExtension(MediaFile mf) {
        String ext = mf.getExtension().replace("jpeg", "jpg");
        if (ext.equalsIgnoreCase("tbn")) {
            String cont = mf.getContainerFormat();
            if (cont.equalsIgnoreCase("PNG")) {
                ext = "png";
            } else if (cont.equalsIgnoreCase("JPEG")) {
                ext = "jpg";
            }
        }
        return ext;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = " ";
        if (MovieModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution()) {
            delimiter = MovieModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String createDestinationForFilename(String template, Movie movie) {
        return MovieRenamer.createDestination(template, movie, true);
    }

    public static String createDestinationForFoldername(String template, Movie movie) {
        return MovieRenamer.createDestination(template, movie, false);
    }

    public static String getTokenValue(Movie movie, String token) {
        try {
            Engine engine = MovieRenamer.createEngine();
            engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
            engine.setOutputAppender((OutputAppender)new TmmOutputAppender(){

                @Override
                protected String replaceInvalidCharacters(String text) {
                    return MovieRenamer.replaceInvalidCharacters(text);
                }
            });
            HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
            root.put("movie", movie);
            if (movie.getMovieSet() != null && (movie.getMovieSet().getMovies().size() > 1 || MovieModuleManager.getInstance().getSettings().isRenamerCreateMoviesetForSingleMovie())) {
                root.put("movieSet", movie.getMovieSet());
            }
            return engine.transform(JmteUtils.morphTemplate(token, TOKEN_MAP), root);
        }
        catch (Exception e) {
            LOGGER.warn("unable to process token: {} - {}", (Object)token, (Object)e.getMessage());
            return token;
        }
    }

    public static Engine createEngine() {
        Engine engine = Engine.createEngine();
        engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
        engine.registerRenderer(Path.class, (Renderer)new PathRenderer());
        engine.registerNamedRenderer((NamedRenderer)new MovieNamedFirstCharacterRenderer());
        engine.registerNamedRenderer((NamedRenderer)new MovieNamedIndexOfMovieSetRenderer());
        engine.registerNamedRenderer((NamedRenderer)new MovieNamedIndexOfMovieSetWithDummyRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayUniqueRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFramerateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedSplitRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new ChainedNamedRenderer(engine.getAllNamedRenderers()));
        engine.registerAnnotationProcessor((AnnotationProcessor)new RegexpProcessor());
        engine.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(ErrorMessage errorMessage, Token token, Map<String, Object> parameters) throws ParseException {
                throw new ParseException((com.floreysoft.jmte.message.Message)new ResourceBundleMessage(errorMessage.key).withModel(parameters).onToken(token));
            }
        });
        return engine;
    }

    public static String createDestination(String template, Movie movie, boolean forFilename) {
        String newDestination = MovieRenamer.getTokenValue(movie, template);
        newDestination = newDestination.replaceAll("\\([ ]?\\)", "");
        newDestination = newDestination.replaceAll("\\[[ ]?\\]", "");
        newDestination = newDestination.replaceAll("\\{[ ]?\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+\\\\", "\\\\");
                newDestination = newDestination.replaceAll("\\\\\\s+", "\\\\");
                newDestination = newDestination.replaceAll("[ \\.\\-_]+\\\\", "\\\\");
            }
            newDestination = newDestination.replaceAll("\\\\{2,}", "\\\\");
            newDestination = newDestination.replaceAll("^\\\\", "");
        } else {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+/", "/");
                newDestination = newDestination.replaceAll("/\\s+", "/");
                newDestination = newDestination.replaceAll("[ \\.\\-_]+/", "/");
            }
            newDestination = newDestination.replaceAll("/{2,}", "/");
            newDestination = newDestination.replaceAll("^/", "");
        }
        if (forFilename) {
            newDestination = MovieRenamer.replacePathSeparators(newDestination);
        }
        if (forFilename && MovieModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution()) {
            String replacement = MovieModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
            newDestination = newDestination.replace(" ", replacement);
            newDestination = newDestination.replaceAll(Pattern.quote(replacement) + "+", replacement);
        } else if (!forFilename && MovieModuleManager.getInstance().getSettings().isRenamerPathnameSpaceSubstitution()) {
            String replacement = MovieModuleManager.getInstance().getSettings().getRenamerPathnameSpaceReplacement();
            newDestination = newDestination.replace(" ", replacement);
            newDestination = newDestination.replaceAll(Pattern.quote(replacement) + "+", replacement);
        }
        newDestination = newDestination.replaceAll("^[ \\.\\-]+", "");
        newDestination = newDestination.replaceAll("[ \\.\\-_]+$", "");
        if (MovieModuleManager.getInstance().getSettings().isAsciiReplacement()) {
            newDestination = StrgUtils.convertToAscii(newDestination, false);
        }
        newDestination = newDestination.replace(": ", " - ");
        newDestination = newDestination.replace(":", "-");
        newDestination = newDestination.replaceAll("\r?\n", " ");
        newDestination = newDestination.replaceAll(" +", " ");
        if (SystemUtils.IS_OS_WINDOWS) {
            newDestination = newDestination.replace("\"", " ");
        }
        return newDestination.strip();
    }

    static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move MF '{}' to '{}'", (Object)oldFilename, (Object)newFilename);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving file '{}' - '{}'", (Object)oldFilename.toAbsolutePath(), (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    static boolean moveDirectory(Path oldName, Path newName) {
        try {
            boolean ok;
            if (!Files.exists(newName.getParent(), new LinkOption[0])) {
                Files.createDirectory(newName.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveDirectorySafe(oldName, newName)) {
                return true;
            }
            LOGGER.error("Could not move folder '{}' to '{}'", (Object)oldName, (Object)newName);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving folder '{}' - '{}'", (Object)oldName.toAbsolutePath(), (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldName, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.debug("copy file {} to {}", (Object)oldFilename, (Object)newFilename);
            if (oldFilename.equals(newFilename)) {
                return MovieRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFolderPatternUnique(String pattern) {
        return TITLE_PATTERN.matcher(pattern).find() && YEAR_ID_PATTERN.matcher(pattern).find();
    }

    public static boolean isFilePatternValid() {
        return MovieRenamer.isFilePatternValid(MovieModuleManager.getInstance().getSettings().getRenamerFilename());
    }

    public static boolean isFilePatternValid(String pattern) {
        return TITLE_PATTERN.matcher(pattern).find() || ORIGINAL_FILENAME_PATTERN.matcher(pattern).find();
    }

    public static String replaceInvalidCharacters(String source) {
        String result = source;
        if ("-".equals(MovieModuleManager.getInstance().getSettings().getRenamerColonReplacement())) {
            result = result.replace(": ", " - ");
            result = result.replace(":", "-");
        } else {
            result = result.replace(":", MovieModuleManager.getInstance().getSettings().getRenamerColonReplacement());
        }
        return result.replaceAll("([\":<>|?*])", "");
    }

    public static String replacePathSeparators(String source) {
        String result = source.replaceAll("\\/", " ");
        return result.replaceAll("\\\\", " ");
    }
}

