/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.IMovieConnector;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MovieGenericXmlConnector
implements IMovieConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieGenericXmlConnector.class);
    protected static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    protected static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    protected final Movie movie;
    protected final MovieSettings settings;
    protected MovieNfoParser parser = null;
    protected Document document;
    protected Element root;

    protected MovieGenericXmlConnector(Movie movie) {
        this.movie = movie;
        this.settings = MovieModuleManager.getInstance().getSettings();
    }

    protected abstract void addOwnTags();

    @Override
    public void write(List<MovieNfoNaming> nfoNames) {
        if (!this.settings.isWriteCleanNfo()) {
            for (MediaFile mediaFile : this.movie.getMediaFiles(MediaFileType.NFO)) {
                try {
                    this.parser = MovieNfoParser.parseNfo(mediaFile.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieNfoNaming nfoNaming : nfoNames) {
            String nfoFilename = this.movie.getNfoFilename(nfoNaming);
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
                this.document.setXmlStandalone(true);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                MovieConnectors conn = this.settings.getMovieConnector();
                this.document.appendChild(this.document.createComment("created on " + dat + " by tinyMediaManager " + Settings.getInstance().getVersion() + " for " + conn.name()));
                this.root = this.document.createElement("movie");
                this.document.appendChild(this.root);
                this.addTitle();
                this.addOriginaltitle();
                this.addSorttitle();
                this.addYear();
                this.addRating();
                this.addUserrating();
                this.addVotes();
                this.addSet();
                this.addPlot();
                this.addOutline();
                this.addTagline();
                this.addRuntime();
                this.addThumb();
                this.addFanart();
                this.addMpaa();
                this.addCertification();
                this.addId();
                this.addTmdbid();
                this.addIds();
                this.addCountry();
                this.addPremiered();
                this.addWatched();
                this.addPlaycount();
                this.addLastPlayed();
                this.addGenres();
                this.addStudios();
                this.addCredits();
                this.addDirectors();
                this.addTags();
                this.addActors();
                this.addProducers();
                this.addTrailer();
                this.addLanguages();
                this.addShowlink();
                this.addDateAdded();
                this.addLockdata();
                this.addFileinfo();
                this.addOwnTags();
                this.addUnsupportedTags();
                this.addTinyMediaManagerTags();
                StringWriter out = new StringWriter();
                this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
                String xml = ((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n");
                Path f = this.movie.getPathNIO().resolve(nfoFilename);
                boolean changed = true;
                try {
                    String xmlOld = Utils.readFileToString(f).replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    String xmlNew = xml.replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    if (xmlOld.equals(xmlNew)) {
                        changed = false;
                    }
                }
                catch (Exception xmlOld) {
                    // empty catch block
                }
                if (changed) {
                    Utils.writeStringToFile(f, xml);
                } else {
                    LOGGER.trace("NFO {} did not change - do not write it!", (Object)f);
                }
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("write '" + this.movie.getPathNIO().resolve(nfoFilename) + "'", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            List<MediaFile> list = this.movie.getMediaFiles(MediaFileType.NFO);
            for (MediaFile nfo : list) {
                if (!MovieConnectors.isValidNFO(nfo.getFileAsPath())) {
                    newNfos.add(nfo);
                    continue;
                }
                if (newNfos.contains(nfo)) continue;
                try {
                    Utils.deleteFileWithBackup(nfo.getFileAsPath(), this.movie.getDataSource());
                }
                catch (Exception e) {
                    LOGGER.debug("Could not remove orphaned NFO - '{}'", (Object)e.getMessage());
                }
            }
            this.movie.removeAllMediaFiles(MediaFileType.NFO);
            this.movie.addToMediaFiles(newNfos);
        }
    }

    protected void addTitle() {
        Element title = this.document.createElement("title");
        title.setTextContent(this.movie.getTitle());
        this.root.appendChild(title);
    }

    protected void addOriginaltitle() {
        Element originaltitle = this.document.createElement("originaltitle");
        originaltitle.setTextContent(this.movie.getOriginalTitle());
        this.root.appendChild(originaltitle);
    }

    protected void addSorttitle() {
        Element sorttitle = this.document.createElement("sorttitle");
        sorttitle.setTextContent(this.movie.getSortTitle());
        this.root.appendChild(sorttitle);
    }

    protected void addYear() {
        Element year = this.document.createElement("year");
        year.setTextContent(this.movie.getYear() == 0 ? "" : Integer.toString(this.movie.getYear()));
        this.root.appendChild(year);
    }

    protected void addRating() {
        String ratingSource;
        Map<String, MediaRating> ratings = this.movie.getRatings();
        MediaRating mainMediaRating = null;
        Iterator<Object> iterator = this.settings.getRatingSources().iterator();
        while (iterator.hasNext() && (mainMediaRating = ratings.get(ratingSource = iterator.next())) == null) {
        }
        if (mainMediaRating == null) {
            for (MediaRating r : ratings.values()) {
                if ("user".equals(r.getId())) continue;
                mainMediaRating = r;
            }
        }
        if (mainMediaRating == null) {
            mainMediaRating = MediaMetadata.EMPTY_RATING;
        }
        Float rating10 = mainMediaRating.getMaxValue() > 0 ? Float.valueOf(mainMediaRating.getRating() * 10.0f / (float)mainMediaRating.getMaxValue()) : Float.valueOf(mainMediaRating.getRating());
        Element rating = this.document.createElement("rating");
        rating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(rating);
    }

    protected void addUserrating() {
        MediaRating mediaRating = this.movie.getRating("user");
        float rating10 = mediaRating.getMaxValue() > 0 ? mediaRating.getRating() * 10.0f / (float)mediaRating.getMaxValue() : mediaRating.getRating();
        Element UserRating = this.document.createElement("userrating");
        DecimalFormat df = new DecimalFormat("#.#", DECIMAL_FORMAT_SYMBOLS);
        UserRating.setTextContent(df.format(rating10));
        this.root.appendChild(UserRating);
    }

    protected void addVotes() {
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(this.movie.getRating().getVotes()));
        this.root.appendChild(votes);
    }

    protected void addSet() {
        Element set = this.document.createElement("set");
        set.setTextContent(this.movie.getMovieSetTitle());
        this.root.appendChild(set);
    }

    protected void addPlot() {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(this.movie.getPlot());
        this.root.appendChild(plot);
    }

    protected void addOutline() {
        String outlineText = "";
        if (this.settings.isCreateOutline()) {
            if (this.settings.isOutlineFirstSentence()) {
                String[] sentences;
                StringBuilder text = new StringBuilder();
                for (String sentence : sentences = this.movie.getPlot().split("\\.")) {
                    if (text.length() > 0) {
                        text.append(".");
                    }
                    text.append(sentence);
                    if (text.length() >= 20) break;
                }
                outlineText = text.toString();
            } else {
                outlineText = this.movie.getPlot();
            }
        } else if (this.parser != null && StringUtils.isNotBlank((CharSequence)this.parser.outline)) {
            outlineText = this.parser.outline;
        }
        if (StringUtils.isNotBlank((CharSequence)outlineText)) {
            Element outline = this.document.createElement("outline");
            outline.setTextContent(outlineText);
            this.root.appendChild(outline);
        }
    }

    protected void addTagline() {
        Element tagline = this.document.createElement("tagline");
        tagline.setTextContent(this.movie.getTagline());
        this.root.appendChild(tagline);
    }

    protected void addRuntime() {
        Element runtime = this.document.createElement("runtime");
        runtime.setTextContent(Integer.toString(this.movie.getRuntime()));
        this.root.appendChild(runtime);
    }

    protected void addThumb() {
        Element thumb = this.document.createElement("thumb");
        thumb.setTextContent(this.movie.getArtworkUrl(MediaFileType.POSTER));
        this.root.appendChild(thumb);
    }

    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        fanart.setTextContent(this.movie.getArtworkUrl(MediaFileType.FANART));
        this.root.appendChild(fanart);
    }

    protected void addMpaa() {
        Element mpaa = this.document.createElement("mpaa");
        if (this.movie.getCertification() != null) {
            mpaa.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), this.settings.getCertificationStyle()));
        }
        this.root.appendChild(mpaa);
    }

    protected void addCertification() {
        Element certification = this.document.createElement("certification");
        if (this.movie.getCertification() != null) {
            certification.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), this.settings.getCertificationStyle()));
        }
        this.root.appendChild(certification);
    }

    protected void addId() {
        Element id = this.document.createElement("id");
        id.setTextContent(this.movie.getImdbId());
        this.root.appendChild(id);
    }

    protected void addTmdbid() {
        Element tmdbid = this.document.createElement("tmdbid");
        if (this.movie.getTmdbId() > 0) {
            tmdbid.setTextContent(Integer.toString(this.movie.getTmdbId()));
        }
        this.root.appendChild(tmdbid);
    }

    protected void addIds() {
        String defaultScraper = this.detectDefaultScraper();
        for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            uniqueid.setAttribute("type", entry.getKey());
            if (defaultScraper.equals(entry.getKey())) {
                uniqueid.setAttribute("default", "true");
            } else {
                uniqueid.setAttribute("default", "false");
            }
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addCountry() {
        List<String> countries = ParserUtils.split(this.movie.getCountry());
        for (String c : countries) {
            Element country = this.document.createElement("country");
            country.setTextContent(c);
            this.root.appendChild(country);
        }
    }

    protected void addPremiered() {
        Element premiered = this.document.createElement("premiered");
        if (this.movie.getReleaseDate() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(this.movie.getReleaseDate()));
        }
        this.root.appendChild(premiered);
    }

    protected void addDateAdded() {
        if (!this.settings.isNfoWriteDateAdded()) {
            return;
        }
        Element dateadded = this.document.createElement("dateadded");
        switch (this.settings.getNfoDateAddedField()) {
            case DATE_ADDED: {
                if (this.movie.getDateAdded() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movie.getDateAdded()));
                break;
            }
            case FILE_CREATION_DATE: {
                MediaFile mainMediaFile = this.movie.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateCreated() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateCreated()));
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                MediaFile mainMediaFile = this.movie.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateLastModified() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateLastModified()));
                break;
            }
            case RELEASE_DATE: {
                if (this.movie.getReleaseDate() != null) {
                    dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movie.getReleaseDate()));
                    break;
                }
                if (this.movie.getDateAdded() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movie.getDateAdded()));
            }
        }
        this.root.appendChild(dateadded);
    }

    protected void addLockdata() {
        if (this.settings.isNfoWriteLockdata()) {
            Element lockdata = this.document.createElement("lockdata");
            lockdata.setTextContent("true");
            this.root.appendChild(lockdata);
        }
    }

    protected void addFileinfo() {
        if (this.settings.isNfoWriteFileinfo()) {
            Element fileinfo = this.document.createElement("fileinfo");
            Element streamdetails = this.document.createElement("streamdetails");
            MediaFile vid = this.movie.getMainVideoFile();
            if (vid != null) {
                Element video = this.document.createElement("video");
                Element codec = this.document.createElement("codec");
                if ("h265".equalsIgnoreCase(vid.getVideoCodec())) {
                    codec.setTextContent("HEVC");
                } else {
                    codec.setTextContent(vid.getVideoCodec());
                }
                video.appendChild(codec);
                Element aspect = this.document.createElement("aspect");
                aspect.setTextContent(Float.toString(vid.getAspectRatio().floatValue()));
                video.appendChild(aspect);
                Element width = this.document.createElement("width");
                width.setTextContent(Integer.toString(vid.getVideoWidth()));
                video.appendChild(width);
                Element height = this.document.createElement("height");
                height.setTextContent(Integer.toString(vid.getVideoHeight()));
                video.appendChild(height);
                if (this.movie.isVideoInHDR().booleanValue()) {
                    Element hdr = this.document.createElement("hdrtype");
                    if (vid.getHdrFormat().contains("Dolby Vision")) {
                        hdr.setTextContent("dolbyvision");
                    } else if (vid.getHdrFormat().contains("HLG")) {
                        hdr.setTextContent("hlg");
                    } else if (vid.getHdrFormat().contains("HDR10")) {
                        hdr.setTextContent("hdr10");
                    }
                    video.appendChild(hdr);
                }
                if (!this.movie.isDisc() && !this.movie.getMainVideoFile().getExtension().equalsIgnoreCase("iso")) {
                    Element durationinseconds = this.document.createElement("durationinseconds");
                    durationinseconds.setTextContent(Integer.toString(this.movie.getRuntimeFromMediaFilesInSeconds()));
                    video.appendChild(durationinseconds);
                }
                if (!vid.getVideo3DFormat().isEmpty()) {
                    Element stereomode = this.document.createElement("stereomode");
                    switch (vid.getVideo3DFormat()) {
                        case "3D SBS": 
                        case "3D HSBS": {
                            stereomode.setTextContent("left_right");
                            break;
                        }
                        case "3D TAB": 
                        case "3D HTAB": {
                            stereomode.setTextContent("top_bottom");
                            break;
                        }
                        default: {
                            stereomode.setTextContent(vid.getVideo3DFormat());
                        }
                    }
                    video.appendChild(stereomode);
                }
                streamdetails.appendChild(video);
                for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                    Element audio = this.document.createElement("audio");
                    Element codec2 = this.document.createElement("codec");
                    codec2.setTextContent(audioStream.getCodec().replaceAll("-", "_"));
                    audio.appendChild(codec2);
                    Element language = this.document.createElement("language");
                    language.setTextContent(audioStream.getLanguage());
                    audio.appendChild(language);
                    Element channels = this.document.createElement("channels");
                    channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                    audio.appendChild(channels);
                    streamdetails.appendChild(audio);
                }
                if (this.settings.isIncludeExternalAudioStreams()) {
                    for (MediaFile audioFile : this.movie.getMediaFiles(MediaFileType.AUDIO)) {
                        for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                            Element audio = this.document.createElement("audio");
                            Element codec3 = this.document.createElement("codec");
                            codec3.setTextContent(audioStream.getCodec());
                            audio.appendChild(codec3);
                            Element language = this.document.createElement("language");
                            language.setTextContent(audioStream.getLanguage());
                            audio.appendChild(language);
                            Element channels = this.document.createElement("channels");
                            channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                            audio.appendChild(channels);
                            streamdetails.appendChild(audio);
                        }
                    }
                }
                for (MediaFileSubtitle sub : vid.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(sub.getLanguage());
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
            }
            for (MediaFile mediaFile : this.movie.getMediaFiles(MediaFileType.SUBTITLE)) {
                for (MediaFileSubtitle sub : mediaFile.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(sub.getLanguage());
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
            }
            fileinfo.appendChild(streamdetails);
            this.root.appendChild(fileinfo);
        }
    }

    protected void addWatched() {
        Element watched = this.document.createElement("watched");
        watched.setTextContent(Boolean.toString(this.movie.isWatched()));
        this.root.appendChild(watched);
    }

    protected void addPlaycount() {
        int playCountFromNFO;
        Element playcount = this.document.createElement("playcount");
        int n = playCountFromNFO = this.parser != null ? this.parser.playcount : 0;
        if (this.movie.isWatched()) {
            playCountFromNFO = Math.max(this.movie.getPlaycount(), playCountFromNFO);
            if (this.movie.isWatched()) {
                playCountFromNFO = Math.max(playCountFromNFO, 1);
            }
        } else {
            playCountFromNFO = 0;
        }
        playcount.setTextContent(Integer.toString(playCountFromNFO));
        this.root.appendChild(playcount);
    }

    protected void addLastPlayed() {
        Date lastPlayedFromMovie;
        Date lastPlayedFromNFO;
        Date lastPlayedDate;
        Element lastPlayed = this.document.createElement("lastplayed");
        if (this.movie.isWatched() && (lastPlayedDate = DateUtils.getHigherDate(lastPlayedFromNFO = this.parser != null ? this.parser.lastplayed : null, lastPlayedFromMovie = this.movie.getLastWatched())) != null) {
            lastPlayed.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastPlayedDate));
            this.root.appendChild(lastPlayed);
        }
    }

    protected void addGenres() {
        for (MediaGenres mediaGenre : this.movie.getGenres()) {
            Element genre = this.document.createElement("genre");
            genre.setTextContent(mediaGenre.getLocalizedName(this.settings.getNfoLanguage()));
            this.root.appendChild(genre);
        }
    }

    protected void addStudios() {
        List<String> studios = ParserUtils.split(this.movie.getProductionCompany());
        for (String s : studios) {
            Element studio = this.document.createElement("studio");
            studio.setTextContent(s);
            this.root.appendChild(studio);
            if (!this.settings.isNfoWriteSingleStudio()) continue;
            break;
        }
    }

    protected void addCredits() {
        for (Person writer : this.movie.getWriters()) {
            Element element = this.document.createElement("credits");
            element.setTextContent(writer.getName());
            this.addPersonIdsAsAttributes(element, writer);
            this.root.appendChild(element);
        }
    }

    protected void addDirectors() {
        for (Person director : this.movie.getDirectors()) {
            Element element = this.document.createElement("director");
            element.setTextContent(director.getName());
            this.addPersonIdsAsAttributes(element, director);
            this.root.appendChild(element);
        }
    }

    protected void addTags() {
        for (String t : this.movie.getTags()) {
            Element tag = this.document.createElement("tag");
            tag.setTextContent(t);
            this.root.appendChild(tag);
        }
    }

    protected void addActors() {
        for (Person movieActor : this.movie.getActors()) {
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(movieActor.getName());
            actor.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)movieActor.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(movieActor.getRole());
                actor.appendChild(role);
            }
            if (StringUtils.isNotBlank((CharSequence)movieActor.getThumbUrl())) {
                Element thumb = this.document.createElement("thumb");
                thumb.setTextContent(movieActor.getThumbUrl());
                actor.appendChild(thumb);
            }
            if (StringUtils.isNotBlank((CharSequence)movieActor.getProfileUrl())) {
                Element profile = this.document.createElement("profile");
                profile.setTextContent(movieActor.getProfileUrl());
                actor.appendChild(profile);
            }
            this.addPersonIdsAsChildren(actor, movieActor);
            this.root.appendChild(actor);
        }
    }

    protected void addProducers() {
        for (Person movieProducer : this.movie.getProducers()) {
            Element producer = this.document.createElement("producer");
            Element name = this.document.createElement("name");
            name.setTextContent(movieProducer.getName());
            producer.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)movieProducer.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(movieProducer.getRole());
                producer.appendChild(role);
            }
            if (StringUtils.isNotBlank((CharSequence)movieProducer.getThumbUrl())) {
                Element thumb = this.document.createElement("thumb");
                thumb.setTextContent(movieProducer.getThumbUrl());
                producer.appendChild(thumb);
            }
            if (StringUtils.isNotBlank((CharSequence)movieProducer.getProfileUrl())) {
                Element profile = this.document.createElement("profile");
                profile.setTextContent(movieProducer.getProfileUrl());
                producer.appendChild(profile);
            }
            this.addPersonIdsAsAttributes(producer, movieProducer);
            this.root.appendChild(producer);
        }
    }

    protected void addLanguages() {
        Element languages = this.document.createElement("languages");
        ArrayList<String> translatedLanguages = new ArrayList<String>();
        for (String langu : ParserUtils.split(this.movie.getSpokenLanguages())) {
            String translated = LanguageUtils.getLocalizedLanguageNameFromLocalizedString(this.settings.getNfoLanguage(), langu.strip());
            translatedLanguages.add(translated);
        }
        languages.setTextContent(String.join((CharSequence)", ", translatedLanguages));
        this.root.appendChild(languages);
    }

    protected void addShowlink() {
        for (String showName : this.movie.getShowlinks()) {
            Element showlink = this.document.createElement("showlink");
            showlink.setTextContent(showName);
            this.root.appendChild(showlink);
        }
    }

    protected void addTrailer() {
        if (this.settings.isNfoWriteTrailer()) {
            Element trailer = this.document.createElement("trailer");
            for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.movie.getTrailer())) {
                if (!mediaTrailer.getInNfo().booleanValue()) continue;
                trailer.setTextContent(mediaTrailer.getUrl());
                break;
            }
            this.root.appendChild(trailer);
        }
    }

    protected void addSource() {
        Element source = this.document.createElement("source");
        source.setTextContent(this.movie.getMediaSource().name());
        this.root.appendChild(source);
    }

    protected void addUnsupportedTags() {
        if (this.parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : this.parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes(StandardCharsets.UTF_8)));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    LOGGER.error("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void addTinyMediaManagerTags() {
        this.root.appendChild(this.document.createComment("tinyMediaManager meta data"));
        this.addSource();
        this.addEdition();
        this.addOriginalFilename();
        this.addUserNote();
    }

    protected void addUserNote() {
        Element userNote = this.document.createElement("user_note");
        userNote.setTextContent(this.movie.getNote());
        this.root.appendChild(userNote);
    }

    protected void addOriginalFilename() {
        Element originalFileName = this.document.createElement("original_filename");
        if (StringUtils.isBlank((CharSequence)this.movie.getOriginalFilename())) {
            originalFileName.setTextContent(this.movie.getMainFile().getFilename());
        } else {
            originalFileName.setTextContent(this.movie.getOriginalFilename());
        }
        this.root.appendChild(originalFileName);
    }

    protected void addEdition() {
        Element edition = this.document.createElement("edition");
        edition.setTextContent(this.movie.getEdition().name());
        this.root.appendChild(edition);
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    protected Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        try {
            transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }

    private String detectDefaultScraper() {
        if (this.movie.getIds().containsKey("imdb")) {
            return "imdb";
        }
        if (this.movie.getIds().containsKey("tmdb")) {
            return "tmdb";
        }
        return this.movie.getIds().keySet().stream().findFirst().orElse("");
    }

    protected void addPersonIdsAsAttributes(Element element, Person person) {
        int tvdbId;
        String imdbId;
        int tmdbId = person.getIdAsInt("tmdb");
        if (tmdbId > 0) {
            element.setAttribute("tmdbid", String.valueOf(tmdbId));
        }
        if (StringUtils.isNotBlank((CharSequence)(imdbId = person.getIdAsString("imdb")))) {
            element.setAttribute("imdbid", imdbId);
        }
        if ((tvdbId = person.getIdAsInt("tvdb")) > 0) {
            element.setAttribute("tvdbid", String.valueOf(tvdbId));
        }
    }

    protected void addPersonIdsAsChildren(Element element, Person person) {
        int tvdbId;
        String imdbId;
        int tmdbId = person.getIdAsInt("tmdb");
        if (tmdbId > 0) {
            Element id = this.document.createElement("tmdbid");
            id.setTextContent(String.valueOf(tmdbId));
            element.appendChild(id);
        }
        if (StringUtils.isNotBlank((CharSequence)(imdbId = person.getIdAsString("imdb")))) {
            Element id = this.document.createElement("imdbid");
            id.setTextContent(imdbId);
            element.appendChild(id);
        }
        if ((tvdbId = person.getIdAsInt("tvdb")) > 0) {
            Element id = this.document.createElement("tvdbid");
            id.setTextContent(String.valueOf(tvdbId));
            element.appendChild(id);
        }
    }
}

