/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieSetArtworkProvider;

public class MovieSetMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetMissingArtworkDownloadTask.class);
    private final List<MovieSet> moviesToScrape;
    private final MovieSetSearchAndScrapeOptions scrapeOptions;

    public MovieSetMissingArtworkDownloadTask(List<MovieSet> moviesToScrape, MovieSetSearchAndScrapeOptions scrapeOptions) {
        super(TmmResourceBundle.getString("task.missingartwork"));
        this.moviesToScrape = new ArrayList<MovieSet>(moviesToScrape);
        this.scrapeOptions = scrapeOptions;
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing movieset artwork");
        this.initThreadPool(3, "scrapeMissingMovieSetArtwork");
        this.start();
        for (MovieSet movieSet : this.moviesToScrape) {
            MovieSetArtworkHelper.cleanupArtwork(movieSet);
            if (!MovieSetArtworkHelper.hasMissingArtwork(movieSet)) continue;
            this.submitTask(new Worker(movieSet));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final MovieSet movieSet;

        public Worker(MovieSet movieSet) {
            this.movieSet = movieSet;
        }

        @Override
        public void run() {
            try {
                MovieList movieList = MovieModuleManager.getInstance().getMovieList();
                ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE_SET);
                options.setDataFromOtherOptions(MovieSetMissingArtworkDownloadTask.this.scrapeOptions);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                options.setIds(this.movieSet.getIds());
                options.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
                options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
                movieList.getDefaultArtworkScrapers().parallelStream().forEach(scraper -> {
                    if (scraper.getMediaProvider() instanceof IMovieSetArtworkProvider) {
                        IMovieSetArtworkProvider artworkProvider = (IMovieSetArtworkProvider)scraper.getMediaProvider();
                        try {
                            lock.writeLock().lock();
                            artwork.addAll(artworkProvider.getArtwork(options));
                        }
                        catch (MissingIdException missingIdException) {
                        }
                        catch (ScrapeException e) {
                            LOGGER.error("getArtwork", (Throwable)e);
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieSet, "message.scrape.moviesetartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                        }
                        finally {
                            lock.writeLock().unlock();
                        }
                    }
                });
                if (!artwork.isEmpty()) {
                    MovieSetArtworkHelper.getMissingArtwork(this.movieSet, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

