/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.license.TmmFeature;

public abstract class TmmTask
implements Runnable,
TmmTaskHandle,
TmmFeature {
    private final Set<TmmTaskListener> listeners = new CopyOnWriteArraySet<TmmTaskListener>();
    private final TmmTaskHandle.TaskType type;
    private final long uniqueId;
    protected TmmTaskHandle.TaskState state = TmmTaskHandle.TaskState.CREATED;
    protected String taskName;
    protected String taskDescription;
    protected int workUnits;
    protected int progressDone;
    protected boolean cancel;
    protected Thread thread;

    protected TmmTask(String taskName, int workUnits, TmmTaskHandle.TaskType type) {
        this.taskName = taskName;
        this.workUnits = workUnits;
        this.taskDescription = "";
        this.progressDone = 0;
        this.type = type;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        this.thread = null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public final String getTaskName() {
        return this.taskName;
    }

    @Override
    public final int getWorkUnits() {
        return this.workUnits;
    }

    @Override
    public final int getProgressDone() {
        return this.progressDone;
    }

    @Override
    public final String getTaskDescription() {
        return this.taskDescription;
    }

    @Override
    public final TmmTaskHandle.TaskState getState() {
        return this.state;
    }

    protected final void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    protected final void setWorkUnits(int workUnits) {
        this.workUnits = workUnits;
    }

    protected final void setProgressDone(int progressDone) {
        this.progressDone = progressDone;
    }

    protected final void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public final void addListener(TmmTaskListener listener) {
        this.listeners.add(listener);
    }

    protected final void setState(TmmTaskHandle.TaskState newState) {
        this.state = newState;
        this.informListeners();
    }

    public final void removeListener(TmmTaskListener listener) {
        this.listeners.remove(listener);
    }

    protected final void informListeners() {
        TmmModuleManager.getInstance().setActive();
        for (TmmTaskListener listener : this.listeners) {
            listener.processTaskEvent(this);
        }
    }

    @Override
    public final void run() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        if (this.cancel) {
            this.finish();
            return;
        }
        Object name = Thread.currentThread().getName();
        if (!((String)name).contains("-G")) {
            name = (String)name + "-G0";
        }
        name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
        Thread.currentThread().setName((String)name);
        this.start();
        try {
            this.doInBackground();
        }
        finally {
            this.finish();
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.setState(TmmTaskHandle.TaskState.CANCELLED);
    }

    protected void start() {
        this.thread = Thread.currentThread();
        this.setState(TmmTaskHandle.TaskState.STARTED);
    }

    protected void publishState(String taskDescription, int progress) {
        this.taskDescription = taskDescription;
        this.progressDone = progress;
        this.informListeners();
    }

    protected void publishState(int progress) {
        this.progressDone = progress;
        this.informListeners();
    }

    protected void publishState(String taskDescription) {
        this.taskDescription = taskDescription;
        this.publishState();
    }

    protected void publishState() {
        this.informListeners();
    }

    protected void finish() {
        if (this.state != TmmTaskHandle.TaskState.FAILED) {
            this.setState(TmmTaskHandle.TaskState.FINISHED);
        }
        this.thread = null;
        this.listeners.clear();
    }

    @Override
    public final TmmTaskHandle.TaskType getType() {
        return this.type;
    }

    protected abstract void doInBackground();
}

