/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;

public class TvShowRenamerPreviewContainer {
    final TvShow tvShow;
    final Path oldPath;
    final List<MediaFile> oldMediaFiles;
    final List<MediaFile> newMediaFiles;
    Path newPath;
    boolean needsRename = false;

    public TvShowRenamerPreviewContainer(TvShow tvShow) {
        this.tvShow = tvShow;
        this.newMediaFiles = new ArrayList<MediaFile>();
        this.oldMediaFiles = new ArrayList<MediaFile>();
        this.oldPath = !tvShow.getDataSource().isEmpty() ? tvShow.getPathNIO() : null;
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public Path getOldPath() {
        return this.oldPath;
    }

    public Path getOldPathRelative() {
        return Paths.get(this.tvShow.getDataSource(), new String[0]).relativize(this.tvShow.getPathNIO());
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public Path getNewPathRelative() {
        return Paths.get(this.tvShow.getDataSource(), new String[0]).relativize(this.newPath);
    }

    public List<MediaFile> getOldMediaFiles() {
        return this.oldMediaFiles;
    }

    public List<MediaFile> getNewMediaFiles() {
        return this.newMediaFiles;
    }

    public boolean isNeedsRename() {
        return this.needsRename;
    }
}

