/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.filenaming.TvShowBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowCharacterartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowClearartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowClearlogoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowDiscartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowKeyartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;

public final class TvShowSettings
extends AbstractSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSettings.class);
    private static final String CONFIG_FILE = "tvShows.json";
    public static final String DEFAULT_RENAMER_FOLDER_PATTERN = "${showTitle} (${showYear})";
    public static final String DEFAULT_RENAMER_SEASON_PATTERN = "Season ${seasonNr}";
    public static final String DEFAULT_RENAMER_FILE_PATTERN = "${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}";
    private static TvShowSettings instance;
    static final String TV_SHOW_DATA_SOURCE = "tvShowDataSource";
    static final String ARTWORK_SCRAPERS = "artworkScrapers";
    static final String TRAILER_SCRAPERS = "trailerScrapers";
    static final String TRAILER_FILENAME = "trailerFilename";
    static final String CERTIFICATION_COUNTRY = "certificationCountry";
    static final String RENAMER_SEASON_FOLDER = "renamerSeasonFoldername";
    static final String BAD_WORD = "badWord";
    static final String SKIP_FOLDER = "skipFolder";
    static final String SUBTITLE_SCRAPERS = "subtitleScrapers";
    static final String NFO_FILENAME = "nfoFilename";
    static final String POSTER_FILENAME = "posterFilename";
    static final String FANART_FILENAME = "fanartFilename";
    static final String EXTRAFANART_FILENAME = "extraFanartFilename";
    static final String BANNER_FILENAME = "bannerFilename";
    static final String DISCART_FILENAME = "discartFilename";
    static final String CLEARART_FILENAME = "clearartFilename";
    static final String THUMB_FILENAME = "thumbFilename";
    static final String CLEARLOGO_FILENAME = "clearlogoFilename";
    static final String CHARACTERART_FILENAME = "characterartFilename";
    static final String KEYART_FILENAME = "keyartFilename";
    static final String SEASON_NFO_FILENAME = "seasonNfoFilename";
    static final String SEASON_POSTER_FILENAME = "seasonPosterFilename";
    static final String SEASON_FANART_FILENAME = "seasonFanartFilename";
    static final String SEASON_BANNER_FILENAME = "seasonBannerFilename";
    static final String SEASON_THUMB_FILENAME = "seasonThumbFilename";
    static final String EPISODE_NFO_FILENAME = "episodeNfoFilename";
    static final String EPISODE_THUMB_FILENAME = "episodeThumbFilename";
    static final String TVSHOW_CHECK_METADATA = "tvShowCheckMetadata";
    static final String TVSHOW_CHECK_ARTWORK = "tvShowCheckArtwork";
    static final String SEASON_CHECK_ARTWORK = "seasonCheckArtwork";
    static final String EPISODE_CHECK_METADATA = "episodeCheckMetadata";
    static final String EPISODE_CHECK_ARTWORK = "episodeCheckArtwork";
    static final String NODE = "node";
    static final String TITLE = "title";
    static final String ORIGINAL_TITLE = "originalTitle";
    static final String NOTE = "note";
    final List<String> tvShowDataSources = ObservableCollections.observableList(new ArrayList());
    final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    final List<String> artworkScrapers = ObservableCollections.observableList(new ArrayList());
    final List<String> trailerScrapers = ObservableCollections.observableList(new ArrayList());
    final List<String> skipFolders = ObservableCollections.observableList(new ArrayList());
    final List<String> subtitleScrapers = ObservableCollections.observableList(new ArrayList());
    final List<PostProcess> postProcessTvShow = ObservableCollections.observableList(new ArrayList());
    final List<PostProcess> postProcessEpisode = ObservableCollections.observableList(new ArrayList());
    final List<TvShowNfoNaming> nfoFilenames = new ArrayList<TvShowNfoNaming>();
    final List<TvShowPosterNaming> posterFilenames = new ArrayList<TvShowPosterNaming>();
    final List<TvShowFanartNaming> fanartFilenames = new ArrayList<TvShowFanartNaming>();
    final List<TvShowExtraFanartNaming> extraFanartFilenames = new ArrayList<TvShowExtraFanartNaming>();
    final List<TvShowBannerNaming> bannerFilenames = new ArrayList<TvShowBannerNaming>();
    final List<TvShowDiscartNaming> discartFilenames = new ArrayList<TvShowDiscartNaming>();
    final List<TvShowClearartNaming> clearartFilenames = new ArrayList<TvShowClearartNaming>();
    final List<TvShowThumbNaming> thumbFilenames = new ArrayList<TvShowThumbNaming>();
    final List<TvShowClearlogoNaming> clearlogoFilenames = new ArrayList<TvShowClearlogoNaming>();
    final List<TvShowCharacterartNaming> characterartFilenames = new ArrayList<TvShowCharacterartNaming>();
    final List<TvShowKeyartNaming> keyartFilenames = new ArrayList<TvShowKeyartNaming>();
    final List<TvShowSeasonNfoNaming> seasonNfoFilenames = new ArrayList<TvShowSeasonNfoNaming>();
    final List<TvShowSeasonPosterNaming> seasonPosterFilenames = new ArrayList<TvShowSeasonPosterNaming>();
    final List<TvShowSeasonFanartNaming> seasonFanartFilenames = new ArrayList<TvShowSeasonFanartNaming>();
    final List<TvShowSeasonBannerNaming> seasonBannerFilenames = new ArrayList<TvShowSeasonBannerNaming>();
    final List<TvShowSeasonThumbNaming> seasonThumbFilenames = new ArrayList<TvShowSeasonThumbNaming>();
    final List<TvShowEpisodeNfoNaming> episodeNfoFilenames = new ArrayList<TvShowEpisodeNfoNaming>();
    final List<TvShowEpisodeThumbNaming> episodeThumbFilenames = new ArrayList<TvShowEpisodeThumbNaming>();
    final List<TvShowTrailerNaming> trailerFilenames = new ArrayList<TvShowTrailerNaming>();
    final Map<String, List<AbstractSettings.UIFilters>> uiFilterPresets = new HashMap<String, List<AbstractSettings.UIFilters>>();
    boolean skipFoldersWithNomedia = true;
    TvShowConnectors tvShowConnector = TvShowConnectors.KODI;
    CertificationStyle certificationStyle = CertificationStyle.LARGE;
    boolean writeCleanNfo = false;
    boolean nfoWriteDateAdded = true;
    DateField nfoDateAddedField = DateField.DATE_ADDED;
    Locale nfoLanguage = Locale.ENGLISH;
    boolean nfoWriteEpisodeguide = true;
    boolean nfoWriteNewEpisodeguideStyle = true;
    boolean nfoWriteDateEnded = false;
    boolean nfoWriteAllActors = false;
    boolean nfoWriteSingleStudio = false;
    boolean nfoWriteLockdata = false;
    boolean nfoWriteTrailer = true;
    boolean nfoWriteFileinfo = true;
    boolean renameAfterScrape = false;
    boolean updateOnStart = false;
    String renamerTvShowFoldername = "${showTitle} (${showYear})";
    String renamerSeasonFoldername = "Season ${seasonNr}";
    String renamerFilename = "${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}";
    boolean renamerShowPathnameSpaceSubstitution = false;
    String renamerShowPathnameSpaceReplacement = "_";
    boolean renamerSeasonPathnameSpaceSubstitution = false;
    String renamerSeasonPathnameSpaceReplacement = "_";
    boolean renamerFilenameSpaceSubstitution = false;
    String renamerFilenameSpaceReplacement = "_";
    String renamerColonReplacement = "";
    boolean renamerCleanupUnwanted = false;
    String renamerFirstCharacterNumberReplacement = "#";
    boolean asciiReplacement = false;
    boolean specialSeason = true;
    boolean createMissingSeasonItems = false;
    String scraper = "tvdb";
    MediaLanguages scraperLanguage = MediaLanguages.en;
    CountryCode certificationCountry = CountryCode.US;
    String releaseDateCountry = "";
    final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = new ArrayList<TvShowScraperMetadataConfig>();
    final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    boolean doNotOverwriteExistingData = false;
    boolean fetchAllRatings = false;
    final List<MediaLanguages> imageScraperLanguages = ObservableCollections.observableList(new ArrayList());
    boolean imageScraperOtherResolutions = true;
    boolean imageScraperFallback = true;
    boolean imageScraperPreferFanartWoText = true;
    MediaArtwork.PosterSizes imagePosterSize = MediaArtwork.PosterSizes.LARGE;
    MediaArtwork.FanartSizes imageFanartSize = MediaArtwork.FanartSizes.LARGE;
    MediaArtwork.ThumbSizes imageThumbSize = MediaArtwork.ThumbSizes.MEDIUM;
    boolean scrapeBestImage = true;
    boolean writeActorImages = false;
    boolean imageExtraFanart = false;
    int imageExtraFanartCount = 5;
    boolean imageEpisodeScrapeAllSources = false;
    boolean useYtDlp = false;
    boolean useTrailerPreference = true;
    boolean automaticTrailerDownload = false;
    TrailerQuality trailerQuality = TrailerQuality.HD_720;
    MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    LanguageStyle subtitleLanguageStyle = LanguageStyle.ISO3T;
    boolean subtitleForceBestMatch = false;
    boolean runtimeFromMediaInfo = true;
    boolean buildImageCacheOnImport = true;
    boolean syncTrakt = false;
    boolean syncTraktCollection = true;
    boolean syncTraktWatched = true;
    boolean syncTraktRating = true;
    boolean extractArtworkFromVsmeta = false;
    boolean useMediainfoMetadata = false;
    final List<MediaFileType> showTvShowArtworkTypes = ObservableCollections.observableList(new ArrayList());
    final List<MediaFileType> showSeasonArtworkTypes = ObservableCollections.observableList(new ArrayList());
    final List<MediaFileType> showEpisodeArtworkTypes = ObservableCollections.observableList(new ArrayList());
    boolean displayMissingEpisodes = false;
    boolean displayMissingSpecials = false;
    boolean displayMissingNotAired = false;
    boolean capitalWordsinTitles = false;
    boolean showTvShowTableTooltips = true;
    boolean seasonArtworkFallback = false;
    boolean storeUiFilters = false;
    boolean resetNewFlagOnUds = true;
    final List<AbstractSettings.UIFilters> uiFilters = new ArrayList<AbstractSettings.UIFilters>();
    final List<AbstractSettings.UniversalFilterFields> universalFilterFields = new ArrayList<AbstractSettings.UniversalFilterFields>();
    final List<TvShowScraperMetadataConfig> tvShowCheckMetadata = new ArrayList<TvShowScraperMetadataConfig>();
    boolean tvShowDisplayAllMissingMetadata = false;
    final List<TvShowScraperMetadataConfig> tvShowCheckArtwork = new ArrayList<TvShowScraperMetadataConfig>();
    boolean tvShowDisplayAllMissingArtwork = false;
    final List<TvShowScraperMetadataConfig> seasonCheckArtwork = new ArrayList<TvShowScraperMetadataConfig>();
    boolean seasonDisplayAllMissingArtwork = false;
    final List<TvShowEpisodeScraperMetadataConfig> episodeCheckMetadata = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    boolean episodeDisplayAllMissingMetadata = false;
    boolean episodeSpecialsCheckMissingMetadata = false;
    final List<TvShowEpisodeScraperMetadataConfig> episodeCheckArtwork = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    boolean episodeDisplayAllMissingArtwork = false;
    boolean episodeSpecialsCheckMissingArtwork = false;
    boolean node = true;
    boolean title = true;
    boolean originalTitle = true;
    boolean note = false;
    final List<String> ratingSources = ObservableCollections.observableList(new ArrayList());

    public TvShowSettings() {
        this.addDefaultEntries();
        this.addPropertyChangeListener(evt -> this.setDirty());
    }

    private void addDefaultEntries() {
        this.skipFolders.clear();
        this.addSkipFolder("MAKEMKV");
        this.nfoFilenames.clear();
        this.addNfoFilename(TvShowNfoNaming.TV_SHOW);
        this.posterFilenames.clear();
        this.addPosterFilename(TvShowPosterNaming.POSTER);
        this.fanartFilenames.clear();
        this.addFanartFilename(TvShowFanartNaming.FANART);
        this.bannerFilenames.clear();
        this.addBannerFilename(TvShowBannerNaming.BANNER);
        this.discartFilenames.clear();
        this.addDiscartFilename(TvShowDiscartNaming.DISCART);
        this.clearartFilenames.clear();
        this.addClearartFilename(TvShowClearartNaming.CLEARART);
        this.characterartFilenames.clear();
        this.addCharacterartFilename(TvShowCharacterartNaming.CHARACTERART);
        this.clearlogoFilenames.clear();
        this.addClearlogoFilename(TvShowClearlogoNaming.CLEARLOGO);
        this.thumbFilenames.clear();
        this.addThumbFilename(TvShowThumbNaming.THUMB);
        this.keyartFilenames.clear();
        this.addKeyartFilename(TvShowKeyartNaming.KEYART);
        this.imageScraperLanguages.clear();
        this.addImageScraperLanguage(MediaLanguages.en);
        this.seasonNfoFilenames.clear();
        this.seasonPosterFilenames.clear();
        this.addSeasonPosterFilename(TvShowSeasonPosterNaming.SEASON_POSTER);
        this.seasonFanartFilenames.clear();
        this.addSeasonFanartFilename(TvShowSeasonFanartNaming.SEASON_FANART);
        this.seasonBannerFilenames.clear();
        this.addSeasonBannerFilename(TvShowSeasonBannerNaming.SEASON_BANNER);
        this.seasonThumbFilenames.clear();
        this.addSeasonThumbFilename(TvShowSeasonThumbNaming.SEASON_THUMB);
        this.episodeNfoFilenames.clear();
        this.addEpisodeNfoFilename(TvShowEpisodeNfoNaming.FILENAME);
        this.episodeThumbFilenames.clear();
        this.addEpisodeThumbFilename(TvShowEpisodeThumbNaming.FILENAME_THUMB);
        this.showTvShowArtworkTypes.clear();
        this.addShowTvShowArtworkTypes(MediaFileType.POSTER);
        this.addShowTvShowArtworkTypes(MediaFileType.FANART);
        this.addShowTvShowArtworkTypes(MediaFileType.BANNER);
        this.showSeasonArtworkTypes.clear();
        this.addShowSeasonArtworkTypes(MediaFileType.SEASON_POSTER);
        this.addShowSeasonArtworkTypes(MediaFileType.SEASON_THUMB);
        this.addShowSeasonArtworkTypes(MediaFileType.SEASON_BANNER);
        this.showEpisodeArtworkTypes.clear();
        this.addShowEpisodeArtworkTypes(MediaFileType.THUMB);
        this.tvShowCheckMetadata.clear();
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.ID);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.TITLE);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.PLOT);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.YEAR);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.STATUS);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.GENRES);
        this.addTvShowCheckMetadata(TvShowScraperMetadataConfig.ACTORS);
        this.tvShowCheckArtwork.clear();
        this.addTvShowCheckArtwork(TvShowScraperMetadataConfig.POSTER);
        this.addTvShowCheckArtwork(TvShowScraperMetadataConfig.FANART);
        this.addTvShowCheckArtwork(TvShowScraperMetadataConfig.BANNER);
        this.seasonCheckArtwork.clear();
        this.addSeasonCheckArtwork(TvShowScraperMetadataConfig.SEASON_POSTER);
        this.addSeasonCheckArtwork(TvShowScraperMetadataConfig.SEASON_BANNER);
        this.addSeasonCheckArtwork(TvShowScraperMetadataConfig.SEASON_THUMB);
        this.episodeCheckMetadata.clear();
        this.addEpisodeCheckMetadata(TvShowEpisodeScraperMetadataConfig.SEASON_EPISODE);
        this.addEpisodeCheckMetadata(TvShowEpisodeScraperMetadataConfig.TITLE);
        this.addEpisodeCheckMetadata(TvShowEpisodeScraperMetadataConfig.ACTORS);
        this.episodeCheckArtwork.clear();
        this.addEpisodeCheckArtwork(TvShowEpisodeScraperMetadataConfig.THUMB);
        this.ratingSources.clear();
        this.addRatingSource("imdb");
        this.trailerFilenames.clear();
        this.addTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        this.tvShowScraperMetadataConfig.addAll(Arrays.asList(TvShowScraperMetadataConfig.values()));
        this.episodeScraperMetadataConfig.addAll(Arrays.asList(TvShowEpisodeScraperMetadataConfig.values()));
        this.universalFilterFields.addAll(Arrays.asList(AbstractSettings.UniversalFilterFields.values()));
    }

    @Override
    protected ObjectWriter createObjectWriter() {
        return objectMapper.writerFor(TvShowSettings.class);
    }

    static synchronized TvShowSettings getInstance() {
        return TvShowSettings.getInstance(Settings.getInstance().getSettingsFolder());
    }

    static synchronized TvShowSettings getInstance(String folder) {
        if (instance == null) {
            instance = (TvShowSettings)TvShowSettings.getInstance(folder, CONFIG_FILE, TvShowSettings.class);
        }
        return instance;
    }

    static void clearInstance() {
        instance = null;
    }

    @Override
    public String getConfigFilename() {
        return CONFIG_FILE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void afterLoading() {
    }

    @Override
    protected void writeDefaultSettings() {
        this.addDefaultEntries();
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TVSHOW_SUBTITLE)) {
            this.addTvShowSubtitleScraper(ms.getId());
        }
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TVSHOW_ARTWORK)) {
            this.addTvShowArtworkScraper(ms.getId());
        }
        String defaultLang = Locale.getDefault().getLanguage();
        CountryCode cc = CountryCode.getByCode(defaultLang.toUpperCase(Locale.ROOT));
        if (cc != null) {
            this.setCertificationCountry(cc);
            this.setReleaseDateCountry(cc.getAlpha2());
        }
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (!ml.name().equals(defaultLang)) continue;
            this.setScraperLanguage(ml);
            this.setNfoLanguage(ml.toLocale());
            this.imageScraperLanguages.clear();
            this.addImageScraperLanguage(ml);
            this.setSubtitleScraperLanguage(ml);
        }
        this.saveSettings();
    }

    public void setTvShowDataSources(Collection<String> dataSources) {
        this.tvShowDataSources.clear();
        this.tvShowDataSources.addAll(dataSources);
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        this.firePropertyChange("dataSource", null, this.tvShowDataSources);
    }

    public void addTvShowDataSources(String path) {
        if (!this.tvShowDataSources.contains(path)) {
            this.tvShowDataSources.add(path);
            this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
            this.firePropertyChange("dataSource", null, this.tvShowDataSources);
        }
    }

    public void removeTvShowDataSources(String path) {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        tvShowList.removeDatasource(path);
        this.tvShowDataSources.remove(path);
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        this.firePropertyChange("dataSource", null, this.tvShowDataSources);
    }

    public void exchangeTvShowDatasource(String oldDatasource, String newDatasource) {
        int index = this.tvShowDataSources.indexOf(oldDatasource);
        if (index > -1) {
            this.tvShowDataSources.remove(oldDatasource);
            if (!this.tvShowDataSources.contains(newDatasource)) {
                this.tvShowDataSources.add(index, newDatasource);
            }
            TvShowModuleManager.getInstance().getTvShowList().exchangeDatasource(oldDatasource, newDatasource);
        }
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        this.firePropertyChange("dataSource", null, this.tvShowDataSources);
    }

    public List<String> getTvShowDataSource() {
        return this.tvShowDataSources;
    }

    public void swapTvShowDataSource(int pos1, int pos2) {
        String tmp = this.tvShowDataSources.get(pos1);
        this.tvShowDataSources.set(pos1, this.tvShowDataSources.get(pos2));
        this.tvShowDataSources.set(pos2, tmp);
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        this.firePropertyChange("dataSource", null, this.tvShowDataSources);
    }

    public String getScraper() {
        if (StringUtils.isBlank((CharSequence)this.scraper)) {
            return "tvdb";
        }
        return this.scraper;
    }

    public void setScraper(String newValue) {
        String oldValue = this.scraper;
        this.scraper = newValue;
        this.firePropertyChange("scraper", oldValue, newValue);
    }

    public void addTvShowArtworkScraper(String newValue) {
        if (!this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.add(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void removeTvShowArtworkScraper(String newValue) {
        if (this.artworkScrapers.contains(newValue)) {
            this.artworkScrapers.remove(newValue);
            this.firePropertyChange(ARTWORK_SCRAPERS, null, this.artworkScrapers);
        }
    }

    public void addTrailerFilename(TvShowTrailerNaming filename) {
        if (!this.trailerFilenames.contains(filename)) {
            this.trailerFilenames.add(filename);
            this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
        }
    }

    public void clearTrailerFilenames() {
        this.trailerFilenames.clear();
        this.firePropertyChange(TRAILER_FILENAME, null, this.trailerFilenames);
    }

    public List<TvShowTrailerNaming> getTrailerFilenames() {
        return Collections.unmodifiableList(this.trailerFilenames);
    }

    public boolean isUseYtDlp() {
        return this.useYtDlp;
    }

    public void setUseYtDlp(boolean newValue) {
        boolean oldValue = this.useYtDlp;
        this.useYtDlp = newValue;
        this.firePropertyChange("useYtDlp", oldValue, newValue);
    }

    public boolean isUseTrailerPreference() {
        return this.useTrailerPreference;
    }

    public void setUseTrailerPreference(boolean newValue) {
        boolean oldValue = this.useTrailerPreference;
        this.useTrailerPreference = newValue;
        this.firePropertyChange("useTrailerPreference", oldValue, newValue);
    }

    public boolean isAutomaticTrailerDownload() {
        return this.automaticTrailerDownload;
    }

    public void setAutomaticTrailerDownload(boolean newValue) {
        boolean oldValue = this.automaticTrailerDownload;
        this.automaticTrailerDownload = newValue;
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public TrailerQuality getTrailerQuality() {
        return this.trailerQuality;
    }

    public void setTrailerQuality(TrailerQuality newValue) {
        TrailerQuality oldValue = this.trailerQuality;
        this.trailerQuality = newValue;
        this.firePropertyChange("trailerQuality", (Object)oldValue, (Object)newValue);
    }

    public void addTvShowTrailerScraper(String newValue) {
        if (!this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.add(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public void removeTvShowTrailerScraper(String newValue) {
        if (this.trailerScrapers.contains(newValue)) {
            this.trailerScrapers.remove(newValue);
            this.firePropertyChange(TRAILER_SCRAPERS, null, this.trailerScrapers);
        }
    }

    public List<String> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public List<String> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange("scrapeBestImage", oldValue, newValue);
    }

    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange("scraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange("subtitleScraperLanguage", (Object)oldValue, (Object)newValue);
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange(CERTIFICATION_COUNTRY, (Object)oldValue, (Object)newValue);
    }

    public String getReleaseDateCountry() {
        return this.releaseDateCountry;
    }

    public void setReleaseDateCountry(String newValue) {
        String oldValue = this.releaseDateCountry;
        this.releaseDateCountry = newValue;
        this.firePropertyChange("releaseDateCountry", oldValue, newValue);
    }

    public String getRenamerSeasonFoldername() {
        return this.renamerSeasonFoldername;
    }

    public void setRenamerSeasonFoldername(String newValue) {
        String oldValue = this.renamerSeasonFoldername;
        this.renamerSeasonFoldername = newValue;
        this.firePropertyChange(RENAMER_SEASON_FOLDER, oldValue, newValue);
    }

    public String getRenamerTvShowFoldername() {
        return this.renamerTvShowFoldername;
    }

    public void setRenamerTvShowFoldername(String newValue) {
        String oldValue = this.renamerTvShowFoldername;
        this.renamerTvShowFoldername = newValue;
        this.firePropertyChange("renamerTvShowFoldername", oldValue, newValue);
    }

    public String getRenamerFilename() {
        return this.renamerFilename;
    }

    public void setRenamerFilename(String newValue) {
        String oldValue = this.renamerFilename;
        this.renamerFilename = newValue;
        this.firePropertyChange("renamerFilename", oldValue, newValue);
    }

    public boolean isUpdateOnStart() {
        return this.updateOnStart;
    }

    public void setUpdateOnStart(boolean newValue) {
        boolean oldValue = this.updateOnStart;
        this.updateOnStart = newValue;
        this.firePropertyChange("updateOnStart", oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange("buildImageCacheOnImport", oldValue, newValue);
    }

    public boolean isRuntimeFromMediaInfo() {
        return this.runtimeFromMediaInfo;
    }

    public void setRuntimeFromMediaInfo(boolean newValue) {
        boolean oldValue = this.runtimeFromMediaInfo;
        this.runtimeFromMediaInfo = newValue;
        this.firePropertyChange("runtimeFromMediaInfo", oldValue, newValue);
    }

    public boolean isExtractArtworkFromVsmeta() {
        return this.extractArtworkFromVsmeta;
    }

    public void setExtractArtworkFromVsmeta(boolean newValue) {
        boolean oldValue = this.extractArtworkFromVsmeta;
        this.extractArtworkFromVsmeta = newValue;
        this.firePropertyChange("extractArtworkFromVsmeta", oldValue, newValue);
    }

    public boolean isUseMediainfoMetadata() {
        return this.useMediainfoMetadata;
    }

    public void setUseMediainfoMetadata(boolean newValue) {
        boolean oldValue = this.useMediainfoMetadata;
        this.useMediainfoMetadata = newValue;
        this.firePropertyChange("useMediainfoMetadata", oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange("asciiReplacement", oldValue, newValue);
    }

    public boolean isRenamerCleanupUnwanted() {
        return this.renamerCleanupUnwanted;
    }

    public void setRenamerCleanupUnwanted(boolean newValue) {
        boolean oldValue = this.renamerCleanupUnwanted;
        this.renamerCleanupUnwanted = newValue;
        this.firePropertyChange("renamerCleanupUnwanted", oldValue, newValue);
    }

    public boolean isSpecialSeason() {
        return this.specialSeason;
    }

    public void setSpecialSeason(boolean newValue) {
        boolean oldValue = this.specialSeason;
        this.specialSeason = newValue;
        this.firePropertyChange("specialSeason", oldValue, newValue);
    }

    public boolean isCreateMissingSeasonItems() {
        return this.createMissingSeasonItems;
    }

    public void setCreateMissingSeasonItems(boolean newValue) {
        boolean oldValue = this.createMissingSeasonItems;
        this.createMissingSeasonItems = newValue;
        this.firePropertyChange("createMissingSeasonItems", oldValue, newValue);
    }

    public String getRenamerShowPathnameSpaceReplacement() {
        return this.renamerShowPathnameSpaceReplacement;
    }

    public void setRenamerShowPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerShowPathnameSpaceReplacement;
        this.renamerShowPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerShowPathnameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerSeasonPathnameSpaceReplacement() {
        return this.renamerSeasonPathnameSpaceReplacement;
    }

    public void setRenamerSeasonPathnameSpaceReplacement(String newValue) {
        String oldValue = this.renamerSeasonPathnameSpaceReplacement;
        this.renamerSeasonPathnameSpaceReplacement = newValue;
        this.firePropertyChange("renamerSeasonPathnameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerFilenameSpaceReplacement() {
        return this.renamerFilenameSpaceReplacement;
    }

    public void setRenamerFilenameSpaceReplacement(String newValue) {
        String oldValue = this.renamerFilenameSpaceReplacement;
        this.renamerFilenameSpaceReplacement = newValue;
        this.firePropertyChange("renamerFilenameSpaceReplacement", oldValue, newValue);
    }

    public String getRenamerColonReplacement() {
        return this.renamerColonReplacement;
    }

    public void setRenamerColonReplacement(String newValue) {
        String oldValue = this.renamerColonReplacement;
        this.renamerColonReplacement = newValue;
        this.firePropertyChange("renamerColonReplacement", oldValue, newValue);
    }

    public String getRenamerFirstCharacterNumberReplacement() {
        return this.renamerFirstCharacterNumberReplacement;
    }

    public void setRenamerFirstCharacterNumberReplacement(String newValue) {
        String oldValue = this.renamerFirstCharacterNumberReplacement;
        this.renamerFirstCharacterNumberReplacement = newValue;
        this.firePropertyChange("renamerFirstCharacterNumberReplacement", oldValue, newValue);
    }

    public boolean isRenamerShowPathnameSpaceSubstitution() {
        return this.renamerShowPathnameSpaceSubstitution;
    }

    public void setRenamerShowPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerShowPathnameSpaceSubstitution;
        this.renamerShowPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerShowPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerSeasonPathnameSpaceSubstitution() {
        return this.renamerSeasonPathnameSpaceSubstitution;
    }

    public void setRenamerSeasonPathnameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerSeasonPathnameSpaceSubstitution;
        this.renamerSeasonPathnameSpaceSubstitution = newValue;
        this.firePropertyChange("renamereasonPathnameSpaceSubstitution", oldValue, newValue);
    }

    public boolean isRenamerFilenameSpaceSubstitution() {
        return this.renamerFilenameSpaceSubstitution;
    }

    public void setRenamerFilenameSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerFilenameSpaceSubstitution;
        this.renamerFilenameSpaceSubstitution = newValue;
        this.firePropertyChange("renamerFilenameSpaceSubstitution", oldValue, newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public void setSyncTraktCollection(boolean newValue) {
        boolean oldValue = this.syncTraktCollection;
        this.syncTraktCollection = newValue;
        this.firePropertyChange("syncTraktCollection", oldValue, newValue);
    }

    public boolean getSyncTraktCollection() {
        return this.syncTraktCollection;
    }

    public void setSyncTraktWatched(boolean newValue) {
        boolean oldValue = this.syncTraktWatched;
        this.syncTraktWatched = newValue;
        this.firePropertyChange("syncTraktWatched", oldValue, newValue);
    }

    public boolean getSyncTraktWatched() {
        return this.syncTraktWatched;
    }

    public void setSyncTraktRating(boolean newValue) {
        boolean oldValue = this.syncTraktRating;
        this.syncTraktRating = newValue;
        this.firePropertyChange("syncTraktRating", oldValue, newValue);
    }

    public boolean getSyncTraktRating() {
        return this.syncTraktRating;
    }

    @JsonSetter
    public void setSkipFolder(List<String> newValues) {
        this.skipFolders.clear();
        this.skipFolders.addAll(newValues);
    }

    public void addSkipFolder(String newValue) {
        if (!this.skipFolders.contains(newValue)) {
            this.skipFolders.add(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public void removeSkipFolder(String newValue) {
        if (this.skipFolders.contains(newValue)) {
            this.skipFolders.remove(newValue);
            this.firePropertyChange(SKIP_FOLDER, null, this.skipFolders);
        }
    }

    public List<String> getSkipFolder() {
        return this.skipFolders;
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORD, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORD, null, this.badWords);
    }

    public List<String> getBadWord() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public void addEpisodeThumbFilename(TvShowEpisodeThumbNaming filename) {
        if (!this.episodeThumbFilenames.contains(filename)) {
            this.episodeThumbFilenames.add(filename);
            this.firePropertyChange(EPISODE_THUMB_FILENAME, null, this.episodeThumbFilenames);
        }
    }

    public void clearEpisodeThumbFilenames() {
        this.episodeThumbFilenames.clear();
        this.firePropertyChange(EPISODE_THUMB_FILENAME, null, this.episodeThumbFilenames);
    }

    public List<TvShowEpisodeThumbNaming> getEpisodeThumbFilenames() {
        return Collections.unmodifiableList(this.episodeThumbFilenames);
    }

    public void addTvShowSubtitleScraper(String newValue) {
        if (!this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.add(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public void removeTvShowSubtitleScraper(String newValue) {
        if (this.subtitleScrapers.contains(newValue)) {
            this.subtitleScrapers.remove(newValue);
            this.firePropertyChange(SUBTITLE_SCRAPERS, null, this.subtitleScrapers);
        }
    }

    public List<String> getSubtitleScrapers() {
        return this.subtitleScrapers;
    }

    public LanguageStyle getSubtitleLanguageStyle() {
        return this.subtitleLanguageStyle;
    }

    public void setSubtitleLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.subtitleLanguageStyle;
        this.subtitleLanguageStyle = newValue;
        this.firePropertyChange("subtitleLanguageStyle", (Object)oldValue, (Object)newValue);
    }

    public boolean getSubtitleForceBestMatch() {
        return this.subtitleForceBestMatch;
    }

    public void setSubtitleForceBestMatch(boolean newValue) {
        boolean oldValue = this.subtitleForceBestMatch;
        this.subtitleForceBestMatch = newValue;
        this.firePropertyChange("subtitleForceBestMatch", oldValue, newValue);
    }

    public Map<String, List<AbstractSettings.UIFilters>> getUiFilterPresets() {
        return this.uiFilterPresets;
    }

    public void setUiFilterPresets(Map<String, List<AbstractSettings.UIFilters>> newValues) {
        this.uiFilterPresets.clear();
        this.uiFilterPresets.putAll(newValues);
        this.firePropertyChange("uiFilterPresets", null, this.uiFilterPresets);
    }

    public boolean isDisplayMissingEpisodes() {
        return this.displayMissingEpisodes;
    }

    public void setDisplayMissingEpisodes(boolean newValue) {
        boolean oldValue = this.displayMissingEpisodes;
        this.displayMissingEpisodes = newValue;
        this.firePropertyChange("displayMissingEpisodes", oldValue, newValue);
    }

    public boolean isDisplayMissingSpecials() {
        return this.displayMissingSpecials;
    }

    public void setDisplayMissingSpecials(boolean newValue) {
        boolean oldValue = this.displayMissingSpecials;
        this.displayMissingSpecials = newValue;
        this.firePropertyChange("displayMissingSpecials", oldValue, newValue);
    }

    public boolean isDisplayMissingNotAired() {
        return this.displayMissingNotAired;
    }

    public void setDisplayMissingNotAired(boolean newValue) {
        boolean oldValue = this.displayMissingNotAired;
        this.displayMissingNotAired = newValue;
        this.firePropertyChange("displayMissingNotAired", oldValue, newValue);
    }

    public void setNode(boolean newValue) {
        boolean oldValue = this.node;
        this.node = newValue;
        this.firePropertyChange(NODE, oldValue, newValue);
    }

    public boolean getNode() {
        return this.node;
    }

    public void setTitle(boolean newValue) {
        boolean oldValue = this.node;
        this.node = newValue;
        this.firePropertyChange(TITLE, oldValue, newValue);
    }

    public boolean getTitle() {
        return this.title;
    }

    public void setOriginalTitle(boolean newValue) {
        boolean oldValue = this.originalTitle;
        this.originalTitle = newValue;
        this.firePropertyChange(ORIGINAL_TITLE, oldValue, newValue);
    }

    public boolean getOriginalTitle() {
        return this.originalTitle;
    }

    public void setNote(boolean newValue) {
        boolean oldValue = this.note;
        this.note = newValue;
        this.firePropertyChange(NOTE, oldValue, newValue);
    }

    public boolean getNote() {
        return this.note;
    }

    public List<TvShowScraperMetadataConfig> getTvShowScraperMetadataConfig() {
        return this.tvShowScraperMetadataConfig;
    }

    public void setTvShowScraperMetadataConfig(List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig) {
        this.tvShowScraperMetadataConfig.clear();
        this.tvShowScraperMetadataConfig.addAll(tvShowScraperMetadataConfig);
        this.firePropertyChange("scraperMetadataConfig", null, tvShowScraperMetadataConfig);
    }

    public List<TvShowEpisodeScraperMetadataConfig> getEpisodeScraperMetadataConfig() {
        return this.episodeScraperMetadataConfig;
    }

    public void setEpisodeScraperMetadataConfig(List<TvShowEpisodeScraperMetadataConfig> scraperMetadataConfig) {
        this.episodeScraperMetadataConfig.clear();
        this.episodeScraperMetadataConfig.addAll(scraperMetadataConfig);
        this.firePropertyChange("episodeScraperMetadataConfig", null, this.episodeScraperMetadataConfig);
    }

    public void setImageScraperLanguages(List<MediaLanguages> newValue) {
        this.imageScraperLanguages.clear();
        this.imageScraperLanguages.addAll(newValue);
        this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
    }

    public void addImageScraperLanguage(MediaLanguages language) {
        if (!this.imageScraperLanguages.contains((Object)language)) {
            this.imageScraperLanguages.add(language);
            this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
        }
    }

    public void removeImageScraperLanguage(MediaLanguages language) {
        if (this.imageScraperLanguages.remove((Object)language)) {
            this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
        }
    }

    public void swapImageScraperLanguage(int pos1, int pos2) {
        MediaLanguages tmp = this.imageScraperLanguages.get(pos1);
        this.imageScraperLanguages.set(pos1, this.imageScraperLanguages.get(pos2));
        this.imageScraperLanguages.set(pos2, tmp);
        this.firePropertyChange("imageScraperLanguages", null, this.imageScraperLanguages);
    }

    public List<MediaLanguages> getImageScraperLanguages() {
        return this.imageScraperLanguages;
    }

    public MediaLanguages getDefaultImageScraperLanguage() {
        MediaLanguages language = this.scraperLanguage;
        if (!this.imageScraperLanguages.isEmpty()) {
            language = this.imageScraperLanguages.get(0);
        }
        return language;
    }

    public boolean isImageScraperOtherResolutions() {
        return this.imageScraperOtherResolutions;
    }

    public void setImageScraperOtherResolutions(boolean newValue) {
        boolean oldValue = this.imageScraperOtherResolutions;
        this.imageScraperOtherResolutions = newValue;
        this.firePropertyChange("imageScraperOtherResolutions", oldValue, newValue);
    }

    public boolean isImageScraperFallback() {
        return this.imageScraperFallback;
    }

    public void setImageScraperFallback(boolean newValue) {
        boolean oldValue = this.imageScraperFallback;
        this.imageScraperFallback = newValue;
        this.firePropertyChange("imageScraperFallback", oldValue, newValue);
    }

    public boolean isImageScraperPreferFanartWoText() {
        return this.imageScraperPreferFanartWoText;
    }

    public void setImageScraperPreferFanartWoText(boolean newValue) {
        boolean oldValue = this.imageScraperPreferFanartWoText;
        this.imageScraperPreferFanartWoText = newValue;
        this.firePropertyChange("imageScraperPreferFanartWoText", oldValue, newValue);
    }

    public MediaArtwork.PosterSizes getImagePosterSize() {
        return this.imagePosterSize;
    }

    public void setImagePosterSize(MediaArtwork.PosterSizes newValue) {
        MediaArtwork.PosterSizes oldValue = this.imagePosterSize;
        this.imagePosterSize = newValue;
        this.firePropertyChange("imagePosterSize", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.FanartSizes getImageFanartSize() {
        return this.imageFanartSize;
    }

    public void setImageFanartSize(MediaArtwork.FanartSizes newValue) {
        MediaArtwork.FanartSizes oldValue = this.imageFanartSize;
        this.imageFanartSize = newValue;
        this.firePropertyChange("imageFanartSize", (Object)oldValue, (Object)newValue);
    }

    public MediaArtwork.ThumbSizes getImageThumbSize() {
        return this.imageThumbSize;
    }

    public void setImageThumbSize(MediaArtwork.ThumbSizes newValue) {
        MediaArtwork.ThumbSizes oldValue = this.imageThumbSize;
        this.imageThumbSize = newValue;
        this.firePropertyChange("imageThumbSize", (Object)oldValue, (Object)newValue);
    }

    public void addNfoFilename(TvShowNfoNaming filename) {
        if (!this.nfoFilenames.contains(filename)) {
            this.nfoFilenames.add(filename);
            this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
        }
    }

    public void clearNfoFilenames() {
        this.nfoFilenames.clear();
        this.firePropertyChange(NFO_FILENAME, null, this.nfoFilenames);
    }

    public List<TvShowNfoNaming> getNfoFilenames() {
        return Collections.unmodifiableList(this.nfoFilenames);
    }

    public void addPosterFilename(TvShowPosterNaming filename) {
        if (!this.posterFilenames.contains(filename)) {
            this.posterFilenames.add(filename);
            this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
        }
    }

    public void clearPosterFilenames() {
        this.posterFilenames.clear();
        this.firePropertyChange(POSTER_FILENAME, null, this.posterFilenames);
    }

    public List<TvShowPosterNaming> getPosterFilenames() {
        return Collections.unmodifiableList(this.posterFilenames);
    }

    public void addFanartFilename(TvShowFanartNaming filename) {
        if (!this.fanartFilenames.contains(filename)) {
            this.fanartFilenames.add(filename);
            this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
        }
    }

    public void clearFanartFilenames() {
        this.fanartFilenames.clear();
        this.firePropertyChange(FANART_FILENAME, null, this.fanartFilenames);
    }

    public List<TvShowFanartNaming> getFanartFilenames() {
        return Collections.unmodifiableList(this.fanartFilenames);
    }

    public void addExtraFanartFilename(TvShowExtraFanartNaming filename) {
        if (!this.extraFanartFilenames.contains(filename)) {
            this.extraFanartFilenames.add(filename);
            this.firePropertyChange(EXTRAFANART_FILENAME, null, this.extraFanartFilenames);
        }
    }

    public void clearExtraFanartFilenames() {
        this.extraFanartFilenames.clear();
        this.firePropertyChange(EXTRAFANART_FILENAME, null, this.extraFanartFilenames);
    }

    public List<TvShowExtraFanartNaming> getExtraFanartFilenames() {
        return Collections.unmodifiableList(this.extraFanartFilenames);
    }

    public void addBannerFilename(TvShowBannerNaming filename) {
        if (!this.bannerFilenames.contains(filename)) {
            this.bannerFilenames.add(filename);
            this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
        }
    }

    public void clearBannerFilenames() {
        this.bannerFilenames.clear();
        this.firePropertyChange(BANNER_FILENAME, null, this.bannerFilenames);
    }

    public List<TvShowBannerNaming> getBannerFilenames() {
        return Collections.unmodifiableList(this.bannerFilenames);
    }

    public void addDiscartFilename(TvShowDiscartNaming filename) {
        if (!this.discartFilenames.contains(filename)) {
            this.discartFilenames.add(filename);
            this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
        }
    }

    public void clearDiscartFilenames() {
        this.discartFilenames.clear();
        this.firePropertyChange(DISCART_FILENAME, null, this.discartFilenames);
    }

    public List<TvShowDiscartNaming> getDiscartFilenames() {
        return Collections.unmodifiableList(this.discartFilenames);
    }

    public void addClearartFilename(TvShowClearartNaming filename) {
        if (!this.clearartFilenames.contains(filename)) {
            this.clearartFilenames.add(filename);
            this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
        }
    }

    public void clearClearartFilenames() {
        this.clearartFilenames.clear();
        this.firePropertyChange(CLEARART_FILENAME, null, this.clearartFilenames);
    }

    public List<TvShowClearartNaming> getClearartFilenames() {
        return Collections.unmodifiableList(this.clearartFilenames);
    }

    public void addThumbFilename(TvShowThumbNaming filename) {
        if (!this.thumbFilenames.contains(filename)) {
            this.thumbFilenames.add(filename);
            this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
        }
    }

    public void clearThumbFilenames() {
        this.thumbFilenames.clear();
        this.firePropertyChange(THUMB_FILENAME, null, this.thumbFilenames);
    }

    public List<TvShowThumbNaming> getThumbFilenames() {
        return Collections.unmodifiableList(this.thumbFilenames);
    }

    public void addCharacterartFilename(TvShowCharacterartNaming filename) {
        if (!this.characterartFilenames.contains(filename)) {
            this.characterartFilenames.add(filename);
            this.firePropertyChange(CHARACTERART_FILENAME, null, this.characterartFilenames);
        }
    }

    public void clearCharacterartFilenames() {
        this.characterartFilenames.clear();
    }

    public List<TvShowCharacterartNaming> getCharacterartFilenames() {
        return this.characterartFilenames;
    }

    public void addKeyartFilename(TvShowKeyartNaming filename) {
        if (!this.keyartFilenames.contains(filename)) {
            this.keyartFilenames.add(filename);
            this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
        }
    }

    public void clearKeyartFilenames() {
        this.keyartFilenames.clear();
        this.firePropertyChange(KEYART_FILENAME, null, this.keyartFilenames);
    }

    public List<TvShowKeyartNaming> getKeyartFilenames() {
        return this.keyartFilenames;
    }

    public void addClearlogoFilename(TvShowClearlogoNaming filename) {
        if (!this.clearlogoFilenames.contains(filename)) {
            this.clearlogoFilenames.add(filename);
            this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
        }
    }

    public void clearClearlogoFilenames() {
        this.clearlogoFilenames.clear();
        this.firePropertyChange(CLEARLOGO_FILENAME, null, this.clearlogoFilenames);
    }

    public List<TvShowClearlogoNaming> getClearlogoFilenames() {
        return Collections.unmodifiableList(this.clearlogoFilenames);
    }

    public void addSeasonNfoFilename(TvShowSeasonNfoNaming filename) {
        if (!this.seasonNfoFilenames.contains(filename)) {
            this.seasonNfoFilenames.add(filename);
            this.firePropertyChange(SEASON_NFO_FILENAME, null, this.seasonNfoFilenames);
        }
    }

    public void clearSeasonNfoFilenames() {
        this.seasonNfoFilenames.clear();
        this.firePropertyChange(SEASON_NFO_FILENAME, null, this.seasonNfoFilenames);
    }

    public List<TvShowSeasonNfoNaming> getSeasonNfoFilenames() {
        return Collections.unmodifiableList(this.seasonNfoFilenames);
    }

    public void addSeasonPosterFilename(TvShowSeasonPosterNaming filename) {
        if (!this.seasonPosterFilenames.contains(filename)) {
            this.seasonPosterFilenames.add(filename);
            this.firePropertyChange(SEASON_POSTER_FILENAME, null, this.seasonPosterFilenames);
        }
    }

    public void clearSeasonPosterFilenames() {
        this.seasonPosterFilenames.clear();
        this.firePropertyChange(SEASON_POSTER_FILENAME, null, this.seasonPosterFilenames);
    }

    public List<TvShowSeasonPosterNaming> getSeasonPosterFilenames() {
        return Collections.unmodifiableList(this.seasonPosterFilenames);
    }

    public void addSeasonFanartFilename(TvShowSeasonFanartNaming filename) {
        if (!this.seasonFanartFilenames.contains(filename)) {
            this.seasonFanartFilenames.add(filename);
            this.firePropertyChange(SEASON_FANART_FILENAME, null, this.seasonFanartFilenames);
        }
    }

    public void clearSeasonFanartFilenames() {
        this.seasonFanartFilenames.clear();
        this.firePropertyChange(SEASON_FANART_FILENAME, null, this.seasonFanartFilenames);
    }

    public List<TvShowSeasonFanartNaming> getSeasonFanartFilenames() {
        return Collections.unmodifiableList(this.seasonFanartFilenames);
    }

    public void addSeasonBannerFilename(TvShowSeasonBannerNaming filename) {
        if (!this.seasonBannerFilenames.contains(filename)) {
            this.seasonBannerFilenames.add(filename);
            this.firePropertyChange(SEASON_BANNER_FILENAME, null, this.seasonBannerFilenames);
        }
    }

    public void clearSeasonBannerFilenames() {
        this.seasonBannerFilenames.clear();
        this.firePropertyChange(SEASON_BANNER_FILENAME, null, this.seasonBannerFilenames);
    }

    public List<TvShowSeasonBannerNaming> getSeasonBannerFilenames() {
        return Collections.unmodifiableList(this.seasonBannerFilenames);
    }

    public void addSeasonThumbFilename(TvShowSeasonThumbNaming filename) {
        if (!this.seasonThumbFilenames.contains(filename)) {
            this.seasonThumbFilenames.add(filename);
            this.firePropertyChange(SEASON_THUMB_FILENAME, null, this.seasonThumbFilenames);
        }
    }

    public void clearSeasonThumbFilenames() {
        this.seasonThumbFilenames.clear();
        this.firePropertyChange(SEASON_THUMB_FILENAME, null, this.seasonThumbFilenames);
    }

    public List<TvShowSeasonThumbNaming> getSeasonThumbFilenames() {
        return Collections.unmodifiableList(this.seasonThumbFilenames);
    }

    public void addEpisodeNfoFilename(TvShowEpisodeNfoNaming filename) {
        if (!this.episodeNfoFilenames.contains(filename)) {
            this.episodeNfoFilenames.add(filename);
            this.firePropertyChange(EPISODE_NFO_FILENAME, null, this.episodeNfoFilenames);
        }
    }

    public void clearEpisodeNfoFilenames() {
        this.episodeNfoFilenames.clear();
        this.firePropertyChange(EPISODE_NFO_FILENAME, null, this.episodeNfoFilenames);
    }

    public List<TvShowEpisodeNfoNaming> getEpisodeNfoFilenames() {
        return Collections.unmodifiableList(this.episodeNfoFilenames);
    }

    public void clearTvShowCheckMetadata() {
        this.tvShowCheckMetadata.clear();
        this.firePropertyChange(TVSHOW_CHECK_METADATA, null, this.tvShowCheckMetadata);
    }

    public List<TvShowScraperMetadataConfig> getTvShowCheckMetadata() {
        return Collections.unmodifiableList(this.tvShowCheckMetadata);
    }

    public void addTvShowCheckMetadata(TvShowScraperMetadataConfig config) {
        if (!this.tvShowCheckMetadata.contains(config)) {
            this.tvShowCheckMetadata.add(config);
            this.firePropertyChange(TVSHOW_CHECK_METADATA, null, this.tvShowCheckMetadata);
        }
    }

    public void setTvShowDisplayAllMissingMetadata(boolean newValue) {
        boolean oldValue = this.tvShowDisplayAllMissingMetadata;
        this.tvShowDisplayAllMissingMetadata = newValue;
        this.firePropertyChange("tvShowDisplayAllMissingMetadata", oldValue, newValue);
    }

    public boolean isTvShowDisplayAllMissingMetadata() {
        return this.tvShowDisplayAllMissingMetadata;
    }

    public void clearTvShowCheckArtwork() {
        this.tvShowCheckArtwork.clear();
        this.firePropertyChange(TVSHOW_CHECK_ARTWORK, null, this.tvShowCheckArtwork);
    }

    public List<TvShowScraperMetadataConfig> getTvShowCheckArtwork() {
        return Collections.unmodifiableList(this.tvShowCheckArtwork);
    }

    public void addTvShowCheckArtwork(TvShowScraperMetadataConfig config) {
        if (!this.tvShowCheckArtwork.contains(config)) {
            this.tvShowCheckArtwork.add(config);
            this.firePropertyChange(TVSHOW_CHECK_ARTWORK, null, this.tvShowCheckArtwork);
        }
    }

    public void removeTvShowCheckArtwork(TvShowScraperMetadataConfig config) {
        if (this.tvShowCheckArtwork.remove(config)) {
            this.firePropertyChange(TVSHOW_CHECK_ARTWORK, null, this.tvShowCheckArtwork);
        }
    }

    public void setTvShowDisplayAllMissingArtwork(boolean newValue) {
        boolean oldValue = this.tvShowDisplayAllMissingArtwork;
        this.tvShowDisplayAllMissingArtwork = newValue;
        this.firePropertyChange("tvShowDisplayAllMissingArtwork", oldValue, newValue);
    }

    public boolean isTvShowDisplayAllMissingArtwork() {
        return this.tvShowDisplayAllMissingArtwork;
    }

    public void clearSeasonCheckArtwork() {
        this.seasonCheckArtwork.clear();
        this.firePropertyChange(SEASON_CHECK_ARTWORK, null, this.seasonCheckArtwork);
    }

    public List<TvShowScraperMetadataConfig> getSeasonCheckArtwork() {
        return Collections.unmodifiableList(this.seasonCheckArtwork);
    }

    public void addSeasonCheckArtwork(TvShowScraperMetadataConfig config) {
        if (!this.seasonCheckArtwork.contains(config)) {
            this.seasonCheckArtwork.add(config);
            this.firePropertyChange(SEASON_CHECK_ARTWORK, null, this.seasonCheckArtwork);
        }
    }

    public void setSeasonDisplayAllMissingArtwork(boolean newValue) {
        boolean oldValue = this.seasonDisplayAllMissingArtwork;
        this.seasonDisplayAllMissingArtwork = newValue;
        this.firePropertyChange("seasonDisplayAllMissingArtwork", oldValue, newValue);
    }

    public boolean isSeasonDisplayAllMissingArtwork() {
        return this.seasonDisplayAllMissingArtwork;
    }

    public void clearEpisodeCheckMetadata() {
        this.episodeCheckMetadata.clear();
        this.firePropertyChange(EPISODE_CHECK_METADATA, null, this.episodeCheckMetadata);
    }

    public List<TvShowEpisodeScraperMetadataConfig> getEpisodeCheckMetadata() {
        return Collections.unmodifiableList(this.episodeCheckMetadata);
    }

    public void addEpisodeCheckMetadata(TvShowEpisodeScraperMetadataConfig config) {
        if (!this.episodeCheckMetadata.contains(config)) {
            this.episodeCheckMetadata.add(config);
            this.firePropertyChange(EPISODE_CHECK_METADATA, null, this.episodeCheckMetadata);
        }
    }

    public void setEpisodeDisplayAllMissingMetadata(boolean newValue) {
        boolean oldValue = this.episodeDisplayAllMissingMetadata;
        this.episodeDisplayAllMissingMetadata = newValue;
        this.firePropertyChange("episodeDisplayAllMissingMetadata", oldValue, newValue);
    }

    public boolean isEpisodeDisplayAllMissingMetadata() {
        return this.episodeDisplayAllMissingMetadata;
    }

    public void setEpisodeSpecialsCheckMissingMetadata(boolean newValue) {
        boolean oldValue = this.episodeSpecialsCheckMissingMetadata;
        this.episodeSpecialsCheckMissingMetadata = newValue;
        this.firePropertyChange("episodeSpecialsCheckMissingMetadata", oldValue, newValue);
    }

    public boolean isEpisodeSpecialsCheckMissingMetadata() {
        return this.episodeSpecialsCheckMissingMetadata;
    }

    public void clearEpisodeCheckArtwork() {
        this.episodeCheckArtwork.clear();
        this.firePropertyChange(EPISODE_CHECK_ARTWORK, null, this.episodeCheckArtwork);
    }

    public List<TvShowEpisodeScraperMetadataConfig> getEpisodeCheckArtwork() {
        return Collections.unmodifiableList(this.episodeCheckArtwork);
    }

    public void addEpisodeCheckArtwork(TvShowEpisodeScraperMetadataConfig config) {
        if (!this.episodeCheckArtwork.contains(config)) {
            this.episodeCheckArtwork.add(config);
            this.firePropertyChange(EPISODE_CHECK_ARTWORK, null, this.episodeCheckArtwork);
        }
    }

    public void setEpisodeDisplayAllMissingArtwork(boolean newValue) {
        boolean oldValue = this.episodeDisplayAllMissingArtwork;
        this.episodeDisplayAllMissingArtwork = newValue;
        this.firePropertyChange("episodeDisplayAllMissingArtwork", oldValue, newValue);
    }

    public boolean isEpisodeDisplayAllMissingArtwork() {
        return this.episodeDisplayAllMissingArtwork;
    }

    public void setEpisodeSpecialsCheckMissingArtwork(boolean newValue) {
        boolean oldValue = this.episodeSpecialsCheckMissingArtwork;
        this.episodeSpecialsCheckMissingArtwork = newValue;
        this.firePropertyChange("episodeSpecialsCheckMissingArtwork", oldValue, newValue);
    }

    public boolean isEpisodeSpecialsCheckMissingArtwork() {
        return this.episodeSpecialsCheckMissingArtwork;
    }

    public CertificationStyle getCertificationStyle() {
        return this.certificationStyle;
    }

    public void setCertificationStyle(CertificationStyle newValue) {
        CertificationStyle oldValue = this.certificationStyle;
        this.certificationStyle = newValue;
        this.firePropertyChange("certificationStyle", (Object)oldValue, (Object)newValue);
    }

    public boolean isSkipFoldersWithNomedia() {
        return this.skipFoldersWithNomedia;
    }

    public void setSkipFoldersWithNomedia(boolean newValue) {
        boolean oldValue = this.skipFoldersWithNomedia;
        this.skipFoldersWithNomedia = newValue;
        this.firePropertyChange("skipFoldersWithNomedia", oldValue, newValue);
    }

    public TvShowConnectors getTvShowConnector() {
        return this.tvShowConnector;
    }

    public void setTvShowConnector(TvShowConnectors newValue) {
        TvShowConnectors oldValue = this.tvShowConnector;
        this.tvShowConnector = newValue;
        this.firePropertyChange("tvShowConnector", (Object)oldValue, (Object)newValue);
    }

    public boolean isWriteCleanNfo() {
        return this.writeCleanNfo;
    }

    public void setWriteCleanNfo(boolean newValue) {
        boolean oldValue = this.writeCleanNfo;
        this.writeCleanNfo = newValue;
        this.firePropertyChange("writeCleanNfo", oldValue, newValue);
    }

    public boolean isNfoWriteDateAdded() {
        return this.nfoWriteDateAdded;
    }

    public void setNfoWriteDateAdded(boolean newValue) {
        boolean oldValue = this.nfoWriteDateAdded;
        this.nfoWriteDateAdded = newValue;
        this.firePropertyChange("nfoWriteDateAdded", oldValue, newValue);
    }

    public DateField getNfoDateAddedField() {
        return this.nfoDateAddedField;
    }

    public void setNfoDateAddedField(DateField newValue) {
        DateField oldValue = this.nfoDateAddedField;
        this.nfoDateAddedField = newValue;
        this.firePropertyChange("nfoDateAddedField", (Object)oldValue, (Object)newValue);
    }

    public Locale getNfoLanguage() {
        return this.nfoLanguage;
    }

    public void setNfoLanguage(Locale newValue) {
        Locale oldValue = this.nfoLanguage;
        this.nfoLanguage = newValue;
        this.firePropertyChange("nfoLanguage", oldValue, newValue);
    }

    public boolean isNfoWriteEpisodeguide() {
        return this.nfoWriteEpisodeguide;
    }

    public void setNfoWriteEpisodeguide(boolean newValue) {
        boolean oldValue = this.nfoWriteEpisodeguide;
        this.nfoWriteEpisodeguide = newValue;
        this.firePropertyChange("nfoWriteEpisodeguide", oldValue, newValue);
    }

    public boolean isNfoWriteNewEpisodeguideStyle() {
        return this.nfoWriteNewEpisodeguideStyle;
    }

    public void setNfoWriteNewEpisodeguideStyle(boolean newValue) {
        boolean oldValue = this.nfoWriteNewEpisodeguideStyle;
        this.nfoWriteNewEpisodeguideStyle = newValue;
        this.firePropertyChange("nfoWriteNewEpisodeguideStyle", oldValue, newValue);
    }

    public boolean isNfoWriteDateEnded() {
        return this.nfoWriteDateEnded;
    }

    public void setNfoWriteDateEnded(boolean newValue) {
        boolean oldValue = this.nfoWriteDateEnded;
        this.nfoWriteDateEnded = newValue;
        this.firePropertyChange("nfoWriteDateEnded", oldValue, newValue);
    }

    public boolean isNfoWriteAllActors() {
        return this.nfoWriteAllActors;
    }

    public void setNfoWriteAllActors(boolean newValue) {
        boolean oldValue = this.nfoWriteAllActors;
        this.nfoWriteAllActors = newValue;
        this.firePropertyChange("nfoWriteAllActors", oldValue, newValue);
    }

    public boolean isNfoWriteSingleStudio() {
        return this.nfoWriteSingleStudio;
    }

    public void setNfoWriteSingleStudio(boolean newValue) {
        boolean oldValue = this.nfoWriteSingleStudio;
        this.nfoWriteSingleStudio = newValue;
        this.firePropertyChange("nfoWriteSingleStudio", oldValue, newValue);
    }

    public boolean isNfoWriteLockdata() {
        return this.nfoWriteLockdata;
    }

    public void setNfoWriteLockdata(boolean newValue) {
        boolean oldValue = this.nfoWriteLockdata;
        this.nfoWriteLockdata = newValue;
        this.firePropertyChange("nfoWriteLockdata", oldValue, newValue);
    }

    public boolean isNfoWriteTrailer() {
        return this.nfoWriteTrailer;
    }

    public void setNfoWriteTrailer(boolean newValue) {
        boolean oldValue = this.nfoWriteTrailer;
        this.nfoWriteTrailer = newValue;
        this.firePropertyChange("nfoWriteTrailer", oldValue, newValue);
    }

    public boolean isNfoWriteFileinfo() {
        return this.nfoWriteFileinfo;
    }

    public void setNfoWriteFileinfo(boolean newValue) {
        boolean oldValue = this.nfoWriteFileinfo;
        this.nfoWriteFileinfo = newValue;
        this.firePropertyChange("nfoWriteFileinfo", oldValue, newValue);
    }

    public boolean isWriteActorImages() {
        return this.writeActorImages;
    }

    public void setWriteActorImages(boolean newValue) {
        boolean oldValue = this.writeActorImages;
        this.writeActorImages = newValue;
        this.firePropertyChange("writeActorImages", oldValue, newValue);
    }

    public void setRenameAfterScrape(boolean newValue) {
        boolean oldValue = this.renameAfterScrape;
        this.renameAfterScrape = newValue;
        this.firePropertyChange("renameAfterScrape", oldValue, newValue);
    }

    public boolean isRenameAfterScrape() {
        return this.renameAfterScrape;
    }

    public int getImageExtraFanartCount() {
        return this.imageExtraFanartCount;
    }

    public void setImageExtraFanartCount(int newValue) {
        int oldValue = this.imageExtraFanartCount;
        this.imageExtraFanartCount = newValue;
        this.firePropertyChange("imageExtraFanartCount", oldValue, newValue);
    }

    public boolean isImageExtraFanart() {
        return this.imageExtraFanart;
    }

    public void setImageExtraFanart(boolean newValue) {
        boolean oldValue = this.imageExtraFanart;
        this.imageExtraFanart = newValue;
        this.firePropertyChange("imageExtraFanart", oldValue, newValue);
    }

    public boolean isImageEpisodeScrapeAllSources() {
        return this.imageEpisodeScrapeAllSources;
    }

    public void setImageEpisodeScrapeAllSources(boolean newValue) {
        boolean oldValue = this.imageEpisodeScrapeAllSources;
        this.imageEpisodeScrapeAllSources = newValue;
        this.firePropertyChange("imageEpisodeScrapeAllSources", oldValue, newValue);
    }

    public boolean getCapitalWordsInTitles() {
        return this.capitalWordsinTitles;
    }

    public void setCapitalWordsInTitles(boolean newValue) {
        boolean oldValue = this.capitalWordsinTitles;
        this.capitalWordsinTitles = newValue;
        this.firePropertyChange("capitalWordsInTitles", oldValue, newValue);
    }

    public boolean isShowTvShowTableTooltips() {
        return this.showTvShowTableTooltips;
    }

    public void setShowTvShowTableTooltips(boolean newValue) {
        boolean oldValue = this.showTvShowTableTooltips;
        this.showTvShowTableTooltips = newValue;
        this.firePropertyChange("showTvShowTableTooltips", oldValue, newValue);
    }

    public boolean isSeasonArtworkFallback() {
        return this.seasonArtworkFallback;
    }

    public void setSeasonArtworkFallback(boolean newValue) {
        boolean oldValue = this.seasonArtworkFallback;
        this.seasonArtworkFallback = newValue;
        this.firePropertyChange("seasonArtworkFallback", oldValue, newValue);
    }

    public void setUiFilters(List<AbstractSettings.UIFilters> filters) {
        this.uiFilters.clear();
        this.uiFilters.addAll(filters);
        this.firePropertyChange("uiFilters", null, this.uiFilters);
    }

    public List<AbstractSettings.UIFilters> getUiFilters() {
        if (this.storeUiFilters) {
            return this.uiFilters;
        }
        return Collections.emptyList();
    }

    public void setStoreUiFilters(boolean newValue) {
        boolean oldValue = this.storeUiFilters;
        this.storeUiFilters = newValue;
        this.firePropertyChange("storeUiFilters", oldValue, newValue);
    }

    public boolean isStoreUiFilters() {
        return this.storeUiFilters;
    }

    public void addPostProcessTvShow(PostProcess newProcess) {
        this.postProcessTvShow.add(newProcess);
        this.firePropertyChange("postProcessTvShow", null, this.postProcessTvShow);
    }

    public void removePostProcessTvShow(PostProcess process) {
        this.postProcessTvShow.remove(process);
        this.firePropertyChange("postProcessTvShow", null, this.postProcessTvShow);
    }

    public List<PostProcess> getPostProcessTvShow() {
        return this.postProcessTvShow;
    }

    public void setPostProcessTvShow(List<PostProcess> newValues) {
        this.postProcessTvShow.clear();
        this.postProcessTvShow.addAll(newValues);
        this.firePropertyChange("postProcessTvShow", null, this.postProcessTvShow);
    }

    public void addPostProcessEpisode(PostProcess newProcess) {
        this.postProcessEpisode.add(newProcess);
        this.firePropertyChange("postProcessEpisode", null, this.postProcessEpisode);
    }

    public void removePostProcessEpisode(PostProcess process) {
        this.postProcessEpisode.remove(process);
        this.firePropertyChange("postProcessEpisode", null, this.postProcessEpisode);
    }

    public List<PostProcess> getPostProcessEpisode() {
        return this.postProcessEpisode;
    }

    public void setPostProcessEpisode(List<PostProcess> newValues) {
        this.postProcessEpisode.clear();
        this.postProcessEpisode.addAll(newValues);
        this.firePropertyChange("postProcessEpisode", null, this.postProcessEpisode);
    }

    public void setUniversalFilterFields(List<AbstractSettings.UniversalFilterFields> fields) {
        this.universalFilterFields.clear();
        this.universalFilterFields.addAll(fields);
        this.firePropertyChange("universalFilterFields", null, this.universalFilterFields);
    }

    public List<AbstractSettings.UniversalFilterFields> getUniversalFilterFields() {
        return this.universalFilterFields;
    }

    public boolean isDoNotOverwriteExistingData() {
        return this.doNotOverwriteExistingData;
    }

    public void setDoNotOverwriteExistingData(boolean newValue) {
        boolean oldValue = this.doNotOverwriteExistingData;
        this.doNotOverwriteExistingData = newValue;
        this.firePropertyChange("doNotOverwriteExistingData", oldValue, newValue);
    }

    public boolean isFetchAllRatings() {
        return this.fetchAllRatings;
    }

    public void setFetchAllRatings(boolean newValue) {
        boolean oldValue = this.fetchAllRatings;
        this.fetchAllRatings = newValue;
        this.firePropertyChange("fetchAllRatings", oldValue, newValue);
    }

    public void addShowTvShowArtworkTypes(MediaFileType type) {
        if (!this.showTvShowArtworkTypes.contains((Object)type)) {
            this.showTvShowArtworkTypes.add(type);
            this.firePropertyChange("showTvShowArtworkTypes", null, this.showTvShowArtworkTypes);
        }
    }

    public void setShowTvShowArtworkTypes(List<MediaFileType> newTypes) {
        this.showTvShowArtworkTypes.clear();
        this.showTvShowArtworkTypes.addAll(newTypes);
        this.firePropertyChange("showTvShowArtworkTypes", null, this.showTvShowArtworkTypes);
    }

    public List<MediaFileType> getShowTvShowArtworkTypes() {
        return Collections.unmodifiableList(this.showTvShowArtworkTypes);
    }

    public void addShowSeasonArtworkTypes(MediaFileType type) {
        if (!this.showSeasonArtworkTypes.contains((Object)type)) {
            this.showSeasonArtworkTypes.add(type);
            this.firePropertyChange("showSeasonArtworkTypes", null, this.showSeasonArtworkTypes);
        }
    }

    public void setShowSeasonArtworkTypes(List<MediaFileType> newTypes) {
        this.showSeasonArtworkTypes.clear();
        this.showSeasonArtworkTypes.addAll(newTypes);
        this.firePropertyChange("showSeasonArtworkTypes", null, this.showSeasonArtworkTypes);
    }

    public List<MediaFileType> getShowSeasonArtworkTypes() {
        return Collections.unmodifiableList(this.showSeasonArtworkTypes);
    }

    public void addShowEpisodeArtworkTypes(MediaFileType type) {
        if (!this.showEpisodeArtworkTypes.contains((Object)type)) {
            this.showEpisodeArtworkTypes.add(type);
            this.firePropertyChange("showEpisodeArtworkTypes", null, this.showEpisodeArtworkTypes);
        }
    }

    public void setShowEpisodeArtworkTypes(List<MediaFileType> newTypes) {
        this.showEpisodeArtworkTypes.clear();
        this.showEpisodeArtworkTypes.addAll(newTypes);
        this.firePropertyChange("showEpisodeArtworkTypes", null, this.showEpisodeArtworkTypes);
    }

    public List<MediaFileType> getShowEpisodeArtworkTypes() {
        return Collections.unmodifiableList(this.showEpisodeArtworkTypes);
    }

    public boolean isResetNewFlagOnUds() {
        return this.resetNewFlagOnUds;
    }

    public void setResetNewFlagOnUds(boolean newValue) {
        boolean oldValue = this.resetNewFlagOnUds;
        this.resetNewFlagOnUds = newValue;
        this.firePropertyChange("resetNewFlagOnUds", oldValue, newValue);
    }

    public List<String> getRatingSources() {
        return this.ratingSources;
    }

    public void setRatingSources(List<String> newValue) {
        this.ratingSources.clear();
        this.ratingSources.addAll(newValue);
        this.firePropertyChange("ratingSources", null, this.ratingSources);
    }

    public void addRatingSource(String ratingSource) {
        if (!this.ratingSources.contains(ratingSource)) {
            this.ratingSources.add(ratingSource);
            this.firePropertyChange("ratingSources", null, this.ratingSources);
        }
    }

    public void removeRatingSource(String ratingSource) {
        if (this.ratingSources.remove(ratingSource)) {
            this.firePropertyChange("ratingSources", null, this.ratingSources);
        }
    }

    public void swapRatingSources(int pos1, int pos2) {
        String tmp = this.ratingSources.get(pos1);
        this.ratingSources.set(pos1, this.ratingSources.get(pos2));
        this.ratingSources.set(pos2, tmp);
        this.firePropertyChange("ratingSources", null, this.ratingSources);
    }
}

