/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class TvShowNfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowNfoParser.class);
    private static final List<String> IGNORE = Arrays.asList("epbookmark", "resume");
    private Element root;
    private final List<String> supportedElements = new ArrayList<String>();
    public String title = "";
    public String originalTitle = "";
    public String sortTitle = "";
    public String showTitle = "";
    public int year = -1;
    public int top250 = 0;
    public String plot = "";
    public int runtime = 0;
    public MediaCertification certification = MediaCertification.UNKNOWN;
    public Date releaseDate = null;
    public MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    public boolean watched = false;
    public int playcount = 0;
    public String userNote = "";
    public MediaEpisodeGroup episodeGroup = MediaEpisodeGroup.DEFAULT_AIRED;
    public Map<String, Object> ids = new HashMap<String, Object>();
    public Map<String, Rating> ratings = new HashMap<String, Rating>();
    public List<String> posters = new ArrayList<String>();
    public Map<Integer, String> seasonTitles = new HashMap<Integer, String>();
    public Map<Integer, List<String>> seasonPosters = new HashMap<Integer, List<String>>();
    public Map<Integer, List<String>> seasonBanners = new HashMap<Integer, List<String>>();
    public Map<Integer, List<String>> seasonThumbs = new HashMap<Integer, List<String>>();
    public List<String> banners = new ArrayList<String>();
    public List<String> cleararts = new ArrayList<String>();
    public List<String> clearlogos = new ArrayList<String>();
    public List<String> discarts = new ArrayList<String>();
    public List<String> thumbs = new ArrayList<String>();
    public List<String> keyarts = new ArrayList<String>();
    public List<String> logos = new ArrayList<String>();
    public List<String> characterarts = new ArrayList<String>();
    public List<String> fanarts = new ArrayList<String>();
    public List<MediaGenres> genres = new ArrayList<MediaGenres>();
    public List<String> studios = new ArrayList<String>();
    public List<String> countries = new ArrayList<String>();
    public List<String> tags = new ArrayList<String>();
    public List<Person> actors = new ArrayList<Person>();
    public List<MediaEpisodeGroup> episodeGroups = new ArrayList<MediaEpisodeGroup>();
    public List<String> unsupportedElements = new ArrayList<String>();
    public String outline = "";
    public String tagline = "";
    public String trailer = "";
    public Date lastplayed = null;
    public String code = "";
    public Date dateadded = null;
    public String episodeguide = "";
    public String enddate = "";

    private TvShowNfoParser(Document document) {
        Elements elements = document.select("tvshow");
        if (elements.isEmpty()) {
            return;
        }
        document.outputSettings().prettyPrint(false);
        this.root = (Element)elements.get(0);
        this.parseTag(TvShowNfoParser::parseTitle);
        this.parseTag(TvShowNfoParser::parseOriginalTitle);
        this.parseTag(TvShowNfoParser::parseSortTitle);
        this.parseTag(TvShowNfoParser::parseShowTitle);
        this.parseTag(TvShowNfoParser::parseRatingAndVotes);
        this.parseTag(TvShowNfoParser::parseYear);
        this.parseTag(TvShowNfoParser::parsePlot);
        this.parseTag(TvShowNfoParser::parseOutline);
        this.parseTag(TvShowNfoParser::parseRuntime);
        this.parseTag(TvShowNfoParser::parseStatus);
        this.parseTag(TvShowNfoParser::parsePosters);
        this.parseTag(TvShowNfoParser::parseBanners);
        this.parseTag(TvShowNfoParser::parseCleararts);
        this.parseTag(TvShowNfoParser::parseClearlogos);
        this.parseTag(TvShowNfoParser::parseDiscarts);
        this.parseTag(TvShowNfoParser::parseThumbs);
        this.parseTag(TvShowNfoParser::parseKeyarts);
        this.parseTag(TvShowNfoParser::parseLogos);
        this.parseTag(TvShowNfoParser::parseCharacterarts);
        this.parseTag(TvShowNfoParser::parseFanarts);
        this.parseTag(TvShowNfoParser::parseSeasonArtwork);
        this.parseTag(TvShowNfoParser::parseSeasonNames);
        this.parseTag(TvShowNfoParser::parseCertification);
        this.parseTag(TvShowNfoParser::parseIds);
        this.parseTag(TvShowNfoParser::parseReleaseDate);
        this.parseTag(TvShowNfoParser::parseWatchedAndPlaycount);
        this.parseTag(TvShowNfoParser::parseGenres);
        this.parseTag(TvShowNfoParser::parseStudios);
        this.parseTag(TvShowNfoParser::parseCountries);
        this.parseTag(TvShowNfoParser::parseTags);
        this.parseTag(TvShowNfoParser::parseActors);
        this.parseTag(TvShowNfoParser::parseTrailer);
        this.parseTag(TvShowNfoParser::parseTagline);
        this.parseTag(TvShowNfoParser::parseTop250);
        this.parseTag(TvShowNfoParser::parseLastplayed);
        this.parseTag(TvShowNfoParser::parseCode);
        this.parseTag(TvShowNfoParser::parseDateadded);
        this.parseTag(TvShowNfoParser::parseEpisodeguide);
        this.parseTag(TvShowNfoParser::parseEnddate);
        this.parseTag(TvShowNfoParser::parseUserNote);
        this.parseTag(TvShowNfoParser::parseEpisodeGroups);
        this.parseTag(TvShowNfoParser::findUnsupportedElements);
    }

    private Void parseTag(Function<TvShowNfoParser, Void> function) {
        try {
            function.apply(this);
        }
        catch (Exception e) {
            LOGGER.warn("problem parsing tag (line {}): {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
        }
        return null;
    }

    public static TvShowNfoParser parseNfo(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            TvShowNfoParser tvShowNfoParser = new TvShowNfoParser(Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
            return tvShowNfoParser;
        }
    }

    public static TvShowNfoParser parseNfo(String content) {
        return new TvShowNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        return StringUtils.isNotBlank((CharSequence)this.title);
    }

    private Element getSingleElement(Element parent, String tag) {
        Elements elements = parent.select(parent.tagName() + " > " + tag);
        if (elements.size() != 1) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Void parseTitle() {
        this.supportedElements.add("title");
        Element element = this.getSingleElement(this.root, "title");
        if (element != null) {
            this.title = element.ownText();
        }
        return null;
    }

    private Void parseOriginalTitle() {
        this.supportedElements.add("originaltitle");
        Element element = this.getSingleElement(this.root, "originaltitle");
        if (element != null) {
            this.originalTitle = element.ownText();
        }
        return null;
    }

    private Void parseSortTitle() {
        this.supportedElements.add("sorttitle");
        Element element = this.getSingleElement(this.root, "sorttitle");
        if (element != null) {
            this.sortTitle = element.ownText();
        }
        return null;
    }

    private Void parseShowTitle() {
        this.supportedElements.add("showtitle");
        Element element = this.getSingleElement(this.root, "showtitle");
        if (element != null) {
            this.showTitle = element.ownText();
        }
        return null;
    }

    private Void parseRatingAndVotes() {
        Rating r;
        this.supportedElements.add("rating");
        this.supportedElements.add("userrating");
        this.supportedElements.add("ratings");
        this.supportedElements.add("votes");
        Element element = this.getSingleElement(this.root, "rating");
        if (element != null) {
            r = new Rating();
            r.id = "default";
            try {
                r.rating = Float.parseFloat(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            element = this.getSingleElement(this.root, "votes");
            if (element != null) {
                try {
                    r.votes = MetadataUtil.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (r.rating > 0.0f) {
                this.ratings.put(r.id, r);
            }
        }
        if ((element = this.getSingleElement(this.root, "userrating")) != null) {
            try {
                r = new Rating();
                r.id = "user";
                r.rating = Float.parseFloat(element.ownText());
                if (r.rating > 0.0f) {
                    this.ratings.put(r.id, r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "ratings")) != null) {
            for (Element ratingChild : element.select(element.tagName() + " > rating")) {
                Rating r2 = new Rating();
                r2.id = ratingChild.attr("name");
                if ("themoviedb".equals(r2.id)) {
                    r2.id = "tmdb";
                } else if ("rottenTomatoes".equals(r2.id)) {
                    r2.id = "tomatometerallcritics";
                } else if ("metascore".equals(r2.id)) {
                    r2.id = "metacritic";
                }
                try {
                    r2.maxValue = MetadataUtil.parseInt(ratingChild.attr("max"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (Element child : ratingChild.children()) {
                    switch (child.tagName()) {
                        case "value": {
                            try {
                                r2.rating = Float.parseFloat(child.ownText());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "votes": {
                            try {
                                r2.votes = MetadataUtil.parseInt(child.ownText());
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)r2.id) || !(r2.rating > 0.0f)) continue;
                this.ratings.put(r2.id, r2);
            }
        }
        return null;
    }

    private Void parseYear() {
        this.supportedElements.add("year");
        Element element = this.getSingleElement(this.root, "year");
        if (element != null) {
            try {
                this.year = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseTop250() {
        this.supportedElements.add("top250");
        Element element = this.getSingleElement(this.root, "top250");
        if (element != null) {
            try {
                this.top250 = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parsePlot() {
        this.supportedElements.add("plot");
        Element element = this.getSingleElement(this.root, "plot");
        if (element != null) {
            this.plot = element.wholeText();
        }
        return null;
    }

    private Void parseOutline() {
        this.supportedElements.add("outline");
        Element element = this.getSingleElement(this.root, "outline");
        if (element != null) {
            this.outline = element.wholeText();
        }
        return null;
    }

    private Void parseTagline() {
        this.supportedElements.add("tagline");
        Element element = this.getSingleElement(this.root, "tagline");
        if (element != null) {
            this.tagline = element.wholeText();
        }
        return null;
    }

    private Void parseRuntime() {
        this.supportedElements.add("runtime");
        Element element = this.getSingleElement(this.root, "runtime");
        if (element != null) {
            try {
                this.runtime = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseStatus() {
        this.supportedElements.add("status");
        Element element = this.getSingleElement(this.root, "status");
        if (element != null) {
            this.status = MediaAiredStatus.findAiredStatus(element.ownText());
        }
        return null;
    }

    private Void parsePosters() {
        this.supportedElements.add("thumb");
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                String posterUrl;
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("poster") || StringUtils.isBlank((CharSequence)(posterUrl = element.ownText())) || !posterUrl.matches("https?://.*")) continue;
                if (element.hasAttr("type") && element.attr("type").equals("season")) {
                    try {
                        Integer season = Integer.parseInt(element.attr("season"));
                        List<String> seasonPosterList = this.seasonPosters.get(season);
                        if (seasonPosterList == null) {
                            seasonPosterList = new ArrayList<String>();
                            this.seasonPosters.put(season, seasonPosterList);
                        }
                        if (seasonPosterList.contains(posterUrl)) continue;
                        seasonPosterList.add(posterUrl);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (this.posters.contains(posterUrl)) continue;
                this.posters.add(posterUrl);
            }
        }
        return null;
    }

    private Void parseBanners() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("banner") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.banners.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseCleararts() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("clearart") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.cleararts.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseClearlogos() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("clearlogo") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.clearlogos.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseDiscarts() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("discart") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.discarts.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseThumbs() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("landscape") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.thumbs.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseKeyarts() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("keyart") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.keyarts.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseCharacterarts() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("characterart") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.characterarts.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseLogos() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("logo") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.logos.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseFanarts() {
        this.supportedElements.add("fanart");
        Element fanart = this.getSingleElement(this.root, "fanart");
        if (fanart != null) {
            String prefix = fanart.attr("url");
            Elements thumb = fanart.select(fanart.tagName() + " > thumb");
            if (!thumb.isEmpty()) {
                for (Element element : thumb) {
                    if (StringUtils.isNotBlank((CharSequence)element.ownText()) && element.ownText().matches("https?://.*")) {
                        this.fanarts.add(element.ownText());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText()) || !prefix.matches("https?://.*")) continue;
                    this.fanarts.add(prefix + element.ownText());
                }
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && fanart.ownText().matches("https?://.*")) {
                this.fanarts.add(fanart.ownText());
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && prefix.matches("https?://.*")) {
                this.fanarts.add(prefix + fanart.ownText());
            }
        }
        return null;
    }

    private Void parseSeasonArtwork() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        block12: for (Element element : thumb) {
            String artworkUrl;
            if (!element.hasAttr("aspect") || !element.hasAttr("type") || !element.attr("type").equals("season") || StringUtils.isBlank((CharSequence)(artworkUrl = element.ownText())) || !artworkUrl.matches("https?://.*")) continue;
            Integer season = null;
            try {
                season = Integer.parseInt(element.attr("season"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (season == null) continue;
            switch (element.attr("aspect")) {
                case "poster": {
                    List<String> seasonPosterList = this.seasonPosters.get(season);
                    if (seasonPosterList == null) {
                        seasonPosterList = new ArrayList<String>();
                        this.seasonPosters.put(season, seasonPosterList);
                    }
                    if (seasonPosterList.contains(artworkUrl)) continue block12;
                    seasonPosterList.add(artworkUrl);
                    continue block12;
                }
                case "banner": {
                    List<String> seasonBannerList = this.seasonBanners.get(season);
                    if (seasonBannerList == null) {
                        seasonBannerList = new ArrayList<String>();
                        this.seasonBanners.put(season, seasonBannerList);
                    }
                    if (seasonBannerList.contains(artworkUrl)) continue block12;
                    seasonBannerList.add(artworkUrl);
                    continue block12;
                }
                case "thumb": {
                    List<String> seasonThumbList = this.seasonThumbs.get(season);
                    if (seasonThumbList == null) {
                        seasonThumbList = new ArrayList<String>();
                        this.seasonThumbs.put(season, seasonThumbList);
                    }
                    if (seasonThumbList.contains(artworkUrl)) continue block12;
                    seasonThumbList.add(artworkUrl);
                    continue block12;
                }
            }
        }
        return null;
    }

    private Void parseSeasonNames() {
        this.supportedElements.add("namedseason");
        Elements namedseasons = this.root.select(this.root.tagName() + " > namedseason");
        for (Element namedseason : namedseasons) {
            try {
                int season = MetadataUtil.parseInt(namedseason.attr("number"));
                if (!StringUtils.isNotBlank((CharSequence)namedseason.ownText())) continue;
                this.seasonTitles.put(season, namedseason.ownText());
            }
            catch (Exception e) {
                LOGGER.trace("could not parse named season: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    private Void parseCertification() {
        this.supportedElements.add("certification");
        this.supportedElements.add("mpaa");
        Element element = this.getSingleElement(this.root, "certification");
        if (element == null || StringUtils.isBlank((CharSequence)element.ownText())) {
            element = this.getSingleElement(this.root, "mpaa");
        }
        if (element != null) {
            this.certification = TvShowHelpers.parseCertificationStringForTvShowSetupCountry(element.ownText());
        }
        return null;
    }

    private Void parseIds() {
        Elements children;
        this.supportedElements.add("id");
        this.supportedElements.add("imdb");
        this.supportedElements.add("imdbid");
        this.supportedElements.add("tmdbid");
        this.supportedElements.add("ids");
        this.supportedElements.add("uniqueid");
        Element element = this.getSingleElement(this.root, "id");
        if (element != null) {
            try {
                this.ids.put("tvdb", MetadataUtil.parseInt(element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Elements elements = this.root.select(this.root.tagName() + " > uniqueid");
        for (Element id : elements) {
            try {
                String value;
                String key = id.attr("type");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = id.ownText()})) continue;
                if ("unknown".equals(key) && this.ids.get("tvdb") == null) {
                    try {
                        this.ids.put("tvdb", MetadataUtil.parseInt(value));
                    }
                    catch (Exception e) {
                        this.ids.put(key, value);
                    }
                    continue;
                }
                try {
                    this.ids.put(key, MetadataUtil.parseInt(value));
                }
                catch (Exception e) {
                    this.ids.put(key, value);
                }
            }
            catch (Exception key) {}
        }
        element = this.getSingleElement(this.root, "imdb");
        if (element != null && MediaIdUtil.isValidImdbId(element.ownText())) {
            this.ids.put("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "imdbid")) != null && MediaIdUtil.isValidImdbId(element.ownText())) {
            this.ids.put("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "tmdbId")) != null) {
            try {
                this.ids.put("tmdb", MetadataUtil.parseInt(element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "ids")) != null) {
            children = element.select(element.tagName() + " > entry");
            for (Element entry : children) {
                Element key = this.getSingleElement(entry, "key");
                Element value = this.getSingleElement(entry, "value");
                if (key == null || value == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key.ownText(), value.ownText()})) continue;
                try {
                    this.ids.put(key.ownText(), MetadataUtil.parseInt(value.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(key.ownText(), value.ownText());
                }
            }
        }
        if ((element = this.getSingleElement(this.root, "ids")) != null) {
            children = element.children();
            for (Element entry : children) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.tagName(), entry.ownText()})) continue;
                try {
                    this.ids.put(entry.tagName(), MetadataUtil.parseInt(entry.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(entry.tagName(), entry.ownText());
                }
            }
        }
        return null;
    }

    private Void parseReleaseDate() {
        Date date2;
        this.supportedElements.add("premiered");
        this.supportedElements.add("aired");
        Element element = this.getSingleElement(this.root, "premiered");
        if (element != null) {
            try {
                date2 = DateUtils.parseDate(element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException date2) {
                // empty catch block
            }
        }
        if (this.releaseDate == null && (element = this.getSingleElement(this.root, "aired")) != null) {
            try {
                date2 = DateUtils.parseDate(element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseWatchedAndPlaycount() {
        this.supportedElements.add("watched");
        this.supportedElements.add("playcount");
        Element element = this.getSingleElement(this.root, "watched");
        if (element != null) {
            try {
                this.watched = Boolean.parseBoolean(element.ownText());
                element = this.getSingleElement(this.root, "playcount");
                if (element != null) {
                    this.playcount = MetadataUtil.parseInt(element.ownText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseGenres() {
        this.supportedElements.add("genres");
        this.supportedElements.add("genre");
        Elements elements = null;
        Element element = this.getSingleElement(this.root, "genres");
        elements = element != null ? element.select(element.tagName() + " > genre") : this.root.select(this.root.tagName() + " > genre");
        if (elements != null && !elements.isEmpty()) {
            for (Element genre : elements) {
                String[] split;
                if (!StringUtils.isNotBlank((CharSequence)genre.ownText())) continue;
                for (String sp : split = genre.ownText().split("/")) {
                    this.genres.add(MediaGenres.getGenre(sp.strip()));
                }
            }
        }
        return null;
    }

    private Void parseStudios() {
        this.supportedElements.add("studio");
        Elements elements = this.root.select(this.root.tagName() + " > studio");
        if (elements.size() == 1) {
            try {
                this.studios.addAll(Arrays.asList(((Element)elements.get(0)).ownText().split("\\s*[,\\/]\\s*")));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.studios.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseCountries() {
        this.supportedElements.add("country");
        Elements elements = this.root.select(this.root.tagName() + " > country");
        if (elements.size() == 1) {
            try {
                this.countries.addAll(Arrays.asList(((Element)elements.get(0)).ownText().split("\\s*[,\\/]\\s*")));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.countries.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseTags() {
        this.supportedElements.add("tag");
        Elements elements = this.root.select(this.root.tagName() + " > tag");
        for (Element element : elements) {
            if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
            this.tags.add(element.ownText());
        }
        return null;
    }

    private Void parseActors() {
        this.supportedElements.add("actor");
        Elements elements = this.root.select(this.root.tagName() + " > actor");
        for (Element element : elements) {
            Person actor = new Person();
            for (Element child : element.children()) {
                switch (child.tagName()) {
                    case "name": {
                        actor.name = child.ownText();
                        break;
                    }
                    case "role": {
                        actor.role = child.ownText();
                        break;
                    }
                    case "thumb": {
                        actor.thumb = child.ownText();
                        break;
                    }
                    case "profile": {
                        actor.profile = child.ownText();
                        break;
                    }
                    case "type": {
                        if (child.ownText().equals("GuestStar")) {
                            actor.guestStar = true;
                        }
                    }
                    case "tmdbid": {
                        actor.tmdbId = child.ownText();
                        break;
                    }
                    case "tvdbid": {
                        actor.tvdbId = child.ownText();
                        break;
                    }
                    case "imdbid": {
                        actor.imdbId = child.ownText();
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)actor.name)) continue;
            this.actors.add(actor);
        }
        return null;
    }

    private Void parseTrailer() {
        this.supportedElements.add("trailer");
        Element element = this.getSingleElement(this.root, "trailer");
        if (element != null) {
            Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/play/\\?video_id=(.*)$");
            Matcher matcher = pattern.matcher(element.ownText());
            if (matcher.matches()) {
                this.trailer = "https://www.youtube.com/watch?v=" + matcher.group(1);
            } else {
                pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
                matcher = pattern.matcher(element.ownText());
                if (matcher.matches()) {
                    this.trailer = "https://www.youtube.com/watch?v=" + matcher.group(1);
                } else {
                    pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
                    matcher = pattern.matcher(element.ownText());
                    if (matcher.matches()) {
                        this.trailer = URLDecoder.decode(matcher.group(1), StandardCharsets.UTF_8);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)element.ownText())) {
                this.trailer = element.ownText();
            }
        }
        return null;
    }

    private Void parseLastplayed() {
        this.supportedElements.add("lastplayed");
        Element element = this.getSingleElement(this.root, "lastplayed");
        if (element != null) {
            try {
                Date date = DateUtils.parseDate(element.ownText());
                if (date != null) {
                    this.lastplayed = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseCode() {
        this.supportedElements.add("code");
        Element element = this.getSingleElement(this.root, "code");
        if (element != null) {
            this.code = element.ownText();
        }
        return null;
    }

    private Void parseDateadded() {
        this.supportedElements.add("dateadded");
        Element element = this.getSingleElement(this.root, "dateadded");
        if (element != null) {
            try {
                Date date = DateUtils.parseDate(element.ownText());
                if (date != null) {
                    this.dateadded = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseEpisodeguide() {
        this.supportedElements.add("episodeguide");
        Element element = this.getSingleElement(this.root, "episodeguide");
        if (element != null) {
            this.episodeguide = !element.children().isEmpty() ? element.children().toString() : element.text();
        }
        return null;
    }

    private Void parseEnddate() {
        this.supportedElements.add("enddate");
        Element element = this.getSingleElement(this.root, "enddate");
        if (element != null) {
            this.enddate = element.ownText();
        }
        return null;
    }

    private Void findUnsupportedElements() {
        this.supportedElements.add("lockdata");
        for (Element element : this.root.children()) {
            if (IGNORE.contains(element.tagName()) || this.supportedElements.contains(element.tagName())) continue;
            String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
            this.unsupportedElements.add(elementText);
        }
        return null;
    }

    private Void parseUserNote() {
        this.supportedElements.add("user_note");
        Element element = this.getSingleElement(this.root, "user_note");
        if (element != null) {
            this.userNote = element.ownText();
        }
        return null;
    }

    private Void parseEpisodeGroups() {
        this.supportedElements.add("episode_groups");
        Element element = this.getSingleElement(this.root, "episode_groups");
        if (element != null) {
            for (Element group : element.children()) {
                try {
                    MediaEpisodeGroup.EpisodeGroupType episodeGroupType = MediaEpisodeGroup.EpisodeGroupType.valueOf(group.attr("id"));
                    String episodeGroupName = group.attr("name");
                    MediaEpisodeGroup mediaEpisodeGroup = new MediaEpisodeGroup(episodeGroupType, episodeGroupName);
                    if (Boolean.parseBoolean(group.attr("active"))) {
                        this.episodeGroup = mediaEpisodeGroup;
                    }
                    this.episodeGroups.add(mediaEpisodeGroup);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public TvShow toTvShow() {
        TvShowSeason tvShowSeason;
        TvShow show = new TvShow();
        show.setTitle(this.title);
        show.setOriginalTitle(this.originalTitle);
        show.setSortTitle(this.sortTitle);
        for (Map.Entry<String, Rating> entry : this.ratings.entrySet()) {
            Rating r = entry.getValue();
            show.setRating(new MediaRating(r.id, r.rating, r.votes, r.maxValue));
        }
        if (this.year > -1) {
            show.setYear(this.year);
        }
        show.setFirstAired(this.releaseDate);
        if (this.dateadded != null) {
            show.setDateAdded(this.dateadded);
        }
        show.setPlot(this.plot);
        show.setRuntime(this.runtime);
        if (!this.posters.isEmpty()) {
            show.setArtworkUrl(this.posters.get(0), MediaFileType.POSTER);
        }
        for (Map.Entry<Object, Object> entry : this.seasonTitles.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            tvShowSeason = show.getOrCreateSeason((Integer)entry.getKey());
            tvShowSeason.setTitle((String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.seasonPosters.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            tvShowSeason = show.getOrCreateSeason((Integer)entry.getKey());
            tvShowSeason.setArtworkUrl((String)((List)entry.getValue()).get(0), MediaFileType.SEASON_POSTER);
        }
        for (Map.Entry<Object, Object> entry : this.seasonBanners.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            tvShowSeason = show.getOrCreateSeason((Integer)entry.getKey());
            tvShowSeason.setArtworkUrl((String)((List)entry.getValue()).get(0), MediaFileType.SEASON_BANNER);
        }
        for (Map.Entry<Object, Object> entry : this.seasonThumbs.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            tvShowSeason = show.getOrCreateSeason((Integer)entry.getKey());
            tvShowSeason.setArtworkUrl((String)((List)entry.getValue()).get(0), MediaFileType.SEASON_THUMB);
        }
        if (!this.banners.isEmpty()) {
            show.setArtworkUrl(this.banners.get(0), MediaFileType.BANNER);
        }
        if (!this.cleararts.isEmpty()) {
            show.setArtworkUrl(this.cleararts.get(0), MediaFileType.CLEARART);
        }
        if (!this.clearlogos.isEmpty()) {
            show.setArtworkUrl(this.clearlogos.get(0), MediaFileType.CLEARLOGO);
        }
        if (!this.discarts.isEmpty()) {
            show.setArtworkUrl(this.discarts.get(0), MediaFileType.DISC);
        }
        if (!this.thumbs.isEmpty()) {
            show.setArtworkUrl(this.thumbs.get(0), MediaFileType.THUMB);
        }
        if (!this.keyarts.isEmpty()) {
            show.setArtworkUrl(this.keyarts.get(0), MediaFileType.KEYART);
        }
        if (!this.logos.isEmpty()) {
            show.setArtworkUrl(this.logos.get(0), MediaFileType.LOGO);
        }
        if (!this.characterarts.isEmpty()) {
            show.setArtworkUrl(this.characterarts.get(0), MediaFileType.CHARACTERART);
        }
        if (!this.fanarts.isEmpty()) {
            show.setArtworkUrl(this.fanarts.get(0), MediaFileType.FANART);
        }
        for (Map.Entry<Object, Object> entry : this.ids.entrySet()) {
            show.setId((String)entry.getKey(), entry.getValue());
        }
        String studio = StringUtils.join(this.studios, (String)" / ");
        show.setProductionCompany(Objects.requireNonNullElse(studio, ""));
        String string = StringUtils.join(this.countries, (String)" / ");
        show.setCountry(Objects.requireNonNullElse(string, ""));
        show.setCertification(this.certification);
        show.setStatus(this.status);
        ArrayList<org.tinymediamanager.core.entities.Person> newActors = new ArrayList<org.tinymediamanager.core.entities.Person>();
        for (Person actor : this.actors) {
            org.tinymediamanager.core.entities.Person tmmActor = this.morphPerson(Person.Type.ACTOR, actor);
            if (newActors.contains(tmmActor)) continue;
            newActors.add(tmmActor);
        }
        show.setActors(newActors);
        show.addToGenres(this.genres);
        show.addToTags(this.tags);
        if (StringUtils.isNotBlank((CharSequence)this.trailer)) {
            MediaTrailer mediaTrailer = new MediaTrailer();
            mediaTrailer.setName("fromNFO");
            mediaTrailer.setProvider("from NFO");
            mediaTrailer.setQuality("unknown");
            mediaTrailer.setUrl(this.trailer);
            mediaTrailer.setInNfo(true);
            show.addToTrailer(Collections.singletonList(mediaTrailer));
        }
        show.setNote(this.userNote);
        show.setEpisodeGroups(this.episodeGroups);
        show.setEpisodeGroup(this.episodeGroup);
        return show;
    }

    private org.tinymediamanager.core.entities.Person morphPerson(Person.Type type, Person nfoPerson) {
        int tvdbId;
        int tmdbId;
        org.tinymediamanager.core.entities.Person person = new org.tinymediamanager.core.entities.Person(type);
        person.setName(nfoPerson.name);
        person.setRole(nfoPerson.role);
        person.setThumbUrl(nfoPerson.thumb);
        person.setProfileUrl(nfoPerson.profile);
        if (nfoPerson.guestStar) {
            person.setType(Person.Type.GUEST);
        }
        if ((tmdbId = MetadataUtil.parseInt(nfoPerson.tmdbId, 0)) > 0) {
            person.setId("tmdb", tmdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)nfoPerson.imdbId)) {
            person.setId("imdb", nfoPerson.imdbId);
        }
        if ((tvdbId = MetadataUtil.parseInt(nfoPerson.tvdbId, 0)) > 0) {
            person.setId("tvdb", tvdbId);
        }
        return person;
    }

    static class Rating {
        static final String DEFAULT = "default";
        static final String USER = "user";
        String id = "";
        float rating = 0.0f;
        int votes = 0;
        int maxValue = 10;

        Rating() {
        }
    }

    public static class Person {
        String name = "";
        String role = "";
        String thumb = "";
        boolean guestStar = false;
        String profile = "";
        String tmdbId = "";
        String imdbId = "";
        String tvdbId = "";
    }
}

