/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaMetadata {
    public static final String ALLOCINE = "allocine";
    public static final String ANIDB = "anidb";
    public static final String IMDB = "imdb";
    public static final String LETTERBOXD = "letterboxd";
    public static final String MDBLIST = "mdblist";
    public static final String METACRITIC = "metacritic";
    public static final String METACRITIC_USER = "metacriticuser";
    public static final String MY_ANIME_LIST = "myanimelist";
    public static final String ROGER_EBERT = "rogerebert";
    public static final String TMDB = "tmdb";
    public static final String TMDB_SET = "tmdbSet";
    public static final String TRAKT_TV = "trakt";
    public static final String TVDB = "tvdb";
    public static final String TVMAZE = "tvmaze";
    public static final String TVRAGE = "tvrage";
    public static final String WIKIDATA = "wikidata";
    public static final String ZAP2IT = "zap2it";
    public static final String TVSHOW_IDS = "tvShowIds";
    public static final String EPISODE_NR = "episodeNr";
    public static final String SEASON_NR = "seasonNr";
    @Deprecated
    public static final String EPISODE_NR_DVD = "dvdEpisodeNr";
    @Deprecated
    public static final String SEASON_NR_DVD = "dvdSeasonNr";
    public static final MediaRating EMPTY_RATING = new MediaRating("", 0.0f);
    private final String providerId;
    private final Map<String, Object> ids = new HashMap<String, Object>();
    private final List<MediaRating> ratings = new ArrayList<MediaRating>();
    private final List<Person> castMembers = new ArrayList<Person>();
    private final List<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
    private final List<MediaGenres> genres = new ArrayList<MediaGenres>();
    private final List<MediaCertification> certifications = new ArrayList<MediaCertification>();
    private final List<String> productionCompanies = new ArrayList<String>();
    private final List<String> spokenLanguages = new ArrayList<String>();
    private final List<String> countries = new ArrayList<String>();
    private final List<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
    private final List<MediaMetadata> subItems = new ArrayList<MediaMetadata>();
    private final List<String> tags = new ArrayList<String>();
    private String title = "";
    private String originalTitle = "";
    private String originalLanguage = "";
    private int year = 0;
    private Date releaseDate = null;
    private String plot = "";
    private String tagline = "";
    private int runtime = 0;
    private String collectionName = "";
    private int top250 = 0;
    private final Set<MediaEpisodeGroup> episodeGroups = new HashSet<MediaEpisodeGroup>();
    private final Map<MediaEpisodeGroup, MediaEpisodeNumber> episodeNumbers = new LinkedHashMap<MediaEpisodeGroup, MediaEpisodeNumber>();
    private MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    private Map<MediaEpisodeGroup, Map<Integer, String>> seasonNames = new HashMap<MediaEpisodeGroup, Map<Integer, String>>();
    private Map<MediaEpisodeGroup, Map<Integer, String>> seasonOverview = new HashMap<MediaEpisodeGroup, Map<Integer, String>>();
    private final Map<String, Object> extraData = new HashMap<String, Object>();
    private MediaSearchAndScrapeOptions scrapeOptions = null;

    public MediaMetadata(String providerId) {
        this.providerId = providerId;
    }

    public void mergeFrom(MediaMetadata md) {
        if (md == null) {
            return;
        }
        Map<String, Object> delta = md.getIds();
        delta.keySet().removeAll(this.ids.keySet());
        this.ids.putAll(delta);
        this.title = this.merge(this.title, md.getTitle());
        this.originalTitle = this.merge(this.originalTitle, md.getOriginalTitle());
        this.originalLanguage = this.merge(this.originalLanguage, md.getOriginalLanguage());
        this.year = this.merge(this.year, md.getYear());
        this.releaseDate = this.merge(this.releaseDate, md.getReleaseDate());
        this.plot = this.merge(this.plot, md.getPlot());
        this.tagline = this.merge(this.tagline, md.getTagline());
        this.runtime = this.merge(this.runtime, md.getRuntime());
        this.collectionName = this.merge(this.collectionName, md.getCollectionName());
        this.top250 = this.merge(this.top250, md.getTop250());
        this.status = this.merge(this.status, md.getStatus());
        this.episodeNumbers.putAll(md.getEpisodeNumbers());
        this.ratings.removeAll(md.getRatings());
        this.ratings.addAll(md.getRatings());
        this.castMembers.removeAll(md.getCastMembers());
        this.castMembers.addAll(md.getCastMembers());
        this.artwork.removeAll(md.getMediaArt());
        this.artwork.addAll(md.getMediaArt());
        this.genres.removeAll(md.getGenres());
        this.genres.addAll(md.getGenres());
        this.certifications.removeAll(md.getCertifications());
        this.certifications.addAll(md.getCertifications());
        this.productionCompanies.removeAll(md.getProductionCompanies());
        this.productionCompanies.addAll(md.getProductionCompanies());
        this.spokenLanguages.removeAll(md.getSpokenLanguages());
        this.spokenLanguages.addAll(md.getSpokenLanguages());
        this.countries.removeAll(md.getCountries());
        this.countries.addAll(md.getCountries());
        this.trailers.removeAll(md.getTrailers());
        this.trailers.addAll(md.getTrailers());
        this.subItems.removeAll(md.getSubItems());
        this.subItems.addAll(md.getSubItems());
        this.tags.removeAll(md.getTags());
        this.tags.addAll(md.getTags());
        this.episodeGroups.removeAll(md.getEpisodeGroups());
        this.episodeGroups.addAll(md.getEpisodeGroups());
        this.seasonNames.keySet().removeAll(md.getSeasonNames().keySet());
        this.seasonNames.putAll(md.seasonNames);
        this.seasonOverview.keySet().removeAll(md.getSeasonOverview().keySet());
        this.seasonOverview.putAll(md.seasonOverview);
        delta = md.getExtraData();
        delta.keySet().removeAll(this.extraData.keySet());
        this.extraData.putAll(delta);
        this.scrapeOptions = this.merge(this.scrapeOptions, md.scrapeOptions);
    }

    private String merge(String val1, String val2) {
        return StringUtils.isBlank((CharSequence)val1) ? val2 : val1;
    }

    private int merge(int val1, int val2) {
        return val1 <= 0 ? val2 : val1;
    }

    private Date merge(Date val1, Date val2) {
        return val1 == null ? val2 : val1;
    }

    private float merge(float val1, float val2) {
        return val1 <= 0.0f ? val2 : val1;
    }

    private MediaSearchAndScrapeOptions merge(MediaSearchAndScrapeOptions val1, MediaSearchAndScrapeOptions val2) {
        return val1 == null ? val2 : val1;
    }

    private MediaAiredStatus merge(MediaAiredStatus val1, MediaAiredStatus val2) {
        return val1 == MediaAiredStatus.UNKNOWN ? val2 : val1;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void setGenres(List<MediaGenres> genres) {
        this.genres.clear();
        if (genres != null) {
            this.genres.addAll(genres);
        }
    }

    public List<Person> getCastMembers(Person.Type type) {
        ArrayList<Person> ret = new ArrayList<Person>();
        ret.addAll(this.castMembers.stream().filter(person -> person.getType() == type).toList());
        if (type == Person.Type.ACTOR) {
            ret.addAll(this.castMembers.stream().filter(person -> person.getType() == Person.Type.GUEST).toList());
        }
        return ret;
    }

    public List<MediaArtwork> getMediaArt(MediaArtwork.MediaArtworkType type) {
        if (type == MediaArtwork.MediaArtworkType.ALL) {
            return this.artwork;
        }
        return this.artwork.stream().filter(ma -> ma.getType() == type).toList();
    }

    public void addGenre(MediaGenres genre) {
        if (genre != null && !this.genres.contains(genre)) {
            this.genres.add(genre);
        }
    }

    public void addCastMember(Person castMember) {
        if (this.containsCastMember(castMember)) {
            return;
        }
        this.castMembers.add(castMember);
    }

    public List<MediaArtwork> getMediaArt() {
        return this.artwork;
    }

    public void setMediaArt(List<MediaArtwork> artwork) {
        this.artwork.clear();
        if (artwork != null) {
            this.artwork.addAll(artwork);
        }
    }

    public void addMediaArt(MediaArtwork ma) {
        if (ma != null) {
            this.artwork.add(ma);
        }
    }

    public void clearMediaArt() {
        this.artwork.clear();
    }

    public void addMediaArt(List<MediaArtwork> art) {
        this.artwork.addAll(art);
    }

    public List<Person> getCastMembers() {
        return this.castMembers;
    }

    public void setCastMembers(List<Person> castMembers) {
        this.castMembers.clear();
        if (castMembers != null) {
            this.castMembers.addAll(castMembers);
        }
    }

    public void addSubItem(MediaMetadata item) {
        if (item != null) {
            this.subItems.add(item);
        }
    }

    public List<MediaMetadata> getSubItems() {
        return this.subItems;
    }

    private boolean containsCastMember(Person castMember) {
        return this.castMembers.stream().anyMatch(cm -> cm.getType() == castMember.getType() && StringUtils.equals((CharSequence)cm.getName(), (CharSequence)castMember.getName()));
    }

    public void addCertification(MediaCertification certification) {
        if (certification != null && !this.certifications.contains((Object)certification)) {
            this.certifications.add(certification);
        }
    }

    public List<MediaCertification> getCertifications() {
        return this.certifications;
    }

    public void setCertifications(List<MediaCertification> certifications) {
        this.certifications.clear();
        if (certifications != null) {
            this.certifications.addAll(certifications);
        }
    }

    public void addTrailer(MediaTrailer trailer) {
        if (trailer != null) {
            this.trailers.add(trailer);
        }
    }

    public List<MediaTrailer> getTrailers() {
        return this.trailers;
    }

    public void setTrailers(List<MediaTrailer> trailers) {
        this.trailers.clear();
        if (trailers != null) {
            this.trailers.addAll(trailers);
        }
    }

    public void setId(String key, Object object) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            String v = String.valueOf(object);
            if ("".equals(v) || "0".equals(v) || "null".equals(v)) {
                this.ids.remove(key);
            } else {
                this.ids.put(key, object);
            }
        }
    }

    public void setIds(Map<String, Object> newIds) {
        for (Map.Entry<String, Object> id : newIds.entrySet()) {
            this.setId(id.getKey(), id.getValue());
        }
    }

    public void removeId(String key) {
        this.ids.remove(key);
    }

    public Object getId(String key) {
        Object id = this.ids.get(key);
        if (id == null) {
            return "";
        }
        return id;
    }

    public String getIdAsString(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            return String.valueOf(id);
        }
        return null;
    }

    public Integer getIdAsInteger(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            if (id instanceof Integer) {
                Integer integer = (Integer)id;
                return integer;
            }
            if (id instanceof String) {
                String string = (String)id;
                try {
                    return Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public int getIdAsInt(String providerId) {
        return this.getIdAsIntOrDefault(providerId, 0);
    }

    public int getIdAsIntOrDefault(String providerId, int defaultValue) {
        Integer id = this.getIdAsInteger(providerId);
        if (id == null) {
            return defaultValue;
        }
        return id;
    }

    public Map<String, Object> getIds() {
        return this.ids;
    }

    public List<String> getProductionCompanies() {
        return this.productionCompanies;
    }

    public void setProductionCompanies(List<String> productionCompanies) {
        this.productionCompanies.clear();
        if (productionCompanies != null) {
            this.productionCompanies.addAll(productionCompanies);
        }
    }

    public void addProductionCompany(String productionCompany) {
        if (StringUtils.isBlank((CharSequence)productionCompany)) {
            return;
        }
        if (!this.productionCompanies.contains(productionCompany)) {
            this.productionCompanies.add(productionCompany);
        }
    }

    public void removeProductionCompany(String productionCompany) {
        this.productionCompanies.remove(productionCompany);
    }

    public List<String> getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public void setSpokenLanguages(List<String> spokenLanguages) {
        this.spokenLanguages.clear();
        if (spokenLanguages != null) {
            this.spokenLanguages.addAll(spokenLanguages);
        }
    }

    public void addSpokenLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return;
        }
        if (!this.spokenLanguages.contains(language)) {
            this.spokenLanguages.add(language);
        }
    }

    public void removeSpokenLanguage(String language) {
        this.spokenLanguages.remove(language);
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries.clear();
        if (countries != null) {
            this.countries.addAll(countries);
        }
    }

    public void addCountry(String country) {
        if (StringUtils.isBlank((CharSequence)country)) {
            return;
        }
        if (!this.countries.contains(country)) {
            this.countries.add(country);
        }
    }

    public void removeCountry(String country) {
        this.countries.remove(country);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = StrgUtils.getNonNullString(originalLanguage);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setYear(Integer year) {
        if (year != null) {
            this.setYear((int)year);
        }
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        if (releaseDate != null) {
            this.releaseDate = releaseDate;
        }
    }

    public String getPlot() {
        return this.plot;
    }

    public void setPlot(String plot) {
        this.plot = StrgUtils.getNonNullString(plot);
    }

    public String getTagline() {
        return this.tagline;
    }

    public void setTagline(String tagline) {
        this.tagline = StrgUtils.getNonNullString(tagline);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = StrgUtils.getNonNullString(collectionName);
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int runtime) {
        this.runtime = runtime;
    }

    public void setRuntime(Integer runtime) {
        if (runtime != null) {
            this.setRuntime((int)runtime);
        }
    }

    public List<MediaRating> getRatings() {
        return this.ratings;
    }

    public void setRatings(List<MediaRating> newRatings) {
        for (MediaRating rating : newRatings) {
            this.addRating(rating);
        }
    }

    public void addRating(MediaRating rating) {
        if (rating != null && StringUtils.isNotBlank((CharSequence)rating.getId()) && rating.getMaxValue() > 0 && (rating.getRating() > 0.0f || rating.getVotes() > 0) && !this.ratings.contains(rating)) {
            this.ratings.add(rating);
        }
    }

    public void removeRatings() {
        this.ratings.clear();
    }

    public int getTop250() {
        return this.top250;
    }

    public void setTop250(int top250) {
        this.top250 = top250;
    }

    public void setTop250(Integer top250) {
        if (top250 != null) {
            this.setTop250((int)top250);
        }
    }

    public Map<MediaEpisodeGroup, MediaEpisodeNumber> getEpisodeNumbers() {
        return Collections.unmodifiableMap(this.episodeNumbers);
    }

    public void setEpisodeNumbers(Map<MediaEpisodeGroup, MediaEpisodeNumber> eps) {
        if (eps != null) {
            this.episodeNumbers.clear();
            this.episodeNumbers.putAll(eps);
        }
    }

    public MediaEpisodeNumber getEpisodeNumber(@NotNull MediaEpisodeGroup episodeGroup) {
        return this.episodeNumbers.get(episodeGroup);
    }

    public MediaEpisodeNumber getEpisodeNumber(@NotNull MediaEpisodeGroup.EpisodeGroupType episodeGroupType) {
        for (Map.Entry<MediaEpisodeGroup, MediaEpisodeNumber> entry : this.episodeNumbers.entrySet()) {
            if (entry.getKey().getEpisodeGroupType() != episodeGroupType) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setEpisodeNumber(@NotNull MediaEpisodeGroup episodeGroup, int season, int episode) {
        this.setEpisodeNumber(new MediaEpisodeNumber(episodeGroup, season, episode));
    }

    public void setEpisodeNumber(MediaEpisodeNumber episodeNumber) {
        if (episodeNumber == null || !episodeNumber.isValid()) {
            return;
        }
        this.episodeNumbers.put(episodeNumber.episodeGroup(), episodeNumber);
    }

    public MediaAiredStatus getStatus() {
        return this.status;
    }

    public void setStatus(MediaAiredStatus status) {
        this.status = status;
    }

    public void setStatus(String statusAsText) {
        this.status = MediaAiredStatus.findAiredStatus(statusAsText);
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public void addExtraData(String key, Object value) {
        if (StringUtils.isNotBlank((CharSequence)key) && value != null) {
            this.extraData.put(key, value);
        }
    }

    public Object getExtraData(String key) {
        return this.extraData.get(key);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public void addTag(String tag) {
        if (StringUtils.isBlank((CharSequence)tag)) {
            return;
        }
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void addSeasonName(MediaEpisodeGroup episodeGroup, int seasonNumber, String name) {
        if (seasonNumber > -1 && StringUtils.isNotBlank((CharSequence)name)) {
            this.seasonNames.computeIfAbsent(episodeGroup, k -> new HashMap()).put(seasonNumber, name);
        }
    }

    public Map<MediaEpisodeGroup, Map<Integer, String>> getSeasonNames() {
        return this.seasonNames;
    }

    public void setSeasonNames(Map<MediaEpisodeGroup, Map<Integer, String>> map) {
        this.seasonNames = map;
    }

    public void addSeasonOverview(MediaEpisodeGroup episodeGroup, int seasonNumber, String overview) {
        if (seasonNumber > -1 && StringUtils.isNotBlank((CharSequence)overview)) {
            this.seasonOverview.computeIfAbsent(episodeGroup, k -> new HashMap()).put(seasonNumber, overview);
        }
    }

    public Map<MediaEpisodeGroup, Map<Integer, String>> getSeasonOverview() {
        return this.seasonOverview;
    }

    public void setSeasonOverview(Map<MediaEpisodeGroup, Map<Integer, String>> map) {
        this.seasonOverview = map;
    }

    public void addEpisodeGroup(MediaEpisodeGroup episodeGroup) {
        this.episodeGroups.add(episodeGroup);
    }

    public Set<MediaEpisodeGroup> getEpisodeGroups() {
        return this.episodeGroups;
    }

    public void setEpisodeGroups(Set<MediaEpisodeGroup> episodeGroups) {
        this.episodeGroups.clear();
        this.episodeGroups.addAll(episodeGroups);
    }

    public MediaSearchAndScrapeOptions getScrapeOptions() {
        return this.scrapeOptions;
    }

    public void setScrapeOptions(MediaSearchAndScrapeOptions scrapeOptions) {
        this.scrapeOptions = scrapeOptions;
    }

    public MediaSearchResult toSearchResult(MediaType type) {
        MediaSearchResult sr = new MediaSearchResult(this.providerId, type);
        sr.setIds(this.getIds());
        sr.setTitle(this.getTitle());
        sr.setOriginalTitle(this.getOriginalTitle());
        sr.setYear(this.getYear());
        return sr;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

