/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.CompanyBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ContentRating;
import org.tinymediamanager.scraper.thetvdb.entities.GenreBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.MovieExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.MovieExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Release;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SearchType;
import org.tinymediamanager.scraper.thetvdb.entities.Trailer;
import org.tinymediamanager.scraper.thetvdb.entities.Translation;
import org.tinymediamanager.scraper.thetvdb.entities.TranslationResponse;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

public class TheTvDbMovieMetadataProvider
extends TheTvDbMetadataProvider
implements IMovieMetadataProvider,
IMovieTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMovieMetadataProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addText("pin", "", true);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.valuesSorted()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        info.getConfig().addSelect("fallbackLanguage", fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchResultRecord> searchResults;
        TreeSet<MediaSearchResult> results;
        block26: {
            int tvdbId;
            this.initAPI();
            LOGGER.debug("search() {}", (Object)options);
            results = new TreeSet<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if ((tvdbId = options.getIdAsInt(this.getId())) != 0) {
                LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
                try {
                    MediaMetadata md = this.getMetadata(options);
                    if (md != null) {
                        results.add(this.morphMediaMetadataToSearchResult(md, MediaType.MOVIE));
                        return results;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                }
            }
            searchResults = null;
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                try {
                    Response httpResponse = this.tvdb.getSearchService().getSearch(searchString, SearchType.MOVIE).execute();
                    if (!httpResponse.isSuccessful()) {
                        String msg = httpResponse.message().isBlank() ? httpResponse.errorBody().string() : httpResponse.message();
                        throw new HttpException(httpResponse.code(), msg);
                    }
                    searchResults = ((SearchResultResponse)httpResponse.body()).data;
                    if (!ListUtils.isEmpty(searchResults) || !ID_PATTERN.matcher(searchString).matches()) break block26;
                    LOGGER.debug("nothing found, but search term '{}' looks like a TvDb ID - getting direct", (Object)searchString);
                    try {
                        MediaMetadata md = this.getMetadata(options);
                        if (md != null) {
                            MediaSearchResult result = this.morphMediaMetadataToSearchResult(md, MediaType.MOVIE);
                            result.setMetadata(md);
                            results.add(result);
                            return results;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
            }
        }
        if (ListUtils.isEmpty(searchResults)) {
            return results;
        }
        HashMap<String, MediaSearchResult> resultMap = new HashMap<String, MediaSearchResult>();
        for (SearchResultRecord searchResultRecord : searchResults) {
            String title;
            MediaSearchResult result = new MediaSearchResult(this.getId(), options.getMediaType());
            String id = "";
            if (StringUtils.isNotBlank((CharSequence)searchResultRecord.tvdbId)) {
                id = searchResultRecord.tvdbId;
            } else if (StringUtils.isNotBlank((CharSequence)searchResultRecord.id)) {
                id = searchResultRecord.id.replace("movie-", "");
            }
            if (StringUtils.isBlank((CharSequence)id)) continue;
            result.setId(id);
            MediaLanguages baseLanguage = options.getLanguage();
            MediaLanguages fallbackLanguage = null;
            if (StringUtils.isNotBlank((CharSequence)this.getProviderInfo().getConfig().getValue("fallbackLanguage"))) {
                fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage"));
            }
            if (StringUtils.isNotBlank((CharSequence)(title = this.parseLocalizedText(baseLanguage, searchResultRecord.translations)))) {
                result.setTitle(title);
            } else {
                title = this.parseLocalizedText(fallbackLanguage, searchResultRecord.translations);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    result.setTitle(title);
                } else {
                    result.setTitle(searchResultRecord.name);
                }
            }
            String overview = this.parseLocalizedText(baseLanguage, searchResultRecord.overviews);
            if (StringUtils.isNotBlank((CharSequence)overview)) {
                result.setOverview(overview);
            } else {
                overview = this.parseLocalizedText(fallbackLanguage, searchResultRecord.overviews);
                if (StringUtils.isNotBlank((CharSequence)overview)) {
                    result.setOverview(overview);
                } else {
                    result.setOverview(searchResultRecord.overview);
                }
            }
            result.setYear(MetadataUtil.parseInt(searchResultRecord.year, 0));
            result.setPosterUrl(searchResultRecord.imageUrl);
            result.calculateScore(options);
            resultMap.put(id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        int y;
        MovieExtendedRecord movie;
        if (options.getSearchResult() != null && options.getSearchResult().getMediaMetadata() != null && this.getId().equals(options.getSearchResult().getMediaMetadata().getProviderId())) {
            return options.getSearchResult().getMediaMetadata();
        }
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int id = options.getIdAsInt(this.getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            id = this.getTvdbIdViaImdbId(options.getImdbId());
        }
        if (id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        Translation baseTranslation = null;
        Translation fallbackTranslation = null;
        try {
            Object translationResponse;
            Response httpResponse;
            String baseLanguage = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
            String fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale());
            if ("pob".equals(baseLanguage)) {
                baseLanguage = "pt";
            }
            if ("pob".equals(fallbackLanguage)) {
                fallbackLanguage = "pt";
            }
            if (!(httpResponse = this.tvdb.getMoviesService().getMovieExtended(id).execute()).isSuccessful()) {
                String msg = httpResponse.message().isBlank() ? httpResponse.errorBody().string() : httpResponse.message();
                throw new HttpException(httpResponse.code(), msg);
            }
            movie = ((MovieExtendedResponse)httpResponse.body()).data;
            if (movie.overviewTranslations.contains(baseLanguage) && (translationResponse = this.tvdb.getMoviesService().getMoviesTranslation(id, baseLanguage).execute()).isSuccessful()) {
                baseTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
            if ((baseTranslation == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseTranslation.name, baseTranslation.overview})) && movie.overviewTranslations.contains(fallbackLanguage) && (translationResponse = this.tvdb.getMoviesService().getMoviesTranslation(id, fallbackLanguage).execute()).isSuccessful()) {
                fallbackTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        md.setId(this.getId(), movie.id);
        this.parseRemoteIDs(movie.remoteIds).forEach((k, v) -> md.setId((String)k, v));
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.name)) {
            md.setTitle(baseTranslation.name);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setTitle(fallbackTranslation.name);
        } else {
            md.setTitle(movie.name);
        }
        md.setOriginalTitle(movie.name);
        if (movie.originalCountry != null) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), movie.originalCountry));
            } else {
                md.addCountry(movie.originalCountry);
            }
        }
        if (movie.originalLanguage != null) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.setOriginalLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), movie.originalLanguage));
            } else {
                md.setOriginalLanguage(movie.originalLanguage);
            }
        }
        if (movie.audioLanguages != null) {
            for (String langu : movie.audioLanguages) {
                if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                    md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), langu));
                    continue;
                }
                md.addSpokenLanguage(langu);
            }
        }
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.overview)) {
            md.setPlot(baseTranslation.overview);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setPlot(fallbackTranslation.overview);
        }
        Date localReleaseDate = null;
        Date globalReleaseDate = null;
        Date firstReleaseDate = null;
        for (Release release : ListUtils.nullSafe(movie.releases)) {
            try {
                Date date = DateUtils.parseDate(release.date);
                if (firstReleaseDate == null || firstReleaseDate.after(date)) {
                    firstReleaseDate = date;
                }
                if ("global".equalsIgnoreCase(release.country)) {
                    globalReleaseDate = date;
                }
                if (!options.getReleaseDateCountry().equals(release.country)) continue;
                localReleaseDate = date;
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse release date - '{}'", (Object)e.getMessage());
            }
        }
        Date releaseDate = null;
        if (localReleaseDate != null) {
            releaseDate = localReleaseDate;
        } else if (globalReleaseDate != null) {
            releaseDate = globalReleaseDate;
        }
        if (globalReleaseDate == null) {
            globalReleaseDate = firstReleaseDate;
        }
        if (releaseDate == null) {
            releaseDate = firstReleaseDate;
        }
        if (releaseDate != null) {
            md.setReleaseDate(releaseDate);
        }
        if (globalReleaseDate != null && (y = this.getYearFromDate(globalReleaseDate)) > 0) {
            md.setYear(y);
            if (md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        md.setRuntime(MetadataUtil.unboxInteger(movie.runtime, 0));
        if (movie.companies != null) {
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.production)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.studio)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.network)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.specialEffects)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.distributor)) {
                md.addProductionCompany(baseRecord.name);
            }
        }
        for (Person member : this.parseCastMembers(movie.characters)) {
            md.addCastMember(member);
        }
        for (GenreBaseRecord genreBaseRecord : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(MediaGenres.getGenre(genreBaseRecord.name));
        }
        for (ArtworkBaseRecord artworkBaseRecord : ListUtils.nullSafe(movie.artworks)) {
            MediaArtwork mediaArtwork = this.parseArtwork(artworkBaseRecord);
            if (mediaArtwork == null) continue;
            md.addMediaArt(mediaArtwork);
        }
        for (ContentRating contentRating : ListUtils.nullSafe(movie.contentRatings)) {
            MediaCertification certification;
            if (!options.getCertificationCountry().getAlpha3().equalsIgnoreCase(contentRating.country) || (certification = MediaCertification.findCertification(contentRating.name)) == null || certification == MediaCertification.UNKNOWN) continue;
            md.addCertification(certification);
        }
        if (StringUtils.isNotBlank((CharSequence)movie.image)) {
            MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setOriginalUrl(movie.image);
            ma.addImageSize(0, 0, movie.image, 0);
            md.addMediaArt(ma);
        }
        for (Trailer trailer : ListUtils.nullSafe(movie.trailers)) {
            MediaTrailer t = new MediaTrailer();
            t.setName(trailer.name);
            t.setId(String.valueOf(trailer.id));
            t.setUrl(trailer.url);
            if (trailer.url.contains("youtube")) {
                t.setProvider("youtube");
            }
            t.setScrapedBy(this.getProviderInfo().getId());
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                t.setQuality(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), trailer.language));
            } else {
                t.setQuality(trailer.language);
            }
            md.addTrailer(t);
        }
        return md;
    }

    private int getYearFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getTrailer(): {}", (Object)options);
        if (options.getMediaType() != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        MovieSearchAndScrapeOptions saso = new MovieSearchAndScrapeOptions();
        saso.setDataFromOtherOptions(options);
        return this.getMetadata(saso).getTrailers();
    }
}

