/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.yt;

import com.github.kiulian.downloader.Config;
import com.github.kiulian.downloader.YoutubeDownloader;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import com.github.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.tinymediamanager.license.TmmFeature;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.http.Url;

public class YTDownloader
extends YoutubeDownloader
implements TmmFeature {
    public YTDownloader() throws ScrapeException {
        super(new Config.Builder().build());
        this.setDownloader(new DownloaderImpl());
    }

    class DownloaderImpl
    implements Downloader {
        DownloaderImpl() {
        }

        public com.github.kiulian.downloader.downloader.response.Response<String> downloadWebpage(RequestWebpage requestWebpage) {
            if ("POST".equals(requestWebpage.getMethod())) {
                return this.post(requestWebpage);
            }
            return this.get(requestWebpage);
        }

        private com.github.kiulian.downloader.downloader.response.Response<String> get(RequestWebpage requestWebpage) {
            try {
                Url url = new Url(requestWebpage.getDownloadUrl().replace("{API_KEY}", YTDownloader.this.getApiKey()));
                if (requestWebpage.getHeaders() != null) {
                    for (Map.Entry entry : requestWebpage.getHeaders().entrySet()) {
                        url.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                String body = requestWebpage.getMaxRetries() != null ? new String(url.getBytesWithRetry(requestWebpage.getMaxRetries()), StandardCharsets.UTF_8) : new String(url.getBytes(), StandardCharsets.UTF_8);
                return ResponseImpl.from((Object)body);
            }
            catch (Exception e) {
                return ResponseImpl.error((Throwable)e);
            }
        }

        private com.github.kiulian.downloader.downloader.response.Response<String> post(RequestWebpage requestWebpage) {
            Call call = null;
            Response response = null;
            try {
                RequestBody body = RequestBody.create((String)requestWebpage.getBody(), (MediaType)MediaType.parse((String)"application/json"));
                Request.Builder builder = new Request.Builder().url(requestWebpage.getDownloadUrl().replace("{API_KEY}", YTDownloader.this.getApiKey())).post(body);
                if (requestWebpage.getHeaders() != null) {
                    for (Map.Entry entry : requestWebpage.getHeaders().entrySet()) {
                        builder.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                Request request = builder.build();
                call = TmmHttpClient.getHttpClient().newCall(request);
                response = call.execute();
                int responseCode = response.code();
                String responseMessage = response.message();
                if (responseCode < 200 || responseCode >= 400) {
                    throw new HttpException(requestWebpage.getBody(), responseCode, responseMessage);
                }
                return ResponseImpl.from((Object)response.body().string());
            }
            catch (Exception e) {
                if (call != null) {
                    call.cancel();
                }
                if (response != null) {
                    response.close();
                }
                return ResponseImpl.error((Throwable)e);
            }
        }

        public com.github.kiulian.downloader.downloader.response.Response<File> downloadVideoAsFile(RequestVideoFileDownload requestVideoFileDownload) {
            return null;
        }

        public com.github.kiulian.downloader.downloader.response.Response<Void> downloadVideoAsStream(RequestVideoStreamDownload requestVideoStreamDownload) {
            return null;
        }
    }
}

