/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.license.License;
import org.tinymediamanager.ui.HintManager;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.actions.CheckForUpdateAction;
import org.tinymediamanager.ui.actions.UnlockAction;
import org.tinymediamanager.ui.components.toolbar.ToolbarButton;
import org.tinymediamanager.ui.components.toolbar.ToolbarLabel;
import org.tinymediamanager.ui.components.toolbar.ToolbarMenu;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.updater.UpdateCheck;

public class ToolbarPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolbarPanel.class);
    private final ToolbarButton btnSearch;
    private final ToolbarButton btnEdit;
    private final ToolbarButton btnUpdate;
    private final ToolbarButton btnRename;
    private final ToolbarButton btnUnlock;
    private final ToolbarButton btnRenewLicense;
    private final ToolbarButton btnUpdateFound;
    private final ToolbarMenu menuUpdate;
    private final ToolbarMenu menuSearch;
    private final ToolbarMenu menuEdit;
    private final ToolbarMenu menuRename;

    public ToolbarPanel() {
        this.setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel();
        this.add((Component)panelCenter, "Center");
        panelCenter.setOpaque(false);
        panelCenter.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3", "[][]20lp[]20lp[]20lp[]20lp[]20lp[][grow]15lp[]15lp[]15lp[][][][][][15lp:n]", "[45lp]1lp[]5lp"));
        panelCenter.add((Component)new JLabel(IconManager.TOOLBAR_LOGO), "cell 1 0, alignx left, aligny bottom");
        ToolbarLabel lblVersion = new ToolbarLabel(ReleaseInfo.getRealVersion(), event -> WhatsNewDialog.showChangelog());
        TmmFontHelper.changeFont(lblVersion, 0.91667, 1);
        panelCenter.add((Component)lblVersion, "cell 1 1, alignx center");
        this.btnUpdate = new ToolbarButton((Icon)IconManager.TOOLBAR_REFRESH, (Icon)IconManager.TOOLBAR_REFRESH_HOVER);
        panelCenter.add((Component)this.btnUpdate, "cell 2 0,grow, alignx center, aligny bottom");
        this.btnSearch = new ToolbarButton((Icon)IconManager.TOOLBAR_SEARCH, (Icon)IconManager.TOOLBAR_SEARCH_HOVER);
        panelCenter.add((Component)this.btnSearch, "cell 3 0,grow, alignx center, aligny bottom");
        this.btnEdit = new ToolbarButton((Icon)IconManager.TOOLBAR_EDIT, (Icon)IconManager.TOOLBAR_EDIT_HOVER);
        panelCenter.add((Component)this.btnEdit, "cell 4 0,grow, alignx center, aligny bottom");
        this.btnRename = new ToolbarButton((Icon)IconManager.TOOLBAR_RENAME, (Icon)IconManager.TOOLBAR_RENAME_HOVER);
        panelCenter.add((Component)this.btnRename, "cell 5 0,grow, alignx center, aligny bottom");
        this.btnUnlock = new ToolbarButton((Icon)IconManager.TOOLBAR_UPGRADE, (Icon)IconManager.TOOLBAR_UPGRADE);
        UnlockAction unlockAction = new UnlockAction();
        this.btnUnlock.setAction(unlockAction);
        this.btnUnlock.setToolTipText(TmmResourceBundle.getString("Toolbar.upgrade.desc"));
        panelCenter.add((Component)this.btnUnlock, "cell 11 0 1 2, center");
        this.btnRenewLicense = new ToolbarButton((Icon)IconManager.TOOLBAR_RENEW, (Icon)IconManager.TOOLBAR_RENEW);
        this.btnRenewLicense.setAction(unlockAction);
        this.btnRenewLicense.setToolTipText(TmmResourceBundle.getString("Toolbar.renewlicense.desc"));
        panelCenter.add((Component)this.btnRenewLicense, "cell 12 0 1 2, center, gap 10lp");
        this.btnUpdateFound = new ToolbarButton((Icon)IconManager.TOOLBAR_DOWNLOAD, (Icon)IconManager.TOOLBAR_DOWNLOAD);
        this.btnUpdateFound.setAction(new CheckForUpdateAction());
        this.btnUpdateFound.setToolTipText(TmmResourceBundle.getString("tmm.update.message.toolbar"));
        panelCenter.add((Component)this.btnUpdateFound, "cell 13 0 1 2, center, gap 10lp");
        ToolbarButton btnNotifications = new ToolbarButton(IconManager.TOOLBAR_ALERT);
        panelCenter.add((Component)btnNotifications, "cell 14 0 1 2, center, gap 10lp");
        btnNotifications.addActionListener(e -> {
            MessageHistoryDialog dialog = MessageHistoryDialog.getInstance();
            dialog.setVisible(true);
        });
        this.menuUpdate = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.update"));
        panelCenter.add((Component)this.menuUpdate, "cell 2 1,alignx center, wmin 0");
        this.menuSearch = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.search"));
        panelCenter.add((Component)this.menuSearch, "cell 3 1,alignx center, wmin 0");
        this.menuEdit = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.edit"));
        panelCenter.add((Component)this.menuEdit, "cell 4 1,alignx center, wmin 0");
        this.menuRename = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.rename"));
        panelCenter.add((Component)this.menuRename, "cell 5 1,alignx center, wmin 0");
        TmmUIMessageCollector.instance.addPropertyChangeListener(evt -> {
            if ("messages".equals(evt.getPropertyName())) {
                if (TmmUIMessageCollector.instance.getNewMessagesCount() > 0) {
                    btnNotifications.setIcon(IconManager.TOOLBAR_ALERT_RED);
                    btnNotifications.setToolTipText(TmmResourceBundle.getString("notifications.new"));
                } else {
                    btnNotifications.setIcon(IconManager.TOOLBAR_ALERT);
                    btnNotifications.setToolTipText(null);
                }
                btnNotifications.repaint();
            }
        });
        License.getInstance().addEventListener(this::showHideUnlock);
        this.showHideUnlock();
        this.initUpgradeCheck();
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.update"), this.btnUpdate, 3);
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.scrape"), this.btnSearch, 3);
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.edit"), this.btnEdit, 3);
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.rename"), this.btnRename, 3);
    }

    private void showHideUnlock() {
        if (License.getInstance().isValidLicense()) {
            this.btnUnlock.setVisible(false);
            LocalDate validUntil = License.getInstance().validUntil();
            if (validUntil != null && validUntil.minus(14L, ChronoUnit.DAYS).isBefore(LocalDate.now())) {
                this.btnRenewLicense.setVisible(true);
            } else {
                this.btnRenewLicense.setVisible(false);
            }
        } else {
            this.btnUnlock.setVisible(true);
            this.btnRenewLicense.setVisible(false);
        }
    }

    private void initUpgradeCheck() {
        Timer timer;
        this.btnUpdateFound.setVisible(false);
        Runnable runnable = () -> {
            if (TmmUIHelper.shouldCheckForUpdate()) {
                try {
                    UpdateCheck updateCheck = new UpdateCheck();
                    if (updateCheck.isUpdateAvailable()) {
                        this.btnUpdateFound.setVisible(true);
                        LOGGER.info("update available");
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Update check failed - {}", (Object)e.getMessage());
                }
            }
        };
        if (!Settings.getInstance().isNewConfig()) {
            timer = new Timer(10000, e -> TmmTaskManager.getInstance().addUnnamedTask(runnable));
            timer.setRepeats(false);
            timer.start();
        }
        timer = new Timer(86400000, e -> TmmTaskManager.getInstance().addUnnamedTask(runnable));
        timer.setRepeats(true);
        timer.start();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tmm.toolbar.background"));
    }

    public void setUIModule(ITmmUIModule module) {
        this.btnUpdate.setAction(module.getUpdateAction());
        this.btnUpdate.setIcons(module.getSearchButtonIcon(), module.getSearchButtonHoverIcon());
        this.btnSearch.setAction(module.getSearchAction());
        this.btnEdit.setAction(module.getEditAction());
        this.btnRename.setAction(module.getRenameAction());
        this.menuUpdate.setPopupMenu(module.getUpdateMenu());
        this.menuSearch.setPopupMenu(module.getSearchMenu());
        this.menuEdit.setPopupMenu(module.getEditMenu());
        this.menuRename.setPopupMenu(module.getRenameMenu());
    }
}

