/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;

public class MovieSubtitleChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleChooserModel.class);
    public static final MovieSubtitleChooserModel EMPTY_RESULT = new MovieSubtitleChooserModel();
    private MediaLanguages language = null;
    private SubtitleSearchResult result = null;
    private String name = "";
    private String releaseName = "";

    public MovieSubtitleChooserModel(SubtitleSearchResult result, MediaLanguages language) {
        this.result = result;
        this.language = language;
        this.name = result.getTitle();
        this.releaseName = result.getReleaseName();
    }

    private MovieSubtitleChooserModel() {
        this.name = TmmResourceBundle.getString("chooser.nothingfound");
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getDownloadUrl() throws ScrapeException {
        if (this.result == null) {
            return "";
        }
        return this.result.getUrl();
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }
}

