/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieCertificationFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaCertification> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieCertificationFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCertificationArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCertificationArray();
        this.movieList.addPropertyChangeListener("certification", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieCertification";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains((Object)movie.getCertification());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
    }

    private void buildAndInstallCertificationArray() {
        ArrayList<MediaCertification> certifications = new ArrayList<MediaCertification>(this.movieList.getCertificationsInMovies());
        Collections.sort(certifications);
        this.setValues(certifications);
    }

    @Override
    protected String parseTypeToString(MediaCertification type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaCertification parseStringToType(String string) throws Exception {
        return MediaCertification.valueOf(string);
    }
}

