/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class MovieSetChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetChooserModel.class);
    public static final MovieSetChooserModel EMPTY_RESULT = new MovieSetChooserModel();
    private final List<MovieInSet> movies = ObservableCollections.observableList(new ArrayList());
    private final List<MovieSet.MovieSetMovie> movieSetMovies = new ArrayList<MovieSet.MovieSetMovie>();
    private MediaScraper scraper;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private String name = "";
    private String posterUrl = "";
    private String fanartUrl = "";
    private String overview = "";
    private int tmdbId = 0;
    private boolean scraped;

    public MovieSetChooserModel(MediaSearchResult result) {
        this.result = result;
        this.setName(result.getTitle());
        this.setTmdbId(result.getIdAsInt(result.getProviderId()));
        this.setPosterUrl(result.getPosterUrl());
        try {
            List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
            if (!sets.isEmpty()) {
                this.scraper = sets.get(0);
            }
        }
        catch (Exception e) {
            this.scraper = null;
        }
    }

    private MovieSetChooserModel() {
        this.setName(TmmResourceBundle.getString("chooser.nothingfound"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", "", name);
    }

    public void setOverview(String overview) {
        this.overview = overview;
        this.firePropertyChange("overview", "", overview);
    }

    public int getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(int tmdbId) {
        this.tmdbId = tmdbId;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
        this.firePropertyChange("posterUrl", "", posterUrl);
    }

    public void setFanartUrl(String fanartUrl) {
        this.fanartUrl = fanartUrl;
        this.firePropertyChange("fanartUrl", "", fanartUrl);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public String getFanartUrl() {
        return this.fanartUrl;
    }

    public void matchWithExistingMovies() {
        List<Movie> moviesFromMovieList = MovieModuleManager.getInstance().getMovieList().getMovies();
        block0: for (MovieInSet mis : this.movies) {
            String imdbId;
            if (mis.tmdbId > 0) {
                for (Movie movie : moviesFromMovieList) {
                    if (movie.getTmdbId() != mis.tmdbId) continue;
                    mis.setMovie(movie);
                    break;
                }
            }
            if (mis.getMovie() != null) continue;
            if (!MediaIdUtil.isValidImdbId(mis.imdbId) && mis.tmdbId > 0 && MediaIdUtil.isValidImdbId(imdbId = MediaIdUtil.getMovieImdbIdViaTmdbId(mis.tmdbId))) {
                mis.imdbId = imdbId;
            }
            if (!MediaIdUtil.isValidImdbId(mis.imdbId)) continue;
            for (Movie movie : moviesFromMovieList) {
                if (!mis.imdbId.equals(movie.getImdbId())) continue;
                mis.setMovie(movie);
                continue block0;
            }
        }
    }

    public void scrapeMetadata() {
        block12: {
            try {
                MediaMetadata info;
                if (this.scraper.getMediaProvider() == null) break block12;
                MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                options.setSearchResult(this.result);
                options.setTmdbId(this.result.getIdAsInt(this.result.getProviderId()));
                options.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                try {
                    info = ((IMovieSetMetadataProvider)this.scraper.getMediaProvider()).getMetadata(options);
                }
                catch (MissingIdException e) {
                    LOGGER.warn("missing id for scrape");
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "scraper.error.missingid"));
                    return;
                }
                catch (ScrapeException e) {
                    LOGGER.error("getMetadata", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                    return;
                }
                if (info == null) break block12;
                this.metadata = info;
                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                    this.setFanartUrl(info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0).getOriginalUrl());
                }
                this.setName(info.getTitle());
                this.setOverview(info.getPlot());
                for (MediaMetadata item : info.getSubItems()) {
                    MovieInSet movie = new MovieInSet(item.getTitle());
                    movie.setYear(item.getYear());
                    try {
                        movie.setTmdbId(Integer.parseInt(item.getId("tmdb").toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (item.getReleaseDate() != null) {
                        movie.setReleaseDate(new SimpleDateFormat("yyyy-MM-dd").format(item.getReleaseDate()));
                    }
                    this.movies.add(movie);
                    MovieSet.MovieSetMovie movieSetMovie = new MovieSet.MovieSetMovie();
                    movieSetMovie.setMetadata(item, new ArrayList<MovieScraperMetadataConfig>(Arrays.asList(MovieScraperMetadataConfig.values())), true);
                    movieSetMovie.setLastScraperId(this.scraper.getMediaProvider().getId());
                    movieSetMovie.setLastScrapeLanguage(options.getLanguage().name());
                    if (!item.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                        movieSetMovie.setArtworkUrl(item.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0).getOriginalUrl(), MediaFileType.POSTER);
                    }
                    if (!item.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                        movieSetMovie.setArtworkUrl(item.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0).getOriginalUrl(), MediaFileType.FANART);
                    }
                    this.movieSetMovies.add(movieSetMovie);
                }
                Collections.sort(this.movies);
                this.matchWithExistingMovies();
                this.scraped = true;
            }
            catch (Exception e) {
                LOGGER.error("scrapeMedia", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    public String getOverview() {
        return this.overview;
    }

    public List<MovieInSet> getMovies() {
        return this.movies;
    }

    public List<MovieSet.MovieSetMovie> getMovieSetMovies() {
        return this.movieSetMovies;
    }

    public void startArtworkScrapeTask(MovieSet movieSet, List<MovieSetScraperMetadataConfig> config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(movieSet, config));
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public static class MovieInSet
    extends AbstractModelObject
    implements Comparable<MovieInSet> {
        private final String name;
        private int tmdbId = 0;
        private String imdbId = "";
        private String releaseDate = "";
        private int year = 0;
        private Movie movie = null;

        public MovieInSet(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getYear() {
            return this.year;
        }

        public int getTmdbId() {
            return this.tmdbId;
        }

        public String getImdbId() {
            return this.imdbId;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public Movie getMovie() {
            return this.movie;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public void setTmdbId(int tmdbId) {
            this.tmdbId = tmdbId;
        }

        public void setImdbId(String imdbId) {
            this.imdbId = imdbId;
        }

        public void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public void setMovie(Movie movie) {
            this.movie = movie;
            this.firePropertyChange("movie", null, movie);
        }

        @Override
        public int compareTo(MovieInSet o) {
            return this.releaseDate.compareTo(o.releaseDate);
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private final MovieSet movieSetToScrape;
        private final List<MovieSetScraperMetadataConfig> config;

        public ArtworkScrapeTask(MovieSet movieSet, List<MovieSetScraperMetadataConfig> config) {
            super(TmmResourceBundle.getString("message.scrape.artwork") + " " + movieSet.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieSetToScrape = movieSet;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!MovieSetChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE_SET);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(MovieSetChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieSetChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieSetChooserModel.this.metadata.getId("tmdbSet"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
            options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
            for (MediaScraper artworkScraper : MovieModuleManager.getInstance().getMovieList().getDefaultArtworkScrapers()) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("could not get artwork: {}", (Object)e.getMessage());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieSetToScrape, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)MovieSetChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(MovieSetChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setOriginalUrl(MovieSetChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(MovieSetChooserModel.this.getPosterUrl());
                ma.addImageSize(0, 0, MovieSetChooserModel.this.getPosterUrl(), 0);
                artwork.add(ma);
            }
            this.movieSetToScrape.setArtwork(artwork, this.config);
        }
    }
}

