/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.label.TmmMenuLabel;
import org.tinymediamanager.ui.components.tabbedpane.MainTabbedPane;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.panels.MovieArtworkPanel;
import org.tinymediamanager.ui.movies.panels.MovieCastPanel;
import org.tinymediamanager.ui.movies.panels.MovieInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieMediaInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieTrailerPanel;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.moviesets.actions.DebugDumpMovieSetAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetBatchEditMovieAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetCleanupArtworkAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditMovieAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetExportAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetExportMovieAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetMissingArtworkAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetReadMovieNfoAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRemoveAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRemoveMovieFromSetAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRenameAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRewriteNfoAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetScrapeMissingMoviesAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSearchAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSyncSelectedCollectionTraktTvAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSyncSelectedRatingTraktTvAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSyncSelectedWatchedTraktTvAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetToggleWatchedFlagAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetUpdateMovieAction;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetFilterDialog;
import org.tinymediamanager.ui.moviesets.panels.MovieSetArtworkPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetInformationPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetMediaInformationPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetMissingMovieInformationPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetTreePanel;
import org.tinymediamanager.ui.moviesets.settings.MovieSetSettingsNode;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;

public class MovieSetUIModule
extends AbstractTmmUIModule {
    private static final String ID = "movieSets";
    private static MovieSetUIModule instance = null;
    private final MovieSetSelectionModel selectionModel = new MovieSetSelectionModel();
    private final MovieSelectionModel movieSelectionModel = new MovieSelectionModel();
    private final MovieSetTreePanel treePanel = new MovieSetTreePanel(this.selectionModel);
    private final JPanel detailPanel = new JPanel();
    private final JPanel dataPanel;
    private final MovieSetFilterDialog movieSetFilterDialog;
    private final TmmSettingsNode settingsNode;

    private MovieSetUIModule() {
        this.detailPanel.setLayout(new CardLayout());
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)this.dataPanel, "cell 0 0, grow");
        MainTabbedPane movieSetDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        movieSetDetailPanel.addTab(TmmResourceBundle.getString("metatag.details"), new MovieSetInformationPanel(this.selectionModel));
        movieSetDetailPanel.addTab(TmmResourceBundle.getString("metatag.mediafiles"), new MovieSetMediaInformationPanel(this.selectionModel));
        movieSetDetailPanel.addTab(TmmResourceBundle.getString("metatag.artwork"), new MovieSetArtworkPanel(this.selectionModel));
        this.dataPanel.add((Component)movieSetDetailPanel, "movieSet");
        MainTabbedPane movieDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        movieDetailPanel.addTab(TmmResourceBundle.getString("metatag.details"), new MovieInformationPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(TmmResourceBundle.getString("metatag.cast"), new MovieCastPanel(this.movieSelectionModel){

            @Override
            public String getName() {
                return "movieset.moviecast";
            }
        });
        movieDetailPanel.addTab(TmmResourceBundle.getString("metatag.mediafiles"), new MovieMediaInformationPanel(this.movieSelectionModel){

            @Override
            public String getName() {
                return "movieset.moviemediainformation";
            }
        });
        movieDetailPanel.addTab(TmmResourceBundle.getString("metatag.artwork"), new MovieArtworkPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(TmmResourceBundle.getString("metatag.trailer"), new MovieTrailerPanel(this.movieSelectionModel){

            @Override
            public String getName() {
                return "movieset.movietrailer";
            }
        });
        this.dataPanel.add((Component)movieDetailPanel, "movie");
        this.movieSetFilterDialog = new MovieSetFilterDialog(this.treePanel.getTreeTable());
        MainTabbedPane missingMovieDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        missingMovieDetailPanel.addTab(TmmResourceBundle.getString("metatag.details"), new MovieSetMissingMovieInformationPanel(this.movieSelectionModel));
        this.dataPanel.add((Component)missingMovieDetailPanel, "missingMovie");
        this.createActions();
        this.createPopupMenu();
        this.registerAccelerators();
        this.settingsNode = new MovieSetSettingsNode();
        this.init();
    }

    public static MovieSetUIModule getInstance() {
        if (instance == null) {
            instance = new MovieSetUIModule();
        }
        return instance;
    }

    private void init() {
        if (MovieModuleManager.getInstance().getSettings().isStoreMovieSetUiFilters()) {
            SwingUtilities.invokeLater(() -> this.treePanel.getTreeTable().setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieSetUiFilters()));
        }
    }

    public void setFilterDialogVisible(boolean visible) {
        this.movieSetFilterDialog.setVisible(visible);
    }

    private void createActions() {
        this.updateAction = this.createAndRegisterAction(MovieSetAddAction.class);
        this.searchAction = this.createAndRegisterAction(MovieSetSearchAction.class);
        this.editAction = this.createAndRegisterAction(MovieSetEditAction.class);
        this.renameAction = this.createAndRegisterAction(MovieSetRenameAction.class);
    }

    private void createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new TmmMenuLabel(TmmResourceBundle.getString("metatag.movieset")));
        popupMenu.add(this.createAndRegisterAction(MovieSetSearchAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetScrapeMissingMoviesAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetAddAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetEditAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetRewriteNfoAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetCleanupArtworkAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetMissingArtworkAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetExportAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetRemoveAction.class));
        popupMenu.addSeparator();
        popupMenu.add(new TmmMenuLabel(TmmResourceBundle.getString("metatag.movie")));
        popupMenu.add(this.createAndRegisterAction(MovieSetUpdateMovieAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetEditMovieAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetBatchEditMovieAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetToggleWatchedFlagAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetReadMovieNfoAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetRenameAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetExportMovieAction.class));
        popupMenu.add(this.createAndRegisterAction(MovieSetRemoveMovieFromSetAction.class));
        popupMenu.addSeparator();
        JMenu traktMenu = new JMenu("Trakt.tv");
        traktMenu.setIcon(IconManager.MENU);
        traktMenu.add(this.createAndRegisterAction(MovieSetSyncSelectedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSetSyncSelectedCollectionTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSetSyncSelectedWatchedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(MovieSetSyncSelectedRatingTraktTvAction.class));
        popupMenu.add(traktMenu);
        JMenu kodiRPCMenu = KodiRPCMenu.createMenuKodiMenuRightClickMovieSets();
        popupMenu.add(kodiRPCMenu);
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpMovieSetAction());
            popupMenu.addSeparator();
            popupMenu.add(debugMenu);
        }
        this.treePanel.setPopupMenu(popupMenu);
        this.updatePopupMenu = new JPopupMenu(TmmResourceBundle.getString("movieset.add"));
        this.updatePopupMenu.setToolTipText(TmmResourceBundle.getString("movieset.add"));
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieSetAddAction.class));
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.treePanel;
    }

    @Override
    public String getTabTitle() {
        return TmmResourceBundle.getString("tmm.moviesets");
    }

    @Override
    public ImageIcon getMenuIcon() {
        return IconManager.MENU_MOVIESETS;
    }

    @Override
    public ImageIcon getMenuActiveIcon() {
        return IconManager.MENU_MOVIESETS_ACTIVE;
    }

    @Override
    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    @Override
    public Icon getSearchButtonIcon() {
        return IconManager.TOOLBAR_ADD_MOVIE_SET;
    }

    @Override
    public Icon getSearchButtonHoverIcon() {
        return IconManager.TOOLBAR_ADD_MOVIE_SET_HOVER;
    }

    public MovieSetSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    public void setSelectedMovieSet(MovieSet movieSet) {
        this.selectionModel.setSelectedMovieSet(movieSet);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "movieSet");
    }

    public void setSelectedMovie(Movie movie) {
        this.movieSelectionModel.setSelectedMovie(movie);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        if (movie instanceof MovieSet.MovieSetMovie) {
            cl.show(this.dataPanel, "missingMovie");
        } else {
            cl.show(this.dataPanel, "movie");
        }
    }
}

