/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRewriteNfoAction
extends TmmAction {
    public MovieSetRewriteNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.rewritenfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        if (MovieModuleManager.getInstance().getSettings().getMovieSetNfoFilenames().isEmpty()) {
            return;
        }
        if (selectedMovieSets.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("movieset.rewritenfo"), selectedMovieSets.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (MovieSet movieSet : selectedMovieSets) {
                    movieSet.writeNFO();
                    movieSet.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

