/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowChooserModel;

class TvShowChooserEpisodeListDialog
extends TmmDialog {
    private final TvShowChooserModel tvShowChooserModel;
    private final EventList<EpisodeContainer> episodes;
    private final JComboBox<MediaEpisodeGroup> cbEpisodeGroup;
    private final TmmTable tableEpisodes;

    public TvShowChooserEpisodeListDialog(JDialog owner, TvShow tvShow, TvShowChooserModel model) {
        super(owner, TmmResourceBundle.getString("tvshowchooser.episodelist"), "tvShowChooserEpisodeList");
        this.tvShowChooserModel = model;
        this.episodes = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(EpisodeContainer.class));
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[600lp:900lp,grow]", "[][400lp:500lp,grow]"));
        this.cbEpisodeGroup = new JComboBox();
        this.cbEpisodeGroup.addItemListener(event -> this.mixinEpisodeNumbers());
        contentPanel.add(this.cbEpisodeGroup, "cell 0 0");
        TmmTableModel<EpisodeContainer> tableModel = new TmmTableModel<EpisodeContainer>(this.episodes, new EpisodeContainerTableFormat());
        this.tableEpisodes = new TmmTable((TableModel)((Object)tableModel));
        this.tableEpisodes.setAutoResizeMode(0);
        JScrollPane scrollPaneFiles = new JScrollPane();
        this.tableEpisodes.configureScrollPane(scrollPaneFiles);
        contentPanel.add((Component)scrollPaneFiles, "cell 0 1,grow");
        scrollPaneFiles.setViewportView(this.tableEpisodes);
        model.getEpisodeGroups().forEach(this.cbEpisodeGroup::addItem);
        this.cbEpisodeGroup.setSelectedItem(model.getEpisodeGroup());
        ArrayList<TvShowEpisode> epl = new ArrayList<TvShowEpisode>(tvShow.getEpisodes());
        epl.sort(Comparator.comparingInt(o -> o.getSeason()).thenComparingInt(TvShowEpisode::getEpisode));
        for (TvShowEpisode episode : epl) {
            EpisodeContainer container = new EpisodeContainer(episode);
            this.episodes.add((Object)container);
        }
        this.mixinEpisodeNumbers();
    }

    private void mixinEpisodeNumbers() {
        MediaEpisodeGroup episodeGroup = (MediaEpisodeGroup)this.cbEpisodeGroup.getSelectedItem();
        block0: for (EpisodeContainer episodeContainer : this.episodes) {
            episodeContainer.clearData();
            if (episodeGroup == null) continue;
            for (MediaMetadata md : this.tvShowChooserModel.getEpisodeList()) {
                LocalDate mddate;
                LocalDate epdate;
                MediaEpisodeNumber episodeNumber = md.getEpisodeNumber(episodeGroup);
                if (episodeNumber == null) continue;
                if (episodeContainer.tvShowEpisode.getSeason() == episodeNumber.season() && episodeContainer.tvShowEpisode.getEpisode() == episodeNumber.episode()) {
                    episodeContainer.setTitle(md.getTitle());
                    continue block0;
                }
                if (episodeContainer.tvShowEpisode.getSeason() > 0 && episodeContainer.tvShowEpisode.getEpisode() > 0 || episodeContainer.tvShowEpisode.getFirstAired() == null || md.getReleaseDate() == null || !(epdate = episodeContainer.getFirstAired()).equals(mddate = DateUtils.toLocalD(md.getReleaseDate()))) continue;
                episodeContainer.setTitle(md.getTitle());
                continue block0;
            }
        }
        this.tableEpisodes.adjustColumnPreferredWidths(6);
    }

    private static class EpisodeContainer
    extends AbstractModelObject {
        private final TvShowEpisode tvShowEpisode;
        String title;
        float score;

        public EpisodeContainer(TvShowEpisode tvShowEpisode) {
            this.tvShowEpisode = tvShowEpisode;
        }

        public void clearData() {
            this.setTitle("");
        }

        public String getFilename() {
            return this.tvShowEpisode.getMainVideoFile().getFilename();
        }

        public int getEpisode() {
            return this.tvShowEpisode.getEpisode();
        }

        public int getSeason() {
            return this.tvShowEpisode.getSeason();
        }

        public String getEpisodeTitle() {
            return this.tvShowEpisode.getTitle();
        }

        public LocalDate getFirstAired() {
            return this.tvShowEpisode.getFirstAired() == null ? null : DateUtils.toLocalD(this.tvShowEpisode.getFirstAired());
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String newValue) {
            String oldValue = this.title;
            this.title = newValue;
            this.firePropertyChange("title", oldValue, newValue);
            this.calculateScore();
        }

        public String getScore() {
            return String.format("%.0f %%", Float.valueOf(this.score * 100.0f));
        }

        public void calculateScore() {
            float score = 0.0f;
            if (StringUtils.isNotBlank((CharSequence)this.title)) {
                float titleScore = MetadataUtil.calculateScore(this.title, this.tvShowEpisode.getTitle());
                String cleanedFilename = TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(this.tvShowEpisode.getMainVideoFile().getBasename(), this.tvShowEpisode.getTvShow().getTitle());
                float filenameScore = MetadataUtil.calculateScore(this.title, cleanedFilename);
                score = Math.max(titleScore, filenameScore);
            }
            float oldValue = this.score;
            this.score = score;
            this.firePropertyChange("score", Float.valueOf(oldValue), Float.valueOf(this.score));
        }
    }

    private static class EpisodeContainerTableFormat
    extends TmmTableFormat<EpisodeContainer> {
        public EpisodeContainerTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.season"), "season", EpisodeContainer::getSeason, Integer.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", EpisodeContainer::getEpisode, Integer.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aired"), "aired", EpisodeContainer::getFirstAired, LocalDate.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", EpisodeContainer::getFilename, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "localTitle", EpisodeContainer::getEpisodeTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode.group"), "title", EpisodeContainer::getTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.similarityscore"), "score", EpisodeContainer::getScore, String.class);
            col.setHeaderIcon(IconManager.VIDEO_BITRATE);
            col.setCellRenderer(new RightAlignTableCellRenderer());
            this.addColumn(col);
        }
    }
}

