/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.EnhancedTextField;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeChooserModel;

public class TvShowEpisodeChooserDialog
extends TmmDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeChooserDialog.class);
    private final TvShowEpisode episode;
    private final MediaScraper mediaScraper;
    private final ObservableElementList<TvShowEpisodeChooserModel> episodeEventList;
    private MediaMetadata metadata;
    private final List<TvShowEpisodeChooserModel> selectedEpisodes;
    private final SortedList<TvShowEpisodeChooserModel> sortedEpisodes;
    private final SearchTask task;
    private final TmmTable table;
    private final JTextField textField;
    private final JProgressBar progressBar;
    private final JLabel lblProgressAction;
    private JTextArea taPlot;

    public TvShowEpisodeChooserDialog(JDialog parent, TvShowEpisode ep, MediaScraper mediaScraper) {
        super(parent, TmmResourceBundle.getString("tvshowepisode.choose"), "episodeChooser");
        this.episode = ep;
        this.mediaScraper = mediaScraper;
        this.metadata = new MediaMetadata(mediaScraper.getId());
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisodeChooserModel.class));
        this.sortedEpisodes = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), (Comparator)new EpisodeComparator());
        JPanel panelPath = new JPanel();
        panelPath.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JLabel lblPath = new JLabel(this.episode.getPathNIO().resolve(this.episode.getMainVideoFile().getFilename()).toString());
        TmmFontHelper.changeFont(lblPath, 1.16667, 1);
        panelPath.add((Component)lblPath, "cell 0 0, wmin 0");
        this.setTopInformationPanel(panelPath);
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[700lp:900lp,grow]", "[500lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        contentPanel.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout((LayoutManager)new MigLayout("", "[350lp:450lp,grow]", "[][400lp,grow]"));
        this.textField = EnhancedTextField.createSearchTextField();
        panelLeft.add((Component)this.textField, "cell 0 0, growx");
        this.textField.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        panelLeft.add((Component)scrollPane, "cell 0 1,grow");
        splitPane.setLeftComponent(panelLeft);
        TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor((JTextComponent)this.textField, (TextFilterator)new TvShowEpisodeChooserModelFilterator());
        FilterList textFilteredEpisodes = new FilterList(this.sortedEpisodes, (MatcherEditor)textMatcherEditor);
        AdvancedTableModel episodeTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)textFilteredEpisodes, (TableFormat)new EpisodeTableFormat());
        DefaultEventSelectionModel selectionModel = new DefaultEventSelectionModel((EventList)textFilteredEpisodes);
        this.selectedEpisodes = selectionModel.getSelected();
        selectionModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedEpisodes.isEmpty()) {
                TvShowEpisodeChooserModel episode = this.selectedEpisodes.get(0);
                this.taPlot.setText(episode.getOverview());
            } else {
                this.taPlot.setText("");
            }
            this.taPlot.setCaretPosition(0);
        });
        this.table = new TmmTable((TableModel)episodeTableModel);
        this.table.setSelectionModel((ListSelectionModel)selectionModel);
        this.table.configureScrollPane(scrollPane);
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("", "[300lp:400lp,grow]", "[400lp,grow]"));
        NoBorderScrollPane scrollPane_1 = new NoBorderScrollPane();
        panelRight.add((Component)scrollPane_1, "cell 0 0,grow");
        splitPane.setRightComponent(panelRight);
        this.taPlot = new ReadOnlyTextArea();
        scrollPane_1.setViewportView(this.taPlot);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        cancelButton.setToolTipText(TmmResourceBundle.getString("edit.discard"));
        cancelButton.setIcon(IconManager.CANCEL_INV);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.addButton(cancelButton);
        final JButton okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        okButton.setToolTipText(TmmResourceBundle.getString("tvshow.change"));
        okButton.setIcon(IconManager.APPLY_INV);
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        this.addDefaultButton(okButton);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    TvShowEpisodeChooserDialog.this.actionPerformed(new ActionEvent(okButton, 1001, "OK"));
                }
            }
        });
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        this.table.getColumnModel().getColumn(1).setMaxWidth(50);
        this.table.getColumnModel().getColumn(2).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setMaxWidth(110);
        this.task = new SearchTask();
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(TmmResourceBundle.getString("chooser.scrapeepisodes"));
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            this.task.execute();
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand()) && !this.selectedEpisodes.isEmpty()) {
            TvShowEpisodeChooserModel episode = this.selectedEpisodes.get(0);
            if (episode != TvShowEpisodeChooserModel.emptyResult) {
                this.metadata = episode.getMediaMetadata();
            }
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
            }
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
            }
            this.setVisible(false);
        }
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    private static class EpisodeComparator
    implements Comparator<TvShowEpisodeChooserModel> {
        private EpisodeComparator() {
        }

        @Override
        public int compare(TvShowEpisodeChooserModel o1, TvShowEpisodeChooserModel o2) {
            int result = Integer.compare(o1.getSeason(), o2.getSeason());
            if (result == 0) {
                result = Integer.compare(o1.getEpisode(), o2.getEpisode());
            }
            return result;
        }
    }

    private static class TvShowEpisodeChooserModelFilterator
    implements TextFilterator<TvShowEpisodeChooserModel> {
        private TvShowEpisodeChooserModelFilterator() {
        }

        public void getFilterStrings(List<String> baseList, TvShowEpisodeChooserModel model) {
            baseList.add(model.getTitle());
            baseList.add(model.getOverview());
        }
    }

    private static class EpisodeTableFormat
    implements TableFormat<TvShowEpisodeChooserModel> {
        private EpisodeTableFormat() {
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return TmmResourceBundle.getString("metatag.season");
                }
                case 1: {
                    return TmmResourceBundle.getString("metatag.episode");
                }
                case 2: {
                    return TmmResourceBundle.getString("metatag.aired");
                }
                case 3: {
                    return TmmResourceBundle.getString("metatag.title");
                }
            }
            return null;
        }

        public Object getColumnValue(TvShowEpisodeChooserModel baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.getSeason();
                }
                case 1: {
                    return baseObject.getEpisode();
                }
                case 2: {
                    return baseObject.getFirstAiredFormatted();
                }
                case 3: {
                    return baseObject.getTitle();
                }
            }
            return null;
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final List<TvShowEpisodeChooserModel> searchResults = new ArrayList<TvShowEpisodeChooserModel>();
        private Throwable error = null;
        boolean cancel = false;

        private SearchTask() {
        }

        @Override
        public Void doInBackground() {
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
            options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
            options.setIds(TvShowEpisodeChooserDialog.this.episode.getTvShow().getIds());
            try {
                for (MediaMetadata md : ((ITvShowMetadataProvider)TvShowEpisodeChooserDialog.this.mediaScraper.getMediaProvider()).getEpisodeList(options)) {
                    this.searchResults.add(new TvShowEpisodeChooserModel(md));
                }
            }
            catch (MissingIdException e) {
                this.error = e;
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, TvShowEpisodeChooserDialog.this.episode, "scraper.error.missingid"));
            }
            catch (ScrapeException e) {
                this.error = e;
                LOGGER.error("searchMovieFallback", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)TvShowEpisodeChooserDialog.this.episode, "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
            }
            return null;
        }

        @Override
        protected void done() {
            TvShowEpisodeChooserDialog.this.episodeEventList.clear();
            if (this.error != null) {
                TvShowEpisodeChooserDialog.this.episodeEventList.add((Object)TvShowEpisodeChooserModel.emptyResult);
            } else if (!this.cancel) {
                if (ListUtils.isEmpty(this.searchResults)) {
                    TvShowEpisodeChooserDialog.this.episodeEventList.add((Object)TvShowEpisodeChooserModel.emptyResult);
                } else {
                    TvShowEpisodeChooserDialog.this.episodeEventList.addAll(this.searchResults);
                }
            }
            TvShowEpisodeChooserDialog.this.table.adjustColumnPreferredWidths(5);
            if (TvShowEpisodeChooserDialog.this.textField.getText().isEmpty()) {
                TvShowEpisodeChooserModel model;
                int i;
                int index = -1;
                for (i = 0; i < TvShowEpisodeChooserDialog.this.sortedEpisodes.size(); ++i) {
                    model = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.sortedEpisodes.get(i);
                    if (!this.equals(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(TvShowEpisodeChooserDialog.this.episode.getVideoBasenameWithoutStacking(), TvShowEpisodeChooserDialog.this.episode.getTvShow().getTitle()), model.getTitle())) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    for (i = 0; i < TvShowEpisodeChooserDialog.this.sortedEpisodes.size(); ++i) {
                        model = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.sortedEpisodes.get(i);
                        if (!this.equals(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(TvShowEpisodeChooserDialog.this.episode.getTitle(), TvShowEpisodeChooserDialog.this.episode.getTvShow().getTitle()), model.getTitle())) continue;
                        index = i;
                        break;
                    }
                }
                if (index < 0) {
                    for (i = 0; i < TvShowEpisodeChooserDialog.this.sortedEpisodes.size(); ++i) {
                        model = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.sortedEpisodes.get(i);
                        if (!((double)MetadataUtil.calculateScore(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(TvShowEpisodeChooserDialog.this.episode.getTitle(), TvShowEpisodeChooserDialog.this.episode.getTvShow().getTitle()), model.getTitle()) > 0.8)) continue;
                        index = i;
                        break;
                    }
                }
                if (index > -1) {
                    TvShowEpisodeChooserDialog.this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.scrollToVisible(index, 0);
                }
                SwingUtilities.invokeLater(() -> {
                    TvShowEpisodeChooserDialog.this.lblProgressAction.setVisible(false);
                    TvShowEpisodeChooserDialog.this.progressBar.setVisible(false);
                });
            }
        }

        private boolean equals(String title1, String title2) {
            String cleaned1 = title1.replaceAll("[!?,._-]", " ").replaceAll("\\s+", " ").strip();
            String cleaned2 = title2.replaceAll("[!?,._-]", " ").replaceAll("\\s+", " ").strip();
            return cleaned1.equalsIgnoreCase(cleaned2);
        }

        private void scrollToVisible(int rowIndex, int vColIndex) {
            if (!(TvShowEpisodeChooserDialog.this.table.getParent() instanceof JViewport)) {
                return;
            }
            if (TvShowEpisodeChooserDialog.this.table.getRowCount() < 1) {
                return;
            }
            Dimension viewportExtentSize = ((JViewport)TvShowEpisodeChooserDialog.this.table.getParent()).getExtentSize();
            Dimension cellDimension = new Dimension(0, 0);
            Rectangle rect = TvShowEpisodeChooserDialog.this.table.getCellRect(rowIndex, vColIndex, true);
            if (rowIndex + 1 < TvShowEpisodeChooserDialog.this.table.getRowCount()) {
                if (vColIndex + 1 < TvShowEpisodeChooserDialog.this.table.getColumnCount()) {
                    ++vColIndex;
                }
                Rectangle rectOne = TvShowEpisodeChooserDialog.this.table.getCellRect(rowIndex + 1, vColIndex, true);
                cellDimension.width = rectOne.x - rect.x;
                cellDimension.height = rectOne.y - rect.y;
            }
            rect.setLocation(rect.x + viewportExtentSize.width - cellDimension.width, rect.y + viewportExtentSize.height - cellDimension.height);
            TvShowEpisodeChooserDialog.this.table.scrollRectToVisible(rect);
        }
    }
}

