/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.SubtitleDownloadTask;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowSubtitleProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowSubtitleChooserModel;

public class TvShowSubtitleChooserDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleChooserDialog.class);
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final TvShowEpisode episodeToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private final EventList<TvShowSubtitleChooserModel> subtitleEventList;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private TmmTable tableSubs;
    private JComboBox<MediaLanguages> cbLanguage;
    private MediaScraperCheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JButton btnSearch;

    public TvShowSubtitleChooserDialog(TvShowEpisode episode, MediaFile mediaFile, boolean inQueue) {
        super(TmmResourceBundle.getString("tvshowepisodesubtitlechooser.search"), "episodeSubtitleChooser");
        this.episodeToScrape = episode;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowSubtitleChooserModel.class)));
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : this.tvShowList.getAvailableSubtitleScrapers()) {
            if (!TvShowModuleManager.getInstance().getSettings().getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        for (MediaLanguages language : MediaLanguages.valuesSorted()) {
            this.cbLanguage.addItem(language);
            if (language != TvShowModuleManager.getInstance().getSettings().getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem((Object)language);
        }
        this.btnSearch.addActionListener(e -> this.searchSubtitle());
        this.cbLanguage.addActionListener(e -> this.searchSubtitle());
        this.searchSubtitle();
    }

    private void initComponents() {
        JPanel panelTitle = new JPanel();
        panelTitle.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JLabel lblEpisodeTitle = new JLabel(this.episodeToScrape.getTitle());
        TmmFontHelper.changeFont(lblEpisodeTitle, 1.33, 1);
        panelTitle.add((Component)lblEpisodeTitle, "cell 0 0 5 1,growx, wmin 0");
        this.setTopInformationPanel(panelTitle);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][][shrink 0][200lp,grow]"));
        TmmLabel lblSeasonT = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        panelContent.add((Component)lblSeasonT, "cell 0 0,alignx right");
        JLabel lblSeason = new JLabel(String.valueOf(this.episodeToScrape.getSeason()));
        panelContent.add((Component)lblSeason, "cell 1 0");
        TmmLabel lblEpisodeT = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        panelContent.add((Component)lblEpisodeT, "cell 0 1,alignx right");
        JLabel lblEpisode = new JLabel(String.valueOf(this.episodeToScrape.getEpisode()));
        panelContent.add((Component)lblEpisode, "cell 1 1");
        TmmLabel lblMediaFileNameT = new TmmLabel(TmmResourceBundle.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "cell 0 2,alignx right");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFilename());
        panelContent.add((Component)lblMediaFileName, "cell 1 2 2 1,growx, wmin 0 ");
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelContent.add((Component)lblScraperT, "cell 0 3,alignx right");
        this.cbScraper = new MediaScraperCheckComboBox(this.tvShowList.getAvailableSubtitleScrapers());
        panelContent.add((Component)this.cbScraper, "cell 1 3,growx");
        this.btnSearch = new JButton(TmmResourceBundle.getString("Button.search"));
        panelContent.add((Component)this.btnSearch, "cell 2 3,alignx left");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 4,alignx right");
        this.cbLanguage = new JComboBox();
        panelContent.add(this.cbLanguage, "cell 1 4,growx");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 5 3 1,growx");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "cell 0 6 3 1,grow");
        this.tableSubs = new TmmTable((TableModel)((Object)new TmmTableModel<TvShowSubtitleChooserModel>((EventList<TvShowSubtitleChooserModel>)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), new SubtitleTableFormat())));
        this.tableSubs.configureScrollPane(scrollPaneSubs);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.STOP_INV);
            btnAbortQueue.addActionListener(e -> {
                this.continueQueue = false;
                this.setVisible(false);
            });
            this.addButton(btnAbortQueue);
        }
        JButton btnDone = new JButton(TmmResourceBundle.getString("Button.done"));
        btnDone.setIcon(IconManager.APPLY_INV);
        btnDone.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnDone);
    }

    private void searchSubtitle() {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>(this.cbScraper.getSelectedItems());
        this.activeSearchTask = new SearchTask(this.fileToScrape, this.episodeToScrape.getIds(), this.episodeToScrape.getTvShow().getIds(), this.episodeToScrape.getAiredSeason(), this.episodeToScrape.getAiredEpisode(), scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final MediaFile mediaFile;
        private final int season;
        private final int episode;
        private final Map<String, Object> episodeIds;
        private final Map<String, Object> tvShowIds;
        private final List<SubtitleSearchResult> searchResults;
        private final MediaLanguages language;
        private final List<MediaScraper> scrapers;
        boolean cancel;

        SearchTask(MediaFile mediaFile, Map<String, Object> episodeIds, Map<String, Object> tvShowIds, int season, int episode, List<MediaScraper> scrapers) {
            this.mediaFile = mediaFile;
            this.season = season;
            this.episode = episode;
            this.episodeIds = episodeIds;
            this.tvShowIds = tvShowIds;
            this.language = (MediaLanguages)((Object)TvShowSubtitleChooserDialog.this.cbLanguage.getSelectedItem());
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            TvShowSubtitleChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.searchingfor") + " " + TvShowSubtitleChooserDialog.this.episodeToScrape.getTitle());
            for (MediaScraper scraper : this.scrapers) {
                try {
                    ITvShowSubtitleProvider subtitleProvider = (ITvShowSubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchAndScrapeOptions options = new SubtitleSearchAndScrapeOptions(MediaType.TV_SHOW);
                    options.setMediaFile(this.mediaFile);
                    options.setIds(this.episodeIds);
                    options.setId("tvShowIds", this.tvShowIds);
                    options.setLanguage(this.language);
                    options.setSeason(this.season);
                    options.setEpisode(this.episode);
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id found for scraper {}", (Object)scraper.getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getSubtitles", (Throwable)e);
                    MessageDialog.showExceptionWindow(e);
                }
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                TvShowSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.isEmpty()) {
                    TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)TvShowSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)new TvShowSubtitleChooserModel(result, this.language));
                    }
                }
                if (!TvShowSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    TvShowSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(TvShowSubtitleChooserDialog.this.tableSubs, 7);
            }
            TvShowSubtitleChooserDialog.this.stopProgressBar();
        }
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                TvShowSubtitleChooserModel model = (TvShowSubtitleChooserModel)TvShowSubtitleChooserDialog.this.subtitleEventList.get(row);
                try {
                    if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                        MediaLanguages language = model.getLanguage();
                        String lang = LanguageStyle.getLanguageCodeForStyle(language.name(), TvShowModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = language.name();
                        }
                        String filename = FilenameUtils.getBaseName((String)TvShowSubtitleChooserDialog.this.fileToScrape.getFilename()) + "." + lang;
                        SubtitleDownloadTask task = new SubtitleDownloadTask(model.getDownloadUrl(), TvShowSubtitleChooserDialog.this.episodeToScrape.getPathNIO().resolve(filename), TvShowSubtitleChooserDialog.this.episodeToScrape, lang);
                        TvShowSubtitleChooserDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        TvShowSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                        TvShowSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("subtitle.downloading"));
                        task.run();
                        TvShowSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("subtitle.downloaded") + " - " + model.getReleaseName());
                    }
                }
                catch (Exception ex) {
                    TvShowSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                    TvShowSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("message.scrape.subtitlefaileddownload") + " - " + ex.getLocalizedMessage());
                }
                finally {
                    TvShowSubtitleChooserDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class SubtitleTableFormat
    extends TmmTableFormat<TvShowSubtitleChooserModel> {
        public SubtitleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "icon", model -> IconManager.DOWNLOAD, ImageIcon.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", TvShowSubtitleChooserModel::getName, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.releasename"), "releasename", TvShowSubtitleChooserModel::getReleaseName, String.class);
            this.addColumn(col);
        }
    }
}

